/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.client.hud;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.entity.LostWraithEntity;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class LostWraithBossBar {
    private static final ConcurrentHashMap<UUID, BossBarData> ACTIVE_BOSS_BARS = new ConcurrentHashMap();
    private static final int BAR_WIDTH = 320;
    private static final int BAR_HEIGHT = 16;
    private static final int BORDER_WIDTH = 2;
    private static final int BORDER_COLOR = -7722014;
    private static final int HEALTH_COLOR_START = -16777216;
    private static final int HEALTH_COLOR_END = -11861886;
    private static final int BACKGROUND_COLOR = -15066598;

    public static void showBossBar(LostWraithEntity entity) {
        if (entity != null && entity.m_6084_()) {
            ACTIVE_BOSS_BARS.put(entity.m_20148_(), new BossBarData(entity));
        }
    }

    public static void hideBossBar(UUID entityId) {
        ACTIVE_BOSS_BARS.remove(entityId);
    }

    public static void updateBossBar(LostWraithEntity entity) {
        if (entity != null) {
            BossBarData data = ACTIVE_BOSS_BARS.get(entity.m_20148_());
            if (data != null) {
                data.fadeTimer = 200;
            } else {
                LostWraithBossBar.showBossBar(entity);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay().id().toString().equals("minecraft:hotbar")) {
            LostWraithBossBar.renderBossBars(event.getGuiGraphics());
        }
    }

    private static void renderBossBars(GuiGraphics guiGraphics) {
        if (ACTIVE_BOSS_BARS.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ACTIVE_BOSS_BARS.entrySet().removeIf(entry -> {
            ((BossBarData)entry.getValue()).update();
            return ((BossBarData)entry.getValue()).shouldRemove();
        });
        int yOffset = 0;
        for (BossBarData data : ACTIVE_BOSS_BARS.values()) {
            LostWraithBossBar.renderSingleBossBar(guiGraphics, data, yOffset);
            yOffset += 26;
        }
    }

    private static void renderSingleBossBar(GuiGraphics guiGraphics, BossBarData data, int yOffset) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int barX = (screenWidth - 320) / 2;
        int barY = 20 + yOffset;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float healthPercent = data.maxHealth > 0.0f ? Math.max(0.0f, Math.min(1.0f, data.currentHealth / data.maxHealth)) : 0.0f;
        int healthWidth = (int)(healthPercent * 316.0f);
        guiGraphics.m_280509_(barX, barY, barX + 320, barY + 16, -7722014);
        guiGraphics.m_280509_(barX + 2, barY + 2, barX + 320 - 2, barY + 16 - 2, -15066598);
        if (healthWidth > 0) {
            LostWraithBossBar.renderGradientHealth(guiGraphics, barX + 2, barY + 2, healthWidth, 12);
        }
        MutableComponent nameComponent = Component.m_237113_((String)data.name);
        int textWidth = mc.f_91062_.m_92852_((FormattedText)nameComponent);
        int textX = barX + (320 - textWidth) / 2;
        int textY = barY - 12;
        guiGraphics.m_280430_(mc.f_91062_, (Component)nameComponent, textX, textY, 0xFFFFFF);
        String healthText = String.format("%.0f / %.0f", Float.valueOf(data.currentHealth), Float.valueOf(data.maxHealth));
        MutableComponent healthComponent = Component.m_237113_((String)healthText);
        int healthTextWidth = mc.f_91062_.m_92852_((FormattedText)healthComponent);
        int healthTextX = barX + (320 - healthTextWidth) / 2;
        Objects.requireNonNull(mc.f_91062_);
        int healthTextY = barY + (16 - 9) / 2;
        guiGraphics.m_280430_(mc.f_91062_, (Component)healthComponent, healthTextX, healthTextY, 0xFFFFFF);
        poseStack.m_85849_();
    }

    private static void renderGradientHealth(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        for (int i = 0; i < width; ++i) {
            float progress = (float)i / (float)width;
            int color = LostWraithBossBar.interpolateColor(-16777216, -11861886, progress);
            guiGraphics.m_280509_(x + i, y, x + i + 1, y + height, color);
        }
    }

    private static int interpolateColor(int color1, int color2, float progress) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * progress);
        int r = (int)((float)r1 + (float)(r2 - r1) * progress);
        int g = (int)((float)g1 + (float)(g2 - g1) * progress);
        int b = (int)((float)b1 + (float)(b2 - b1) * progress);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void clearAllBossBars() {
        ACTIVE_BOSS_BARS.clear();
    }

    private static class BossBarData {
        public final LostWraithEntity entity;
        public final String name;
        public float currentHealth;
        public float maxHealth;
        public int fadeTimer;

        public BossBarData(LostWraithEntity entity) {
            this.entity = entity;
            this.name = Component.m_237115_((String)"entity.the_last_sword.lost_wraith").getString();
            this.currentHealth = this.getEntityHealth(entity);
            this.maxHealth = this.getEntityMaxHealth(entity);
            this.fadeTimer = 200;
        }

        public void update() {
            if (this.entity != null && this.entity.m_6084_() && !this.entity.m_213877_()) {
                this.currentHealth = this.getEntityHealth(this.entity);
                this.maxHealth = this.getEntityMaxHealth(this.entity);
                if (this.fadeTimer > 0) {
                    --this.fadeTimer;
                }
            } else {
                this.fadeTimer = 0;
            }
        }

        public boolean shouldRemove() {
            return this.fadeTimer <= 0 || this.entity == null || !this.entity.m_6084_() || this.entity.m_213877_();
        }

        private float getEntityHealth(LostWraithEntity entity) {
            if (DefenceManager.isTracked((LivingEntity)entity)) {
                return DefenceManager.getStoredHealth((LivingEntity)entity);
            }
            return entity.m_21223_();
        }

        private float getEntityMaxHealth(LostWraithEntity entity) {
            if (DefenceManager.isTracked((LivingEntity)entity)) {
                return DefenceManager.getStoredMax((LivingEntity)entity);
            }
            return entity.m_21233_();
        }
    }
}

