/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.the_last_sword.client.model.PerspectiveModelState;
import net.the_last_sword.client.renderer.TheLastEndRenderTypes;
import net.the_last_sword.event.ClientEventHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TheLastEndBakedModel
implements BakedModel {
    private final BakedModel wrappedModel;
    private final ResourceLocation starTexture;
    private final ResourceLocation maskTexture;
    private final float[] bladeUV;
    private final float opacity;
    private final float animationSpeed;
    protected PerspectiveModelState parentState;

    public TheLastEndBakedModel(BakedModel wrapped, ResourceLocation starTexture, ResourceLocation maskTexture, float[] bladeUV, float opacity, float animationSpeed) {
        this.wrappedModel = wrapped;
        this.starTexture = starTexture;
        this.maskTexture = maskTexture;
        this.bladeUV = bladeUV;
        this.opacity = opacity;
        this.animationSpeed = animationSpeed;
    }

    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack pStack, MultiBufferSource source, int light, int overlay) {
        this.parentState = PerspectiveModelState.createForTheLastEndSword();
        this.renderWrappedModel(stack, transformType, pStack, source, light, overlay);
        if (source instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)source;
            bs.m_109911_();
        }
        this.renderTheLastEndEffects(stack, transformType, pStack, source, light, overlay);
    }

    private void renderWrappedModel(ItemStack stack, ItemDisplayContext transformType, PoseStack pStack, MultiBufferSource source, int light, int overlay) {
        Minecraft mc = Minecraft.m_91087_();
        VertexConsumer vertexConsumer = source.m_6299_(RenderType.m_110463_());
        for (Direction direction : Direction.values()) {
            List quads = this.wrappedModel.getQuads(null, direction, mc.f_91073_.f_46441_, ModelData.EMPTY, null);
            if (quads.isEmpty()) continue;
            mc.m_91291_().m_115162_(pStack, vertexConsumer, quads, stack, light, overlay);
        }
        List quads = this.wrappedModel.getQuads(null, null, mc.f_91073_.f_46441_, ModelData.EMPTY, null);
        if (!quads.isEmpty()) {
            mc.m_91291_().m_115162_(pStack, vertexConsumer, quads, stack, light, overlay);
        }
    }

    private void renderTheLastEndEffects(ItemStack stack, ItemDisplayContext transformType, PoseStack pStack, MultiBufferSource source, int light, int overlay) {
        if (ClientEventHandler.THE_LAST_END_SHADER == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (ClientEventHandler.THE_LAST_END_TIME != null) {
            float gameTime = (float)(System.currentTimeMillis() % 1000000L) / 1000.0f;
            ClientEventHandler.THE_LAST_END_TIME.m_5985_(gameTime);
        }
        VertexConsumer theLastEndConsumer = source.m_6299_(TheLastEndRenderTypes.THE_LAST_END_EFFECT);
        for (Direction direction : Direction.values()) {
            List quads = this.wrappedModel.getQuads(null, direction, mc.f_91073_.f_46441_, ModelData.EMPTY, null);
            if (quads.isEmpty()) continue;
            mc.m_91291_().m_115162_(pStack, theLastEndConsumer, quads, stack, light, overlay);
        }
        List quads = this.wrappedModel.getQuads(null, null, mc.f_91073_.f_46441_, ModelData.EMPTY, null);
        if (!quads.isEmpty()) {
            mc.m_91291_().m_115162_(pStack, theLastEndConsumer, quads, stack, light, overlay);
        }
    }

    public PerspectiveModelState getModelState() {
        return this.parentState;
    }

    public BakedModel applyTransform(ItemDisplayContext context, PoseStack pStack, boolean leftFlip) {
        PerspectiveModelState modelState = this.getModelState();
        if (modelState != null) {
            Transformation transform = modelState.getTransform(context);
            if (transform != null) {
                Vector3f trans = transform.m_252829_();
                Vector3f scale = transform.m_252900_();
                pStack.m_252880_(trans.x(), trans.y(), trans.z());
                pStack.m_252781_(transform.m_253244_());
                pStack.m_85841_(scale.x(), scale.y(), scale.z());
                pStack.m_252781_(transform.m_252848_());
                if (leftFlip) {
                    pStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                }
            }
            return this;
        }
        return super.applyTransform(context, pStack, leftFlip);
    }

    public boolean m_7521_() {
        return true;
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public boolean m_7541_() {
        return this.wrappedModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.wrappedModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.wrappedModel.m_7547_();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.wrappedModel.getParticleIcon(data);
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.wrappedModel.m_6160_();
    }

    @NotNull
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return this.wrappedModel.m_213637_(state, side, rand);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        return this.wrappedModel.getQuads(state, side, rand, data, renderType);
    }
}

