/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.the_last_sword.client.model.TheLastEndBakedModel;

public class TheLastEndModelLoader
implements IGeometryLoader<TheLastEndGeometry> {
    public static final TheLastEndModelLoader INSTANCE = new TheLastEndModelLoader();

    public TheLastEndGeometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) throws JsonParseException {
        JsonObject theLastEndObj = GsonHelper.m_13930_((JsonObject)modelContents, (String)"the_last_end");
        if (theLastEndObj == null) {
            throw new IllegalStateException("Missing 'the_last_end' object in The Last End model.");
        }
        String starTexture = GsonHelper.m_13851_((JsonObject)theLastEndObj, (String)"star_texture", (String)"");
        String maskTexture = GsonHelper.m_13851_((JsonObject)theLastEndObj, (String)"mask_texture", (String)"");
        float[] bladeUV = new float[4];
        if (theLastEndObj.has("blade_uv")) {
            JsonArray array = theLastEndObj.getAsJsonArray("blade_uv");
            for (int i = 0; i < 4 && i < array.size(); ++i) {
                bladeUV[i] = array.get(i).getAsFloat();
            }
        } else {
            bladeUV = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
        }
        float opacity = GsonHelper.m_13820_((JsonObject)theLastEndObj, (String)"opacity", (float)0.8f);
        float animationSpeed = GsonHelper.m_13820_((JsonObject)theLastEndObj, (String)"animation_speed", (float)1.0f);
        JsonObject clean = modelContents.deepCopy();
        clean.remove("the_last_end");
        clean.remove("loader");
        BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)clean, BlockModel.class);
        TheLastEndGeometry result = new TheLastEndGeometry(baseModel, starTexture, maskTexture, bladeUV, opacity, animationSpeed);
        return result;
    }

    public static class TheLastEndGeometry
    implements IUnbakedGeometry<TheLastEndGeometry> {
        private final BlockModel baseModel;
        private final String starTexture;
        private final String maskTexture;
        private final float[] bladeUV;
        private final float opacity;
        private final float animationSpeed;

        public TheLastEndGeometry(BlockModel baseModel, String starTexture, String maskTexture, float[] bladeUV, float opacity, float animationSpeed) {
            this.baseModel = baseModel;
            this.starTexture = starTexture;
            this.maskTexture = maskTexture;
            this.bladeUV = bladeUV;
            this.opacity = opacity;
            this.animationSpeed = animationSpeed;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            BakedModel baseBakedModel = this.baseModel.m_111449_(baker, this.baseModel, spriteGetter, modelState, modelLocation, true);
            ResourceLocation starTexLoc = this.starTexture.isEmpty() ? null : new ResourceLocation(this.starTexture);
            ResourceLocation maskTexLoc = this.maskTexture.isEmpty() ? null : new ResourceLocation(this.maskTexture);
            TheLastEndBakedModel result = new TheLastEndBakedModel(baseBakedModel, starTexLoc, maskTexLoc, this.bladeUV, this.opacity, this.animationSpeed);
            return result;
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.baseModel.m_5500_(modelGetter);
        }
    }
}

