/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.entity.TheLastEndSwordWraithEntity;
import net.the_last_sword.entity.ai.TheLastEndSwordWraithAI;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class AllThingsEndSkyRenderer {
    private static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("textures/entity/end_portal.png");
    private static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    private static float skyTime = 0.0f;
    private static boolean forceReset = false;

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SKY) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (forceReset) {
            AllThingsEndSkyRenderer.resetSkyEffects();
            forceReset = false;
        }
        if (AllThingsEndSkyRenderer.hasActiveAllThingsEndNearby((Level)mc.f_91073_, mc.f_91074_.m_20182_())) {
            AllThingsEndSkyRenderer.renderAllThingsEndSky(event.getPoseStack(), event.getProjectionMatrix(), event.getPartialTick(), mc.f_91063_.m_109153_());
        }
    }

    private static boolean hasActiveAllThingsEndNearby(Level level, Vec3 playerPos) {
        List nearbyWraiths = level.m_45976_(TheLastEndSwordWraithEntity.class, new AABB(playerPos.m_82492_(64.0, 64.0, 64.0), playerPos.m_82520_(64.0, 64.0, 64.0)));
        for (TheLastEndSwordWraithEntity wraith : nearbyWraiths) {
            if (!AllThingsEndSkyRenderer.isAllThingsEndActive(wraith)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAllThingsEndActive(TheLastEndSwordWraithEntity wraith) {
        return TheLastEndSwordWraithAI.hasActiveAllThingsEndEffect(wraith);
    }

    private static void renderAllThingsEndSky(PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, Camera camera) {
        skyTime += partialTick * 0.01f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::m_172817_);
        poseStack.m_85836_();
        Vec3 cameraPos = camera.m_90583_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(skyTime * 0.5f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(skyTime * 0.3f));
        AllThingsEndSkyRenderer.renderEndPortalSkybox(poseStack, projectionMatrix);
        poseStack.m_85849_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    private static void renderEndPortalSkybox(PoseStack poseStack, Matrix4f projectionMatrix) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)END_PORTAL_TEXTURE);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        for (int i = 0; i < 6; ++i) {
            poseStack.m_85836_();
            switch (i) {
                case 0: {
                    break;
                }
                case 1: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    break;
                }
                case 2: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                    break;
                }
                case 3: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    break;
                }
                case 4: {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    break;
                }
                case 5: {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                }
            }
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            float size = 100.0f;
            float uvOffset = skyTime * 0.01f + (float)i * 0.1f;
            buffer.m_252986_(matrix, -size, -size, -size).m_7421_(0.0f + uvOffset, 0.0f + uvOffset).m_5752_();
            buffer.m_252986_(matrix, size, -size, -size).m_7421_(1.0f + uvOffset, 0.0f + uvOffset).m_5752_();
            buffer.m_252986_(matrix, size, size, -size).m_7421_(1.0f + uvOffset, 1.0f + uvOffset).m_5752_();
            buffer.m_252986_(matrix, -size, size, -size).m_7421_(0.0f + uvOffset, 1.0f + uvOffset).m_5752_();
            tesselator.m_85914_();
            poseStack.m_85849_();
        }
        AllThingsEndSkyRenderer.renderPortalParticleLayer(poseStack, projectionMatrix);
    }

    private static void renderPortalParticleLayer(PoseStack poseStack, Matrix4f projectionMatrix) {
        RenderSystem.blendFunc((int)770, (int)1);
        poseStack.m_85836_();
        poseStack.m_85841_(1.1f, 1.1f, 1.1f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        for (int layer = 0; layer < 3; ++layer) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(skyTime * (0.5f + (float)layer * 0.2f)));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(skyTime * (0.3f + (float)layer * 0.1f)));
            Matrix4f layerMatrix = poseStack.m_85850_().m_252922_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            float size = 80.0f + (float)layer * 10.0f;
            float alpha = 0.3f - (float)layer * 0.1f;
            float uvSpeed = 0.02f + (float)layer * 0.01f;
            float uvOffset = skyTime * uvSpeed;
            buffer.m_252986_(layerMatrix, -size, -size, -size).m_7421_(0.0f + uvOffset, 0.0f + uvOffset).m_5752_();
            buffer.m_252986_(layerMatrix, size, -size, -size).m_7421_(1.0f + uvOffset, 0.0f + uvOffset).m_5752_();
            buffer.m_252986_(layerMatrix, size, size, -size).m_7421_(1.0f + uvOffset, 1.0f + uvOffset).m_5752_();
            buffer.m_252986_(layerMatrix, -size, size, -size).m_7421_(0.0f + uvOffset, 1.0f + uvOffset).m_5752_();
            tesselator.m_85914_();
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        RenderSystem.defaultBlendFunc();
    }

    private static void resetSkyEffects() {
        skyTime = 0.0f;
    }

    public static void forceSkyboxReset() {
        forceReset = true;
    }
}

