/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.the_last_sword.attack.AttackEffectManager;

public class AttackManagerCommand {
    private static final SuggestionProvider<CommandSourceStack> UUID_SUGGESTIONS = (context, builder) -> {
        Map<UUID, AttackEffectManager.HealNegationInfo> allRecords = AttackEffectManager.getAllHealNegationRecords();
        Stream<String> suggestions = allRecords.entrySet().stream().map(entry -> {
            UUID uuid = (UUID)entry.getKey();
            String entityName = AttackEffectManager.getEntityNameByUuid(uuid);
            AttackEffectManager.HealNegationInfo record = (AttackEffectManager.HealNegationInfo)entry.getValue();
            return uuid.toString() + " # [" + entityName + "] " + record.getControlledHealth() + "HP";
        });
        return SharedSuggestionProvider.m_82981_(suggestions, (SuggestionsBuilder)builder);
    };

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"attack_manager").then(Commands.m_82127_((String)"show_all").executes(AttackManagerCommand::showAll))).then(Commands.m_82127_((String)"clear_all").executes(AttackManagerCommand::clearAll))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests(UUID_SUGGESTIONS).executes(AttackManagerCommand::clearRecord)))).then(Commands.m_82127_((String)"modify_entity").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests(UUID_SUGGESTIONS).executes(AttackManagerCommand::showEntityModifyOptions)).then(Commands.m_82127_((String)"health").then(Commands.m_82129_((String)"new_health", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).executes(AttackManagerCommand::modifyHealth)))).then(Commands.m_82127_((String)"clear_heal_negation").executes(AttackManagerCommand::clearHealNegation))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"revive_ban").then(Commands.m_82127_((String)"list").executes(AttackManagerCommand::listReviveBan))).then(Commands.m_82127_((String)"clear_all").executes(AttackManagerCommand::clearAllReviveBan)));
    }

    public static int showAll(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_243053_((Component)Component.m_237113_((String)"=== AttackEffectManager Records ===").m_130940_(ChatFormatting.GOLD));
        Map<UUID, AttackEffectManager.HealNegationInfo> allRecords = AttackEffectManager.getAllHealNegationRecords();
        int reviveBanTypes = AttackEffectManager.getReviveBanTypeCount();
        if (allRecords.isEmpty() && reviveBanTypes == 0) {
            source.m_243053_((Component)Component.m_237113_((String)"No records found").m_130940_(ChatFormatting.GRAY));
            return 1;
        }
        source.m_243053_((Component)Component.m_237113_((String)String.format("Heal Negated: %d | Revive Ban Types: %d", allRecords.size(), reviveBanTypes)).m_130940_(ChatFormatting.AQUA));
        if (!allRecords.isEmpty()) {
            source.m_243053_((Component)Component.m_237113_((String)"Heal Negation Records:").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            int index = 1;
            for (Map.Entry<UUID, AttackEffectManager.HealNegationInfo> entry : allRecords.entrySet()) {
                UUID uuid = entry.getKey();
                AttackEffectManager.HealNegationInfo record = entry.getValue();
                String entityName = AttackEffectManager.getEntityNameByUuid(uuid);
                boolean isAlive = AttackManagerCommand.findLivingEntityByUuid(uuid, source) != null;
                MutableComponent message = Component.m_237113_((String)String.format("[%d] %s", index, entityName)).m_130940_(isAlive ? ChatFormatting.WHITE : ChatFormatting.GRAY);
                message.m_7220_((Component)Component.m_237113_((String)String.format(" [%.1f HP]", Float.valueOf(record.getControlledHealth()))).m_130940_(ChatFormatting.RED));
                message.m_7220_((Component)Component.m_237113_((String)(" [" + record.getSimpleEntityType() + "]")).m_130940_(ChatFormatting.YELLOW));
                message.m_7220_((Component)Component.m_237113_((String)(" [" + record.getDimensionName() + "]")).m_130940_(ChatFormatting.DARK_PURPLE));
                message.m_7220_((Component)Component.m_237113_((String)(isAlive ? " [ALIVE]" : " [OFFLINE]")).m_130940_(isAlive ? ChatFormatting.GREEN : ChatFormatting.DARK_GRAY));
                long timeSinceUpdate = System.currentTimeMillis() - record.getLastUpdateTime();
                message.m_7220_((Component)Component.m_237113_((String)(" (" + AttackManagerCommand.formatTime(timeSinceUpdate) + ")")).m_130940_(timeSinceUpdate > 300000L ? ChatFormatting.RED : ChatFormatting.GREEN));
                String shortUuid = uuid.toString().substring(0, 8) + "...";
                message.m_7220_((Component)Component.m_237113_((String)(" [" + shortUuid + "]")).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword attack_manager modify_entity " + uuid)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Click to modify " + entityName))))));
                UUID finalUuid = uuid;
                AttackEffectManager.HealNegationInfo finalRecord = record;
                MutableComponent hoverText = Component.m_237113_((String)("UUID: " + finalUuid.toString()));
                hoverText = hoverText.m_6881_().m_7220_((Component)Component.m_237113_((String)("\nType: " + finalRecord.getEntityTypeId())));
                hoverText = hoverText.m_6881_().m_7220_((Component)Component.m_237113_((String)("\nControlled HP: " + finalRecord.getControlledHealth())));
                MutableComponent finalHoverText = hoverText = hoverText.m_6881_().m_7220_((Component)Component.m_237113_((String)("\nDimension: " + finalRecord.getDimensionName())));
                message.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)finalHoverText)));
                source.m_243053_((Component)message);
                ++index;
            }
        }
        source.m_243053_((Component)Component.m_237113_((String)"\u2500".repeat(50)).m_130940_(ChatFormatting.GRAY));
        MutableComponent quickActions = Component.m_237113_((String)"Quick Actions: ").m_130940_(ChatFormatting.YELLOW);
        quickActions.m_7220_((Component)Component.m_237113_((String)"[Clear All] ").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword attack_manager clear_all")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u26a0 Clear all attack effect records")))));
        if (reviveBanTypes > 0) {
            quickActions.m_7220_((Component)Component.m_237113_((String)"[Revive Ban List] ").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword attack_manager revive_ban list")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"View revive ban list")))));
        }
        source.m_243053_((Component)quickActions);
        return 1;
    }

    public static int clearAll(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        AttackEffectManager.AttackEffectClearResult clearResult = AttackEffectManager.clearAllRecords();
        if (clearResult.getTotalCleared() == 0) {
            source.m_243053_((Component)Component.m_237113_((String)"No records to clear").m_130940_(ChatFormatting.GRAY));
            return 1;
        }
        source.m_243053_((Component)Component.m_237113_((String)"=== Clear All Attack Effect Records ===").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        source.m_243053_((Component)Component.m_237113_((String)("Successfully cleared " + clearResult.getTotalCleared() + " records:")).m_130940_(ChatFormatting.GREEN));
        source.m_243053_((Component)Component.m_237113_((String)("  - Heal Negation: " + clearResult.getHealNegationCleared())).m_130940_(ChatFormatting.WHITE));
        source.m_243053_((Component)Component.m_237113_((String)("  - Revive Ban Types: " + clearResult.getReviveBanCleared())).m_130940_(ChatFormatting.WHITE));
        source.m_243053_((Component)Component.m_237113_((String)"All AttackEffectManager data has been reset!").m_130940_(ChatFormatting.YELLOW));
        return 1;
    }

    public static int showEntityModifyOptions(CommandContext<CommandSourceStack> context) {
        float[] healthValues;
        String uuidStr;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        UUID uuid = AttackManagerCommand.parseUuid(source, uuidStr = AttackManagerCommand.extractUuidFromArgument(StringArgumentType.getString(context, (String)"uuid")));
        if (uuid == null) {
            return 0;
        }
        if (!AttackEffectManager.hasHealNegationRecord(uuid)) {
            source.m_81352_((Component)Component.m_237113_((String)"Record not found"));
            return 0;
        }
        String entityName = AttackEffectManager.getEntityNameByUuid(uuid);
        Map<UUID, AttackEffectManager.HealNegationInfo> allRecords = AttackEffectManager.getAllHealNegationRecords();
        AttackEffectManager.HealNegationInfo record = allRecords.get(uuid);
        source.m_243053_((Component)Component.m_237113_((String)("=== Modify " + entityName + " ===")).m_130940_(ChatFormatting.GOLD));
        source.m_243053_((Component)Component.m_237113_((String)("Current Controlled Health: " + record.getControlledHealth())).m_130940_(ChatFormatting.AQUA));
        source.m_243053_((Component)Component.m_237113_((String)("Entity Type: " + record.getSimpleEntityType())).m_130940_(ChatFormatting.YELLOW));
        source.m_243053_((Component)Component.m_237113_((String)("Dimension: " + record.getDimensionName())).m_130940_(ChatFormatting.DARK_PURPLE));
        source.m_243053_((Component)Component.m_237113_((String)"Modify Health:").m_130940_(ChatFormatting.YELLOW));
        MutableComponent healthButtons = Component.m_237113_((String)"");
        float[] fArray = healthValues = new float[]{0.1f, 1.0f, 5.0f, 10.0f, 20.0f};
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float health;
            float finalHealth = health = fArray[i];
            MutableComponent button = Component.m_237113_((String)("[" + (health < 1.0f ? String.format("%.1f", Float.valueOf(health)) : String.valueOf((int)health)) + "] ")).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword attack_manager modify_entity " + uuidStr + " health " + finalHealth)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Set controlled health to " + finalHealth)))));
            healthButtons.m_7220_((Component)button);
        }
        source.m_243053_((Component)healthButtons);
        source.m_243053_((Component)Component.m_237113_((String)"Actions:").m_130940_(ChatFormatting.YELLOW));
        MutableComponent actions = Component.m_237113_((String)"");
        actions.m_7220_((Component)Component.m_237113_((String)"[Clear Heal Negation] ").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword attack_manager modify_entity " + uuidStr + " clear_heal_negation")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Clear heal negation status")))));
        actions.m_7220_((Component)Component.m_237113_((String)"[Clear Record] ").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword attack_manager clear " + uuidStr)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Remove entire record")))));
        actions.m_7220_((Component)Component.m_237113_((String)"[Back] ").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword attack_manager show_all")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Back to list")))));
        source.m_243053_((Component)actions);
        return 1;
    }

    public static int modifyHealth(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String uuidStr = AttackManagerCommand.extractUuidFromArgument(StringArgumentType.getString(context, (String)"uuid"));
        float newHealth = FloatArgumentType.getFloat(context, (String)"new_health");
        UUID uuid = AttackManagerCommand.parseUuid(source, uuidStr);
        if (uuid == null) {
            return 0;
        }
        LivingEntity entity = AttackManagerCommand.findLivingEntityByUuid(uuid, source);
        if (entity == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Entity not found"));
            return 0;
        }
        if (!AttackEffectManager.isHealNegated((Entity)entity)) {
            source.m_81352_((Component)Component.m_237113_((String)"Entity is not heal negated"));
            return 0;
        }
        AttackEffectManager.updateHealNegationHealth((Entity)entity, newHealth);
        String entityName = entity.m_7755_().getString();
        source.m_288197_(() -> Component.m_237113_((String)("Set controlled health to " + newHealth + " for " + entityName)).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    public static int clearHealNegation(CommandContext<CommandSourceStack> context) {
        String uuidStr;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        UUID uuid = AttackManagerCommand.parseUuid(source, uuidStr = AttackManagerCommand.extractUuidFromArgument(StringArgumentType.getString(context, (String)"uuid")));
        if (uuid == null) {
            return 0;
        }
        LivingEntity entity = AttackManagerCommand.findLivingEntityByUuid(uuid, source);
        if (entity == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Entity not found"));
            return 0;
        }
        if (!AttackEffectManager.isHealNegated((Entity)entity)) {
            source.m_81352_((Component)Component.m_237113_((String)"Entity is not heal negated"));
            return 0;
        }
        String entityName = entity.m_7755_().getString();
        AttackEffectManager.clearHealNegation((Entity)entity);
        source.m_288197_(() -> Component.m_237113_((String)("Cleared heal negation for " + entityName)).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    public static int clearRecord(CommandContext<CommandSourceStack> context) {
        String uuidStr;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        UUID uuid = AttackManagerCommand.parseUuid(source, uuidStr = AttackManagerCommand.extractUuidFromArgument(StringArgumentType.getString(context, (String)"uuid")));
        if (uuid == null) {
            return 0;
        }
        String entityName = AttackEffectManager.getEntityNameByUuid(uuid);
        LivingEntity entity = AttackManagerCommand.findLivingEntityByUuid(uuid, source);
        if (entity == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Entity not found online, cannot clear record"));
            return 0;
        }
        AttackEffectManager.clearAll((Entity)entity);
        source.m_288197_(() -> Component.m_237113_((String)("Cleared record for " + entityName)).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    public static int listReviveBan(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_243053_((Component)Component.m_237113_((String)"=== Revive Ban List ===").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}));
        Map<String, AttackEffectManager.ReviveBanInfo> reviveBanTypes = AttackEffectManager.getAllReviveBanTypes();
        if (reviveBanTypes.isEmpty()) {
            source.m_243053_((Component)Component.m_237113_((String)"No revive bans active").m_130940_(ChatFormatting.GRAY));
            return 1;
        }
        source.m_243053_((Component)Component.m_237113_((String)("Total banned types: " + reviveBanTypes.size())).m_130940_(ChatFormatting.AQUA));
        int index = 1;
        for (Map.Entry<String, AttackEffectManager.ReviveBanInfo> entry : reviveBanTypes.entrySet()) {
            String fullClassName = entry.getKey();
            AttackEffectManager.ReviveBanInfo info = entry.getValue();
            MutableComponent message = Component.m_237113_((String)String.format("[%d] %s", index, info.getSimpleClassName())).m_130940_(ChatFormatting.WHITE);
            message.m_7220_((Component)Component.m_237113_((String)(" [" + info.getFormattedTime() + "]")).m_130940_(info.getRemainingTime() > 300 ? ChatFormatting.GREEN : (info.getRemainingTime() > 60 ? ChatFormatting.YELLOW : ChatFormatting.RED)));
            message.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Full class name: " + fullClassName)))));
            source.m_243053_((Component)message);
            ++index;
        }
        MutableComponent clearButton = Component.m_237113_((String)"[Clear All Revive Bans] ").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword attack_manager revive_ban clear_all")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u26a0 Clear all revive bans"))));
        source.m_243053_((Component)clearButton);
        return 1;
    }

    public static int clearAllReviveBan(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int clearedCount = AttackEffectManager.clearAllReviveBanTypes();
        if (clearedCount > 0) {
            source.m_288197_(() -> Component.m_237113_((String)("Cleared " + clearedCount + " revive ban types")).m_130940_(ChatFormatting.GREEN), false);
        } else {
            source.m_243053_((Component)Component.m_237113_((String)"No revive bans to clear").m_130940_(ChatFormatting.GRAY));
        }
        return 1;
    }

    private static String extractUuidFromArgument(String argument) {
        if (argument.contains("#")) {
            return argument.split("#")[0].trim();
        }
        return argument;
    }

    private static UUID parseUuid(CommandSourceStack source, String uuidStr) {
        try {
            return UUID.fromString(uuidStr);
        }
        catch (IllegalArgumentException e) {
            source.m_81352_((Component)Component.m_237113_((String)"Invalid UUID"));
            return null;
        }
    }

    private static LivingEntity findLivingEntityByUuid(UUID uuid, CommandSourceStack source) {
        for (ServerLevel level : source.m_81377_().m_129785_()) {
            Entity entity = level.m_8791_(uuid);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    private static String formatTime(long milliseconds) {
        long seconds = milliseconds / 1000L;
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (seconds < 3600L) {
            return seconds / 60L + "m";
        }
        return seconds / 3600L + "h";
    }
}

