/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.the_last_sword.defence.DefenceManager;

public class DefenceManagerCommand {
    private static final SuggestionProvider<CommandSourceStack> UUID_SUGGESTIONS = (context, builder) -> {
        Map<UUID, DefenceManager.RecordInfo> allRecords = DefenceManager.getAllRecordsForCommand();
        Stream<String> suggestions = allRecords.entrySet().stream().map(entry -> {
            UUID uuid = (UUID)entry.getKey();
            DefenceManager.RecordInfo record = (DefenceManager.RecordInfo)entry.getValue();
            return uuid.toString() + " # [" + record.getEntityName() + "] L" + record.getLevel();
        });
        return SharedSuggestionProvider.m_82981_(suggestions, (SuggestionsBuilder)builder);
    };

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"defence_manager").then(Commands.m_82127_((String)"show_all").executes(DefenceManagerCommand::showAll))).then(Commands.m_82127_((String)"clear_all").executes(DefenceManagerCommand::clearAll))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests(UUID_SUGGESTIONS).executes(DefenceManagerCommand::clearRecord)))).then(Commands.m_82127_((String)"sync").then(Commands.m_82129_((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests(UUID_SUGGESTIONS).executes(DefenceManagerCommand::syncEntity)))).then(Commands.m_82127_((String)"modify_entity").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"uuid", (ArgumentType)StringArgumentType.string()).suggests(UUID_SUGGESTIONS).executes(DefenceManagerCommand::showEntityModifyOptions)).then(Commands.m_82127_((String)"level").then(Commands.m_82129_((String)"new_level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(DefenceManagerCommand::modifyLevel)))).then(Commands.m_82127_((String)"health").then(Commands.m_82129_((String)"new_health", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).executes(DefenceManagerCommand::modifyHealth)))).then(Commands.m_82127_((String)"max_health").then(Commands.m_82129_((String)"new_max_health", (ArgumentType)FloatArgumentType.floatArg((float)1.0f)).executes(DefenceManagerCommand::modifyMaxHealth)))));
    }

    public static int showAll(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_243053_((Component)Component.m_237113_((String)"=== DefenceManager Records ===").m_130940_(ChatFormatting.GOLD));
        Map<UUID, DefenceManager.RecordInfo> allRecords = DefenceManager.getAllRecordsForCommand();
        if (allRecords.isEmpty()) {
            source.m_243053_((Component)Component.m_237113_((String)"No records found").m_130940_(ChatFormatting.GRAY));
            return 1;
        }
        int totalRecords = DefenceManager.getTotalRecordCount();
        int playerCount = DefenceManager.getPlayerRecords();
        int entityCount = DefenceManager.getEntityRecords();
        int level0 = DefenceManager.getRecordsByLevel(0);
        int level1 = DefenceManager.getRecordsByLevel(1);
        int level2 = DefenceManager.getRecordsByLevel(2);
        int level3 = DefenceManager.getRecordsByLevel(3);
        source.m_243053_((Component)Component.m_237113_((String)String.format("Total: %d (Players: %d, Entities: %d) | L0:%d L1:%d L2:%d L3:%d", totalRecords, playerCount, entityCount, level0, level1, level2, level3)).m_130940_(ChatFormatting.AQUA));
        int index = 1;
        for (Map.Entry<UUID, DefenceManager.RecordInfo> entry : allRecords.entrySet()) {
            UUID uuid = entry.getKey();
            DefenceManager.RecordInfo record = entry.getValue();
            MutableComponent message = Component.m_237113_((String)String.format("[%d] %s", index, record.getEntityName())).m_130940_(record.isPlayer() ? ChatFormatting.GREEN : ChatFormatting.WHITE);
            ChatFormatting levelColor = switch (record.getLevel()) {
                case 1 -> ChatFormatting.GREEN;
                case 2 -> ChatFormatting.YELLOW;
                case 3 -> ChatFormatting.RED;
                default -> ChatFormatting.GRAY;
            };
            message.m_7220_((Component)Component.m_237113_((String)(" [L" + record.getLevel() + "]")).m_130944_(new ChatFormatting[]{levelColor, ChatFormatting.BOLD}));
            if (!record.isPlayer()) {
                message.m_7220_((Component)Component.m_237113_((String)String.format(" %.1f/%.1f", Float.valueOf(record.getHealth()), Float.valueOf(record.getMaxHealth()))).m_130940_(ChatFormatting.AQUA));
            }
            message.m_7220_((Component)Component.m_237113_((String)(" [" + record.getDimensionName() + "]")).m_130940_(ChatFormatting.DARK_PURPLE));
            long timeSinceActive = System.currentTimeMillis() - record.getLastActiveTime();
            message.m_7220_((Component)Component.m_237113_((String)(" (" + DefenceManagerCommand.formatTime(timeSinceActive) + ")")).m_130940_(timeSinceActive > 300000L ? ChatFormatting.RED : ChatFormatting.GREEN));
            if (record.hasSnapshot()) {
                message.m_7220_((Component)Component.m_237113_((String)" [S]").m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
            String shortUuid = uuid.toString().substring(0, 8) + "...";
            message.m_7220_((Component)Component.m_237113_((String)(" [" + shortUuid + "]")).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword defense_manager modify_entity " + uuid)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Click to modify " + record.getEntityName()))))));
            UUID finalUuid = uuid;
            DefenceManager.RecordInfo finalRecord = record;
            MutableComponent hoverText = Component.m_237113_((String)("UUID: " + finalUuid.toString()));
            hoverText = hoverText.m_6881_().m_7220_((Component)Component.m_237113_((String)("\nType: " + finalRecord.getEntityType())));
            hoverText = hoverText.m_6881_().m_7220_((Component)Component.m_237113_((String)("\nLevel: " + finalRecord.getLevel())));
            if (!finalRecord.isPlayer()) {
                hoverText = hoverText.m_6881_().m_7220_((Component)Component.m_237113_((String)("\nHP: " + finalRecord.getHealth() + "/" + finalRecord.getMaxHealth())));
            }
            MutableComponent finalHoverText = hoverText;
            message.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)finalHoverText)));
            source.m_243053_((Component)message);
            ++index;
        }
        source.m_243053_((Component)Component.m_237113_((String)"\u2500".repeat(50)).m_130940_(ChatFormatting.GRAY));
        MutableComponent quickActions = Component.m_237113_((String)"Quick Actions: ").m_130940_(ChatFormatting.YELLOW);
        quickActions.m_7220_((Component)Component.m_237113_((String)"[Clear All] ").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword defense_manager clear_all")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u26a0 Clear all records (WARNING: This cannot be undone!)")))));
        source.m_243053_((Component)quickActions);
        return 1;
    }

    public static int clearAll(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int totalRecords = DefenceManager.getTotalRecordCount();
        if (totalRecords == 0) {
            source.m_243053_((Component)Component.m_237113_((String)"No records to clear").m_130940_(ChatFormatting.GRAY));
            return 1;
        }
        int playerCount = DefenceManager.getPlayerRecords();
        int entityCount = DefenceManager.getEntityRecords();
        int clearedCount = DefenceManager.clearAllRecords();
        source.m_243053_((Component)Component.m_237113_((String)"=== Clear All Records ===").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        source.m_243053_((Component)Component.m_237113_((String)("Successfully cleared " + clearedCount + " records:")).m_130940_(ChatFormatting.GREEN));
        source.m_243053_((Component)Component.m_237113_((String)("  - Players: " + playerCount)).m_130940_(ChatFormatting.WHITE));
        source.m_243053_((Component)Component.m_237113_((String)("  - Entities: " + entityCount)).m_130940_(ChatFormatting.WHITE));
        source.m_243053_((Component)Component.m_237113_((String)"All DefenceManager data has been reset!").m_130940_(ChatFormatting.YELLOW));
        return 1;
    }

    public static int showEntityModifyOptions(CommandContext<CommandSourceStack> context) {
        Object button;
        String uuidStr;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        UUID uuid = DefenceManagerCommand.parseUuid(source, uuidStr = DefenceManagerCommand.extractUuidFromArgument(StringArgumentType.getString(context, (String)"uuid")));
        if (uuid == null) {
            return 0;
        }
        if (!DefenceManager.hasRecord(uuid)) {
            source.m_81352_((Component)Component.m_237113_((String)"Record not found"));
            return 0;
        }
        DefenceManager.RecordInfo record = DefenceManager.getRecordInfo(uuid);
        source.m_243053_((Component)Component.m_237113_((String)("=== Modify " + record.getEntityName() + " ===")).m_130940_(ChatFormatting.GOLD));
        source.m_243053_((Component)Component.m_237113_((String)("Current: Level " + record.getLevel())).m_130940_(ChatFormatting.AQUA));
        if (!record.isPlayer()) {
            source.m_243053_((Component)Component.m_237113_((String)("HP: " + record.getHealth() + "/" + record.getMaxHealth())).m_130940_(ChatFormatting.GREEN));
        }
        source.m_243053_((Component)Component.m_237113_((String)"Modify Level:").m_130940_(ChatFormatting.YELLOW));
        MutableComponent levelButtons = Component.m_237113_((String)"");
        for (int level = 0; level <= 3; ++level) {
            if (level == record.getLevel()) {
                levelButtons.m_7220_((Component)Component.m_237113_((String)("[" + level + "] ")).m_130940_(ChatFormatting.GRAY));
                continue;
            }
            int finalLevel = level;
            button = Component.m_237113_((String)("[" + level + "] ")).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword defense_manager modify_entity " + uuidStr + " level " + finalLevel)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Set level to " + finalLevel)))));
            levelButtons.m_7220_((Component)button);
        }
        source.m_243053_((Component)levelButtons);
        if (!record.isPlayer()) {
            float[] maxHealthValues;
            source.m_243053_((Component)Component.m_237113_((String)"Modify Health:").m_130940_(ChatFormatting.YELLOW));
            MutableComponent healthButtons = Component.m_237113_((String)"");
            float[] healthValues = new float[]{1.0f, 10.0f, 20.0f, 50.0f, 100.0f};
            button = healthValues;
            int n = ((MutableComponent)button).length;
            for (int i = 0; i < n; ++i) {
                MutableComponent health;
                MutableComponent finalHealth = health = button[i];
                MutableComponent button2 = Component.m_237113_((String)("[" + (int)health + "] ")).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE}).m_130938_(arg_0 -> DefenceManagerCommand.lambda$showEntityModifyOptions$6(uuidStr, (float)finalHealth, arg_0));
                healthButtons.m_7220_((Component)button2);
            }
            source.m_243053_((Component)healthButtons);
            source.m_243053_((Component)Component.m_237113_((String)"Modify Max Health:").m_130940_(ChatFormatting.YELLOW));
            MutableComponent maxHealthButtons = Component.m_237113_((String)"");
            float[] fArray = maxHealthValues = new float[]{20.0f, 50.0f, 100.0f, 200.0f, 500.0f};
            int n2 = fArray.length;
            for (int i = 0; i < n2; ++i) {
                float maxHealth;
                float finalMaxHealth = maxHealth = fArray[i];
                MutableComponent button3 = Component.m_237113_((String)("[" + (int)maxHealth + "] ")).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword defense_manager modify_entity " + uuidStr + " max_health " + finalMaxHealth)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Set max health to " + finalMaxHealth)))));
                maxHealthButtons.m_7220_((Component)button3);
            }
            source.m_243053_((Component)maxHealthButtons);
        }
        source.m_243053_((Component)Component.m_237113_((String)"Actions:").m_130940_(ChatFormatting.YELLOW));
        MutableComponent actions = Component.m_237113_((String)"");
        actions.m_7220_((Component)Component.m_237113_((String)"[Sync] ").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword defense_manager sync " + uuidStr)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Sync from entity")))));
        actions.m_7220_((Component)Component.m_237113_((String)"[Clear] ").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword defense_manager clear " + uuidStr)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Remove record")))));
        actions.m_7220_((Component)Component.m_237113_((String)"[Back] ").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword defense_manager show_all")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Back to list")))));
        source.m_243053_((Component)actions);
        return 1;
    }

    public static int modifyLevel(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String uuidStr = DefenceManagerCommand.extractUuidFromArgument(StringArgumentType.getString(context, (String)"uuid"));
        int newLevel = IntegerArgumentType.getInteger(context, (String)"new_level");
        UUID uuid = DefenceManagerCommand.parseUuid(source, uuidStr);
        if (uuid == null) {
            return 0;
        }
        if (DefenceManager.modifyLevel(uuid, newLevel)) {
            source.m_288197_(() -> Component.m_237113_((String)("Level set to " + newLevel)).m_130940_(ChatFormatting.GREEN), false);
        } else {
            source.m_81352_((Component)Component.m_237113_((String)"Failed to modify level"));
        }
        return 1;
    }

    public static int modifyHealth(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String uuidStr = DefenceManagerCommand.extractUuidFromArgument(StringArgumentType.getString(context, (String)"uuid"));
        float newHealth = FloatArgumentType.getFloat(context, (String)"new_health");
        UUID uuid = DefenceManagerCommand.parseUuid(source, uuidStr);
        if (uuid == null) {
            return 0;
        }
        if (DefenceManager.modifyHealth(uuid, newHealth)) {
            source.m_288197_(() -> Component.m_237113_((String)("Health set to " + newHealth)).m_130940_(ChatFormatting.GREEN), false);
        } else {
            source.m_81352_((Component)Component.m_237113_((String)"Failed to modify health"));
        }
        return 1;
    }

    public static int modifyMaxHealth(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String uuidStr = DefenceManagerCommand.extractUuidFromArgument(StringArgumentType.getString(context, (String)"uuid"));
        float newMaxHealth = FloatArgumentType.getFloat(context, (String)"new_max_health");
        UUID uuid = DefenceManagerCommand.parseUuid(source, uuidStr);
        if (uuid == null) {
            return 0;
        }
        if (DefenceManager.modifyMaxHealth(uuid, newMaxHealth)) {
            source.m_288197_(() -> Component.m_237113_((String)("Max health set to " + newMaxHealth)).m_130940_(ChatFormatting.GREEN), false);
        } else {
            source.m_81352_((Component)Component.m_237113_((String)"Failed to modify max health"));
        }
        return 1;
    }

    public static int clearRecord(CommandContext<CommandSourceStack> context) {
        String uuidStr;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        UUID uuid = DefenceManagerCommand.parseUuid(source, uuidStr = DefenceManagerCommand.extractUuidFromArgument(StringArgumentType.getString(context, (String)"uuid")));
        if (uuid == null) {
            return 0;
        }
        String entityName = DefenceManager.getEntityNameForCommand(uuid);
        DefenceManager.clear(uuid);
        source.m_288197_(() -> Component.m_237113_((String)("Cleared record for " + entityName)).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    public static int syncEntity(CommandContext<CommandSourceStack> context) {
        String uuidStr;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        UUID uuid = DefenceManagerCommand.parseUuid(source, uuidStr = DefenceManagerCommand.extractUuidFromArgument(StringArgumentType.getString(context, (String)"uuid")));
        if (uuid == null) {
            return 0;
        }
        LivingEntity entity = DefenceManagerCommand.findLivingEntityByUuid(uuid, source);
        if (entity == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Entity not found"));
            return 0;
        }
        int currentLevel = DefenceManager.getLevel(entity);
        DefenceManager.pullFromEntity(entity, currentLevel);
        String entityName = entity.m_7755_().getString();
        source.m_288197_(() -> Component.m_237113_((String)("Synced data for " + entityName)).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static String extractUuidFromArgument(String argument) {
        if (argument.contains("#")) {
            return argument.split("#")[0].trim();
        }
        return argument;
    }

    private static UUID parseUuid(CommandSourceStack source, String uuidStr) {
        try {
            return UUID.fromString(uuidStr);
        }
        catch (IllegalArgumentException e) {
            source.m_81352_((Component)Component.m_237113_((String)"Invalid UUID"));
            return null;
        }
    }

    private static LivingEntity findLivingEntityByUuid(UUID uuid, CommandSourceStack source) {
        for (ServerLevel level : source.m_81377_().m_129785_()) {
            Entity entity = level.m_8791_(uuid);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    private static String formatTime(long milliseconds) {
        long seconds = milliseconds / 1000L;
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (seconds < 3600L) {
            return seconds / 60L + "m";
        }
        return seconds / 3600L + "h";
    }

    private static /* synthetic */ Style lambda$showEntityModifyOptions$6(String uuidStr, float finalHealth, Style style) {
        return style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/the_last_sword defense_manager modify_entity " + uuidStr + " health " + finalHealth)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Set health to " + finalHealth))));
    }
}

