/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.compat.cataclysm;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.init.TheLastSwordModItems;
import net.the_last_sword.util.TheLastSwordLogger;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CataclysmBossDropHandler {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        String fullClassName;
        if (!ModList.get().isLoaded("cataclysm")) {
            return;
        }
        String entityClassName = event.getEntity().getClass().getSimpleName();
        ItemStack medalToDrop = CataclysmBossDropHandler.getMedalForBoss(entityClassName, fullClassName = event.getEntity().getClass().getName());
        if (medalToDrop != null && !medalToDrop.m_41619_()) {
            ItemEntity medalDrop = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), medalToDrop);
            medalDrop.m_146915_(true);
            medalDrop.m_32064_();
            medalDrop.m_20256_(medalDrop.m_20184_().m_82542_(0.0, 1.5, 0.0));
            event.getEntity().m_9236_().m_7967_((Entity)medalDrop);
            TheLastSwordLogger.info("[CataclysmCompat] Medal dropped for boss: {} -> {} (with glowing effect)", entityClassName, medalToDrop.m_41611_().getString());
        }
    }

    private static ItemStack getMedalForBoss(String bossClassName, String fullClassName) {
        switch (bossClassName) {
            case "Ancient_Remnant_Entity": {
                return TheLastSwordModItems.ANCIENT_REMNANT_MEDAL != null ? new ItemStack((ItemLike)TheLastSwordModItems.ANCIENT_REMNANT_MEDAL.get()) : null;
            }
            case "Ender_Guardian_Entity": {
                return TheLastSwordModItems.ENDER_GUARDIAN_MEDAL != null ? new ItemStack((ItemLike)TheLastSwordModItems.ENDER_GUARDIAN_MEDAL.get()) : null;
            }
            case "Ignis_Entity": {
                return TheLastSwordModItems.IGNIS_MEDAL != null ? new ItemStack((ItemLike)TheLastSwordModItems.IGNIS_MEDAL.get()) : null;
            }
            case "Maledictus_Entity": {
                return TheLastSwordModItems.MALEDICTUS_MEDAL != null ? new ItemStack((ItemLike)TheLastSwordModItems.MALEDICTUS_MEDAL.get()) : null;
            }
            case "Netherite_Monstrosity_Entity": {
                return TheLastSwordModItems.NETHERITE_MONSTROSITY_MEDAL != null ? new ItemStack((ItemLike)TheLastSwordModItems.NETHERITE_MONSTROSITY_MEDAL.get()) : null;
            }
            case "The_Harbinger_Entity": {
                return TheLastSwordModItems.THE_HARBINGER_MEDAL != null ? new ItemStack((ItemLike)TheLastSwordModItems.THE_HARBINGER_MEDAL.get()) : null;
            }
            case "The_Leviathan_Entity": {
                return TheLastSwordModItems.THE_LEVIATHAN_MEDAL != null ? new ItemStack((ItemLike)TheLastSwordModItems.THE_LEVIATHAN_MEDAL.get()) : null;
            }
            case "Scylla_Entity": {
                return TheLastSwordModItems.SCYLLA_MEDAL != null ? new ItemStack((ItemLike)TheLastSwordModItems.SCYLLA_MEDAL.get()) : null;
            }
        }
        return null;
    }
}

