/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.compat.cataclysm;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.compat.cataclysm.CataclysmMedals;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CataclysmMedalEffectHandler {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (!ModList.get().isLoaded("cataclysm")) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        CataclysmMedalEffectHandler.handleHarbingerMedalProjectileImmunity(event, player);
        CataclysmMedalEffectHandler.handleAncientRemnantMedalCounterAttack(event, player);
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        if (!ModList.get().isLoaded("cataclysm")) {
            return;
        }
        if (event.getDamageModifier() <= 1.0f) {
            return;
        }
        CataclysmMedalEffectHandler.handleEnderGuardianMedalVoidPunch(event.getEntity(), event.getTarget());
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (!ModList.get().isLoaded("cataclysm")) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player && event.getEntity() instanceof LivingEntity) {
            Player attacker = (Player)event.getSource().m_7639_();
            LivingEntity targetEntity = event.getEntity();
            CataclysmMedalEffectHandler.handleIgnisMedalBattleWill(attacker, targetEntity);
            CataclysmMedalEffectHandler.handleNetheriteMonstrosityMedalPowerCell(attacker, targetEntity);
            CataclysmMedalEffectHandler.handleLeviathanMedalAbyssalRoar(attacker, targetEntity);
            CataclysmMedalEffectHandler.handleMaledictusMedalCurse(attacker, targetEntity);
            CataclysmMedalEffectHandler.handleScyllaMedalStorm(attacker, targetEntity);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        if (!ModList.get().isLoaded("cataclysm")) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            CataclysmMedalEffectHandler.handleIgnisMedalDamageBonus(event, attacker);
            CataclysmMedalEffectHandler.handleMaledictusMedalDamageBonus(event, attacker);
        }
    }

    private static void handleHarbingerMedalProjectileImmunity(LivingHurtEvent event, Player player) {
        float maxHealth;
        float currentHealth = player.m_21223_();
        if (currentHealth > (maxHealth = player.m_21233_()) * 0.5f) {
            return;
        }
        boolean hasHarbingerMedal = player.m_150109_().f_35974_.stream().anyMatch(stack -> stack.m_41720_() instanceof CataclysmMedals.TheHarbingerMedal);
        if (!hasHarbingerMedal) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_7640_() instanceof Projectile) {
            event.setCanceled(true);
        }
    }

    private static void handleEnderGuardianMedalVoidPunch(Player attacker, Entity target) {
        boolean hasEnderGuardianMedal = attacker.m_150109_().f_35974_.stream().anyMatch(stack -> stack.m_41720_() instanceof CataclysmMedals.EnderGuardianMedal);
        if (!hasEnderGuardianMedal || !(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        ItemStack mainHandShield = livingTarget.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHandShield = livingTarget.m_21120_(InteractionHand.OFF_HAND);
        boolean hasShieldWithoutCooldown = false;
        ItemStack shieldToBreak = null;
        if (mainHandShield.m_41720_() instanceof ShieldItem && !CataclysmMedalEffectHandler.hasShieldCooldown(livingTarget, mainHandShield)) {
            hasShieldWithoutCooldown = true;
            shieldToBreak = mainHandShield;
        } else if (offHandShield.m_41720_() instanceof ShieldItem && !CataclysmMedalEffectHandler.hasShieldCooldown(livingTarget, offHandShield)) {
            hasShieldWithoutCooldown = true;
            shieldToBreak = offHandShield;
        }
        if (hasShieldWithoutCooldown && shieldToBreak != null) {
            CataclysmMedalEffectHandler.applyShieldCooldown(shieldToBreak, livingTarget, 60);
        } else if (!CataclysmMedalEffectHandler.isAlreadyStunned(livingTarget)) {
            CataclysmMedalEffectHandler.applyCataclysmStunEffect(livingTarget, 60);
        }
    }

    private static void handleIgnisMedalBattleWill(Player attacker, LivingEntity target) {
        boolean hasIgnisMedal = attacker.m_150109_().f_35974_.stream().anyMatch(stack -> stack.m_41720_() instanceof CataclysmMedals.IgnisMedal);
        if (!hasIgnisMedal) {
            return;
        }
        if (!target.m_6060_()) {
            return;
        }
        MobEffect blazingBrandEffect = CataclysmMedalEffectHandler.getBlazingBrandEffect();
        if (blazingBrandEffect == null) {
            return;
        }
        int currentLevel = 0;
        if (target.m_21023_(blazingBrandEffect)) {
            currentLevel = target.m_21124_(blazingBrandEffect).m_19564_();
        }
        int newLevel = Math.min(currentLevel + 1, 4);
        target.m_7292_(new MobEffectInstance(blazingBrandEffect, 60, newLevel));
        float healAmount = 2.0f * (float)(newLevel + 1);
        attacker.m_5634_(healAmount);
    }

    private static MobEffect getBlazingBrandEffect() {
        try {
            return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("cataclysm", "blazing_brand"));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static boolean isAlreadyStunned(LivingEntity target) {
        try {
            MobEffect stunEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("cataclysm", "stun"));
            return stunEffect != null && target.m_21023_(stunEffect);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static boolean hasShieldCooldown(LivingEntity entity, ItemStack shield) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_36335_().m_41519_(shield.m_41720_());
        }
        CompoundTag entityData = entity.getPersistentData();
        if (entityData.m_128441_("shield_cooldown_end")) {
            long cooldownEnd = entityData.m_128454_("shield_cooldown_end");
            return entity.m_9236_().m_46467_() < cooldownEnd;
        }
        return false;
    }

    private static void applyShieldCooldown(ItemStack shield, LivingEntity entity, int cooldownTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_36335_().m_41524_(shield.m_41720_(), cooldownTicks);
        }
        CompoundTag entityData = entity.getPersistentData();
        entityData.m_128356_("shield_cooldown_end", entity.m_9236_().m_46467_() + (long)cooldownTicks);
    }

    private static void applyCataclysmStunEffect(LivingEntity target, int durationTicks) {
        try {
            MobEffect stunEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("cataclysm", "stun"));
            if (stunEffect != null) {
                target.m_7292_(new MobEffectInstance(stunEffect, durationTicks, 0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void handleNetheriteMonstrosityMedalPowerCell(Player attacker, LivingEntity target) {
        boolean hasNetheriteMonstrosityMedal = attacker.m_150109_().f_35974_.stream().anyMatch(stack -> stack.m_41720_() instanceof CataclysmMedals.NetheriteMonstrosityMedal);
        if (!hasNetheriteMonstrosityMedal) {
            return;
        }
        if (!target.m_6060_()) {
            target.m_20254_(3);
        }
        if (!target.m_21023_(MobEffects.f_19597_) || target.m_21124_(MobEffects.f_19597_).m_19564_() < 2) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2));
        }
    }

    private static void handleLeviathanMedalAbyssalRoar(Player attacker, LivingEntity target) {
        boolean hasLeviathanMedal = attacker.m_150109_().f_35974_.stream().anyMatch(stack -> stack.m_41720_() instanceof CataclysmMedals.TheLeviathanMedal);
        if (!hasLeviathanMedal) {
            return;
        }
        MobEffect abyssalBurnEffect = CataclysmMedalEffectHandler.getAbyssalBurnEffect();
        if (abyssalBurnEffect == null) {
            return;
        }
        boolean isUnderwater = attacker.m_5842_();
        int effectLevel = isUnderwater ? 4 : 2;
        int duration = isUnderwater ? 200 : 100;
        target.m_7292_(new MobEffectInstance(abyssalBurnEffect, duration, effectLevel));
    }

    private static MobEffect getAbyssalBurnEffect() {
        try {
            return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("cataclysm", "abyssal_burn"));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static void handleAncientRemnantMedalCounterAttack(LivingHurtEvent event, Player player) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            Item item = stack.m_41720_();
            if (!(item instanceof CataclysmMedals.AncientRemnantMedal)) continue;
            CataclysmMedals.AncientRemnantMedal medal = (CataclysmMedals.AncientRemnantMedal)item;
            medal.onOwnerAttacked(player, stack, attacker);
            break;
        }
    }

    private static void handleMaledictusMedalCurse(Player attacker, LivingEntity target) {
        boolean hasMaledictusMedal = attacker.m_150109_().f_35974_.stream().anyMatch(stack -> stack.m_41720_() instanceof CataclysmMedals.MaledictusMedal);
        if (!hasMaledictusMedal) {
            return;
        }
        target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 2));
    }

    private static void handleMaledictusMedalDamageBonus(LivingDamageEvent event, Player attacker) {
        boolean hasMaledictusMedal = attacker.m_150109_().f_35974_.stream().anyMatch(stack -> stack.m_41720_() instanceof CataclysmMedals.MaledictusMedal);
        if (!hasMaledictusMedal) {
            return;
        }
        int debuffCount = 0;
        for (MobEffectInstance effect : attacker.m_21220_()) {
            if (effect.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
            ++debuffCount;
        }
        if (debuffCount > 0) {
            float damageMultiplier = 1.0f + (float)debuffCount * 0.1f;
            event.setAmount(event.getAmount() * damageMultiplier);
        }
    }

    private static void handleIgnisMedalDamageBonus(LivingDamageEvent event, Player attacker) {
        boolean hasIgnisMedal = attacker.m_150109_().f_35974_.stream().anyMatch(stack -> stack.m_41720_() instanceof CataclysmMedals.IgnisMedal);
        if (!hasIgnisMedal) {
            return;
        }
        float damageMultiplier = 1.5f;
        event.setAmount(event.getAmount() * damageMultiplier);
    }

    private static void handleScyllaMedalStorm(Player attacker, LivingEntity target) {
        for (ItemStack stack : attacker.m_150109_().f_35974_) {
            Item item = stack.m_41720_();
            if (!(item instanceof CataclysmMedals.ScyllaMedal)) continue;
            CataclysmMedals.ScyllaMedal medal = (CataclysmMedals.ScyllaMedal)item;
            medal.onOwnerAttack(attacker, stack, target);
            break;
        }
    }
}

