/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.compat.jei;

import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.compat.jei.TheLastSwordJeiPlugin;
import net.the_last_sword.init.TheLastSwordModBlocks;
import net.the_last_sword.recipe.DragonCrystalSmithingRecipe;

public class DragonCrystalSmithingCategory
implements IRecipeCategory<DragonCrystalSmithingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("the_last_sword", "dragon_crystal_smithing");
    public static final ResourceLocation TEXTURE = new ResourceLocation("the_last_sword", "textures/screens/jei_dragon_crystal_smithing_table.png");
    private final IDrawable background;
    private final IDrawable icon;

    public DragonCrystalSmithingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 132, 44);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)TheLastSwordModBlocks.DRAGON_CRYSTAL_SMITHING_TABLE.get()));
    }

    public RecipeType<DragonCrystalSmithingRecipe> getRecipeType() {
        return TheLastSwordJeiPlugin.DRAGON_CRYSTAL_SMITHING_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.category.the_last_sword.dragon_crystal_smithing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DragonCrystalSmithingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 7, 11).addIngredients(recipe.getTemplate());
        ItemStack[] inputItems = recipe.getInput().m_43908_();
        ItemStack[] leveledInputItems = new ItemStack[inputItems.length];
        for (int i = 0; i < inputItems.length; ++i) {
            leveledInputItems[i] = this.createStackWithLevel(inputItems[i], recipe.inputLevel);
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 25, 11).addItemStacks(Arrays.asList(leveledInputItems));
        builder.addSlot(RecipeIngredientRole.INPUT, 44, 11).addIngredients(recipe.getAddition());
        ItemStack resultStack = this.createStackWithLevel(recipe.m_8043_(null), recipe.resultLevel);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 11).addItemStack(resultStack);
    }

    private ItemStack createStackWithLevel(ItemStack baseStack, int level) {
        if (baseStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack newStack = baseStack.m_41777_();
        newStack.m_41764_(1);
        newStack.m_41784_().m_128405_("level", level);
        newStack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(cap -> cap.setLevel(level));
        return newStack;
    }
}

