/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.compat.jei;

import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.the_last_sword.compat.CompatCheck;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.util.TheLastSwordLogger;

public class JEIRecipeSyncHandler {
    private static IJeiRuntime jeiRuntime = null;
    private static boolean lastCataclysmConfigState = false;

    public static void setJeiRuntime(IJeiRuntime runtime) {
        jeiRuntime = runtime;
        lastCataclysmConfigState = CompatCheck.isCataclysmLoaded() && TheLastSwordConfiguration.isCataclysmCompatEnabled();
    }

    @SubscribeEvent
    public static void onConfigReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getModId().equals("the_last_sword")) {
            JEIRecipeSyncHandler.handleConfigChangeForJEI();
        }
    }

    @SubscribeEvent
    public static void onConfigLoading(ModConfigEvent.Loading event) {
        if (event.getConfig().getModId().equals("the_last_sword")) {
            lastCataclysmConfigState = CompatCheck.isCataclysmLoaded() && TheLastSwordConfiguration.isCataclysmCompatEnabled();
        }
    }

    private static void handleConfigChangeForJEI() {
        boolean currentState;
        boolean bl = currentState = CompatCheck.isCataclysmLoaded() && TheLastSwordConfiguration.isCataclysmCompatEnabled();
        if (currentState != lastCataclysmConfigState) {
            if (jeiRuntime != null) {
                try {
                    Minecraft.m_91087_().execute(() -> {
                        try {
                            TheLastSwordLogger.info("Config changed, recipes will be updated on next JEI refresh");
                        }
                        catch (Exception e) {
                            TheLastSwordLogger.error("Failed to handle config change", e);
                        }
                    });
                }
                catch (Exception e) {
                    TheLastSwordLogger.error("Failed to handle JEI recipe refresh", e);
                }
            }
            lastCataclysmConfigState = currentState;
            TheLastSwordLogger.info("Cataclysm compatibility {} - JEI should reflect changes after restart", currentState ? "enabled" : "disabled");
        }
    }

    public static void forceJEIRecipeReload() {
        if (jeiRuntime != null) {
            Minecraft.m_91087_().execute(() -> {
                try {
                    TheLastSwordLogger.info("JEI recipes will be updated on next refresh");
                }
                catch (Exception e) {
                    TheLastSwordLogger.error("Failed to handle JEI update", e);
                }
            });
        }
    }
}

