/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TheLastSwordConfigManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Path THE_LAST_SWORD_DIR = FMLPaths.CONFIGDIR.get().resolve("the_last_sword");
    private static final Path RECIPES_DIR = THE_LAST_SWORD_DIR.resolve("dragon_crystal_smithing_recipes");
    private static final Path HUD_CONFIG_FILE = THE_LAST_SWORD_DIR.resolve("hud_config.json");

    public static void initializeConfig() {
        TheLastSwordConfigManager.createDirectories();
        try {
            TheLastSwordConfigManager.copyResourceDirectory("assets/the_last_sword/dragon_crystal_smithing_recipes", RECIPES_DIR);
            LOGGER.info("[THE LAST SWORD]: Default dragon crystal smithing recipes extracted to {}", (Object)RECIPES_DIR);
        }
        catch (Exception e) {
            LOGGER.error("[THE LAST SWORD]: Failed to extract default recipes", (Throwable)e);
        }
    }

    public static Path getRecipesDirectory() {
        return RECIPES_DIR;
    }

    public static Path getHudConfigFile() {
        return HUD_CONFIG_FILE;
    }

    public static boolean recipesDirectoryExists() {
        return Files.exists(RECIPES_DIR, new LinkOption[0]) && Files.isDirectory(RECIPES_DIR, new LinkOption[0]);
    }

    public static void forceExtractDefaultRecipes() {
        try {
            if (Files.exists(RECIPES_DIR, new LinkOption[0])) {
                Files.walk(RECIPES_DIR, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            TheLastSwordConfigManager.createDirectories();
            TheLastSwordConfigManager.copyResourceDirectory("assets/the_last_sword/dragon_crystal_smithing_recipes", RECIPES_DIR);
            LOGGER.info("[THE LAST SWORD]: Forced extraction of default recipes completed");
        }
        catch (Exception e) {
            LOGGER.error("[THE LAST SWORD]: Failed to force extract default recipes", (Throwable)e);
        }
    }

    private static void createDirectories() {
        try {
            Files.createDirectories(RECIPES_DIR, new FileAttribute[0]);
            Files.createDirectories(THE_LAST_SWORD_DIR, new FileAttribute[0]);
            LOGGER.debug("[THE LAST SWORD]: Config directories created or already exist");
        }
        catch (IOException e) {
            LOGGER.error("[THE LAST SWORD]: Failed to create config directories", (Throwable)e);
        }
    }

    private static void copyResourceDirectory(String resourcePath, Path targetDir) throws IOException, URISyntaxException {
        URL url = TheLastSwordConfigManager.class.getClassLoader().getResource(resourcePath);
        if (url == null) {
            LOGGER.warn("[THE LAST SWORD]: Resource folder not found: {}", (Object)resourcePath);
            return;
        }
        URI uri = url.toURI();
        if ("jar".equals(uri.getScheme())) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Map.of());){
                Path jarPath = fileSystem.getPath(resourcePath, new String[0]);
                TheLastSwordConfigManager.walkAndCopy(jarPath, jarPath, targetDir);
            }
        } else {
            Path sourcePath = Paths.get(uri);
            TheLastSwordConfigManager.walkAndCopy(sourcePath, sourcePath, targetDir);
        }
    }

    private static void walkAndCopy(Path start, Path base, Path targetBase) throws IOException {
        try (Stream<Path> stream = Files.walk(start, new FileVisitOption[0]);){
            stream.forEach(source -> TheLastSwordConfigManager.copyPath(source, base, targetBase));
        }
    }

    private static void copyPath(Path source, Path base, Path targetBase) {
        block10: {
            try {
                Path relative = base.relativize(source);
                Path target = targetBase.resolve(relative.toString());
                if (Files.isDirectory(source, new LinkOption[0])) {
                    Files.createDirectories(target, new FileAttribute[0]);
                    break block10;
                }
                if (!Files.notExists(target, new LinkOption[0])) break block10;
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                try (InputStream in = TheLastSwordConfigManager.class.getClassLoader().getResourceAsStream(base.resolve(relative).toString());){
                    if (in != null) {
                        Files.copy(in, target, new CopyOption[0]);
                        LOGGER.debug("[THE LAST SWORD]: Copied resource: {}", (Object)target.getFileName());
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("[THE LAST SWORD]: Error copying resource {} -> {}", (Object)source, (Object)targetBase, (Object)e);
            }
        }
    }
}

