/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.defence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.entity.TheLastEndEntity;
import net.the_last_sword.util.EntityUtil;

public final class DefenceManager {
    private static final float DAMAGE_RATIO = (float)TheLastSwordConfiguration.getCustomHealthDamageReductionSafely();
    private static final ConcurrentHashMap<UUID, Record> RECORDS = new ConcurrentHashMap();
    private static volatile boolean needsSave = false;
    private static long lastCleanupTime = 0L;
    private static final long CLEANUP_INTERVAL = 600L;

    public static void register(LivingEntity ent, int level) {
        if (ent == null || ent.m_20148_() == null) {
            return;
        }
        UUID id = ent.m_20148_();
        if (RECORDS.containsKey(id)) {
            return;
        }
        float currentHealth = EntityUtil.TheLastEndGetHealth(ent);
        float maxHealth = (float)ent.m_21133_(Attributes.f_22276_);
        Record rec = new Record(level, maxHealth, currentHealth);
        rec.dimension = ent.m_9236_().m_46472_();
        rec.lastActiveTime = System.currentTimeMillis();
        RECORDS.put(id, rec);
        DefenceManager.markDirty();
    }

    public static void pushToEntity(LivingEntity ent) {
        TheLastEndEntity endEntity;
        if (ent == null || ent.m_20148_() == null) {
            return;
        }
        Record rec = RECORDS.get(ent.m_20148_());
        if (rec == null) {
            return;
        }
        rec.lastActiveTime = System.currentTimeMillis();
        if (ent instanceof TheLastEndEntity) {
            endEntity = (TheLastEndEntity)ent;
            if (TheLastSwordConfiguration.getEnableAllThingsEndSafely() && endEntity.getEndLevel() >= endEntity.getAllThingsEndLevel() && (ent.m_213877_() || !ent.m_6084_())) {
                endEntity.setAllThingsEndState(true);
            }
        }
        if (!(ent instanceof Player)) {
            ent.m_21051_(Attributes.f_22276_).m_22100_((double)rec.maxHealth);
        }
        EntityUtil.TheLastEndSetHealth(ent, rec.health);
        if (ent instanceof TheLastEndEntity) {
            float currentHealth;
            endEntity = (TheLastEndEntity)ent;
            if (TheLastSwordConfiguration.getEnableAllThingsEndSafely() && endEntity.getEndLevel() >= endEntity.getAllThingsEndLevel() && (currentHealth = EntityUtil.TheLastEndGetHealth(ent)) < rec.health) {
                endEntity.setAllThingsEndState(true);
            }
        }
        if (rec.health <= 0.0f && !(ent instanceof TheLastEndEntity)) {
            DefenceManager.clear(ent.m_20148_());
        }
    }

    public static void pullFromEntity(LivingEntity ent, int levelFromEntity) {
        if (ent == null || ent.m_20148_() == null) {
            return;
        }
        Record rec = RECORDS.get(ent.m_20148_());
        if (rec == null) {
            return;
        }
        boolean changed = false;
        rec.lastActiveTime = System.currentTimeMillis();
        ResourceKey currentDim = ent.m_9236_().m_46472_();
        if (!currentDim.equals(rec.dimension)) {
            rec.dimension = currentDim;
            changed = true;
        }
        if (rec.level != levelFromEntity) {
            rec.level = levelFromEntity;
            changed = true;
        }
        if (changed) {
            DefenceManager.markDirty();
        }
    }

    public static void clear(UUID id) {
        if (id == null) {
            return;
        }
        if (RECORDS.remove(id) != null) {
            DefenceManager.markDirty();
        }
    }

    public static void clear(LivingEntity e) {
        if (e == null || e.m_20148_() == null) {
            return;
        }
        DefenceManager.clear(e.m_20148_());
    }

    public static void worldTick(ServerLevel lvl) {
        if (lvl == null) {
            return;
        }
        long currentTime = lvl.m_46467_();
        if (currentTime - lastCleanupTime >= 600L) {
            DefenceManager.cleanupInvalidRecords(lvl);
            lastCleanupTime = currentTime;
        }
    }

    private static void cleanupInvalidRecords(ServerLevel level) {
        if (RECORDS.isEmpty()) {
            return;
        }
        MinecraftServer server = level.m_7654_();
        int cleanedCount = 0;
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (UUID entityId : RECORDS.keySet()) {
            boolean entityExists = false;
            for (ServerLevel serverLevel : server.m_129785_()) {
                Entity entity = serverLevel.m_8791_(entityId);
                if (!(entity instanceof LivingEntity) || entity.m_213877_()) continue;
                entityExists = true;
                break;
            }
            if (entityExists) continue;
            toRemove.add(entityId);
        }
        for (UUID entityId : toRemove) {
            RECORDS.remove(entityId);
            ++cleanedCount;
        }
        if (cleanedCount > 0) {
            DefenceManager.markDirty();
        }
    }

    public static Map<UUID, CompoundTag> exportRecords() {
        HashMap<UUID, CompoundTag> out = new HashMap<UUID, CompoundTag>();
        for (Map.Entry<UUID, Record> e : RECORDS.entrySet()) {
            Record r = e.getValue();
            CompoundTag t = new CompoundTag();
            t.m_128405_("Level", r.level);
            t.m_128350_("Max", r.maxHealth);
            t.m_128350_("Health", r.health);
            t.m_128356_("LastActive", r.lastActiveTime);
            if (r.dimension != null) {
                t.m_128359_("Dimension", r.dimension.m_135782_().toString());
            }
            if (r.entityTypeId != null) {
                t.m_128359_("TypeId", r.entityTypeId);
            }
            if (r.snapshot != null) {
                t.m_128365_("Snapshot", (Tag)r.snapshot.m_6426_());
            }
            out.put(e.getKey(), t);
        }
        return out;
    }

    public static void importRecords(Map<UUID, CompoundTag> in) {
        RECORDS.clear();
        if (in == null) {
            return;
        }
        for (Map.Entry<UUID, CompoundTag> e : in.entrySet()) {
            CompoundTag t = e.getValue();
            Record r = new Record(t.m_128451_("Level"), t.m_128457_("Max"), t.m_128457_("Health"));
            long l = r.lastActiveTime = t.m_128441_("LastActive") ? t.m_128454_("LastActive") : System.currentTimeMillis();
            if (t.m_128441_("Dimension")) {
                ResourceLocation dimLoc = new ResourceLocation(t.m_128461_("Dimension"));
                r.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimLoc);
            }
            if (t.m_128441_("TypeId")) {
                r.entityTypeId = t.m_128461_("TypeId");
            }
            if (t.m_128441_("Snapshot")) {
                r.snapshot = t.m_128469_("Snapshot").m_6426_();
            }
            RECORDS.put(e.getKey(), r);
        }
    }

    public static boolean needsSave() {
        return needsSave;
    }

    public static void markSaved() {
        needsSave = false;
    }

    private static void markDirty() {
        needsSave = true;
    }

    public static boolean isTracked(LivingEntity e) {
        return e != null && e.m_20148_() != null && RECORDS.containsKey(e.m_20148_());
    }

    public static int getLevel(LivingEntity e) {
        if (e == null || e.m_20148_() == null) {
            return 0;
        }
        Record r = RECORDS.get(e.m_20148_());
        return r != null ? r.level : 0;
    }

    public static float getStoredHealth(LivingEntity e) {
        if (e == null || e.m_20148_() == null) {
            return e != null ? EntityUtil.TheLastEndGetHealth(e) : 0.0f;
        }
        Record r = RECORDS.get(e.m_20148_());
        return r != null ? r.health : EntityUtil.TheLastEndGetHealth(e);
    }

    public static float getStoredMax(LivingEntity e) {
        if (e == null || e.m_20148_() == null) {
            return e != null ? (float)e.m_21133_(Attributes.f_22276_) : 0.0f;
        }
        Record r = RECORDS.get(e.m_20148_());
        return r != null ? r.maxHealth : (float)e.m_21133_(Attributes.f_22276_);
    }

    public static Map<UUID, RecordInfo> getAllRecordsForCommand() {
        HashMap<UUID, RecordInfo> result = new HashMap<UUID, RecordInfo>();
        for (Map.Entry<UUID, Record> entry : RECORDS.entrySet()) {
            UUID uuid = entry.getKey();
            Record record = entry.getValue();
            result.put(uuid, new RecordInfo(DefenceManager.getEntityNameByUuid(uuid), DefenceManager.getEntityTypeByUuid(uuid), record.level, record.health, record.maxHealth, record.dimension != null ? record.dimension.m_135782_().toString() : "unknown", record.lastActiveTime, record.health == -1.0f && record.maxHealth == -1.0f, record.snapshot != null));
        }
        return result;
    }

    public static boolean hasRecord(UUID uuid) {
        return uuid != null && RECORDS.containsKey(uuid);
    }

    public static RecordInfo getRecordInfo(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        Record record = RECORDS.get(uuid);
        if (record == null) {
            return null;
        }
        return new RecordInfo(DefenceManager.getEntityNameByUuid(uuid), DefenceManager.getEntityTypeByUuid(uuid), record.level, record.health, record.maxHealth, record.dimension != null ? record.dimension.m_135782_().toString() : "unknown", record.lastActiveTime, record.health == -1.0f && record.maxHealth == -1.0f, record.snapshot != null);
    }

    public static int getTotalRecordCount() {
        return RECORDS.size();
    }

    public static int getRecordsByLevel(int level) {
        return (int)RECORDS.values().stream().filter(record -> record.level == level).count();
    }

    public static int getPlayerRecords() {
        return (int)RECORDS.values().stream().filter(r -> {
            LivingEntity e = DefenceManager.findEntityByUuid(r.entityTypeId != null ? UUID.fromString(r.entityTypeId) : null);
            return e instanceof Player;
        }).count();
    }

    public static int getEntityRecords() {
        return (int)RECORDS.values().stream().filter(r -> {
            LivingEntity e = DefenceManager.findEntityByUuid(r.entityTypeId != null ? UUID.fromString(r.entityTypeId) : null);
            return !(e instanceof Player);
        }).count();
    }

    public static boolean modifyLevel(UUID uuid, int newLevel) {
        if (uuid == null) {
            return false;
        }
        Record record = RECORDS.get(uuid);
        if (record == null) {
            return false;
        }
        record.level = newLevel;
        DefenceManager.markDirty();
        return true;
    }

    public static boolean modifyHealth(UUID uuid, float newHealth) {
        if (uuid == null) {
            return false;
        }
        Record record = RECORDS.get(uuid);
        if (record == null) {
            return false;
        }
        record.health = newHealth;
        DefenceManager.markDirty();
        return true;
    }

    public static boolean modifyMaxHealth(UUID uuid, float newMaxHealth) {
        if (uuid == null) {
            return false;
        }
        Record record = RECORDS.get(uuid);
        if (record == null) {
            return false;
        }
        record.maxHealth = newMaxHealth;
        DefenceManager.markDirty();
        return true;
    }

    public static int clearAllRecords() {
        int count = RECORDS.size();
        RECORDS.clear();
        DefenceManager.markDirty();
        return count;
    }

    public static String getEntityNameForCommand(UUID uuid) {
        return DefenceManager.getEntityNameByUuid(uuid);
    }

    private static String getEntityNameByUuid(UUID uuid) {
        if (uuid == null) {
            return "Unknown Entity";
        }
        LivingEntity entity = DefenceManager.findEntityByUuid(uuid);
        if (entity != null) {
            return entity.m_7755_().getString();
        }
        return "Unknown Entity";
    }

    private static String getEntityTypeByUuid(UUID uuid) {
        if (uuid == null) {
            return "unknown";
        }
        Record r = RECORDS.get(uuid);
        if (r != null && r.entityTypeId != null) {
            return r.entityTypeId;
        }
        LivingEntity entity = DefenceManager.findEntityByUuid(uuid);
        if (entity != null) {
            return EntityType.m_20613_((EntityType)entity.m_6095_()).toString();
        }
        return "unknown";
    }

    private static LivingEntity findEntityByUuid(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                for (ServerLevel level : server.m_129785_()) {
                    Entity e = level.m_8791_(uuid);
                    if (!(e instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)e;
                    return living;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private DefenceManager() {
    }

    private static final class Record {
        int level;
        float maxHealth;
        float health;
        CompoundTag snapshot;
        String entityTypeId;
        ResourceKey<Level> dimension;
        long lastActiveTime;

        Record(int lvl, float max, float hp) {
            this.level = lvl;
            this.maxHealth = max;
            this.health = hp;
            this.lastActiveTime = System.currentTimeMillis();
        }
    }

    public static class RecordInfo {
        private final String entityName;
        private final String entityType;
        private final int level;
        private final float health;
        private final float maxHealth;
        private final String dimensionName;
        private final long lastActiveTime;
        private final boolean isPlayer;
        private final boolean hasSnapshot;

        public RecordInfo(String entityName, String entityType, int level, float health, float maxHealth, String dimensionName, long lastActiveTime, boolean isPlayer, boolean hasSnapshot) {
            this.entityName = entityName;
            this.entityType = entityType;
            this.level = level;
            this.health = health;
            this.maxHealth = maxHealth;
            this.dimensionName = dimensionName;
            this.lastActiveTime = lastActiveTime;
            this.isPlayer = isPlayer;
            this.hasSnapshot = hasSnapshot;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public int getLevel() {
            return this.level;
        }

        public float getHealth() {
            return this.health;
        }

        public float getMaxHealth() {
            return this.maxHealth;
        }

        public String getDimensionName() {
            String[] parts = this.dimensionName.split(":");
            return parts.length > 1 ? parts[1] : this.dimensionName;
        }

        public long getLastActiveTime() {
            return this.lastActiveTime;
        }

        public boolean isPlayer() {
            return this.isPlayer;
        }

        public boolean hasSnapshot() {
            return this.hasSnapshot;
        }
    }
}

