/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.defence;

import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.init.TheLastSwordModAttributes;
import net.the_last_sword.init.TheLastSwordModMobEffects;
import net.the_last_sword.summon.WraithSummonManager;
import net.the_last_sword.util.EntityUtil;

@Mod.EventBusSubscriber
public final class DefenceServerEvent {
    private DefenceServerEvent() {
    }

    public static void autoRegenerate(LivingEntity le) {
        AttributeInstance maxA = le.m_21051_((Attribute)TheLastSwordModAttributes.MAX_JUSTIFIED_DEFENCE.get());
        AttributeInstance curA = le.m_21051_((Attribute)TheLastSwordModAttributes.JUSTIFIED_DEFENCE.get());
        if (maxA == null || curA == null) {
            return;
        }
        double max = maxA.m_22135_();
        double cur = curA.m_22135_();
        int interval = (Integer)TheLastSwordConfiguration.JUSTIFIED_DEFENCE_TICK.get();
        boolean hasTemporaryShield = false;
        if (le instanceof Player) {
            Player player = (Player)le;
            hasTemporaryShield = WraithSummonManager.hasTemporaryShield(player);
        }
        if (max <= 0.001) {
            if (cur > 0.001 && !hasTemporaryShield) {
                curA.m_22100_(0.0);
            }
            return;
        }
        if (cur > max) {
            if (!hasTemporaryShield) {
                curA.m_22100_(max);
            }
        } else if (interval > 0 && le.f_19797_ % interval == 0 && cur < max) {
            double newValue = Math.min(cur + 1.0, max);
            curA.m_22100_(newValue);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingAttack(LivingAttackEvent e) {
        LivingEntity entity = e.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (entity.m_21023_((MobEffect)TheLastSwordModMobEffects.PHASING.get())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent e) {
        LivingEntity entity = e.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (entity.m_21023_((MobEffect)TheLastSwordModMobEffects.PHASING.get())) {
            e.setCanceled(true);
            return;
        }
        double currentShield = DefenceServerEvent.getShieldValue(entity);
        if (currentShield > 0.0) {
            DefenceServerEvent.triggerShieldProtection(entity, (Event)e);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeath(LivingDeathEvent e) {
        LivingEntity entity = e.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (entity.m_21023_((MobEffect)TheLastSwordModMobEffects.PHASING.get())) {
            e.setCanceled(true);
            EntityUtil.TheLastEndSetHealth(entity, entity.m_21233_());
            return;
        }
        double currentShield = DefenceServerEvent.getShieldValue(entity);
        if (currentShield > 0.0) {
            DefenceServerEvent.triggerShieldProtection(entity, (Event)e);
        }
    }

    private static void triggerShieldProtection(LivingEntity entity, Event event) {
        event.setCanceled(true);
        EntityUtil.TheLastEndSetHealth(entity, entity.m_21233_());
        double currentShield = DefenceServerEvent.getShieldValue(entity);
        DefenceServerEvent.setShieldValue(entity, currentShield - 1.0);
    }

    public static double getShieldValue(LivingEntity entity) {
        AttributeInstance a = entity.m_21051_((Attribute)TheLastSwordModAttributes.JUSTIFIED_DEFENCE.get());
        return a != null ? a.m_22135_() : 0.0;
    }

    public static void setShieldValue(LivingEntity entity, double value) {
        AttributeInstance a = entity.m_21051_((Attribute)TheLastSwordModAttributes.JUSTIFIED_DEFENCE.get());
        if (a != null) {
            a.m_22100_(Math.max(0.0, value));
        }
    }

    @SubscribeEvent
    public static void onCommand(CommandEvent e) {
        ServerPlayer self;
        Entity entity;
        String raw = e.getParseResults().getReader().getString().trim();
        if (raw.startsWith("/")) {
            raw = raw.substring(1);
        }
        String lower = raw.toLowerCase(Locale.ROOT);
        CommandSourceStack src = (CommandSourceStack)e.getParseResults().getContext().getSource();
        MinecraftServer server = src.m_81377_();
        boolean isKick = lower.startsWith("kick");
        boolean isClear = lower.startsWith("clear");
        if ((isKick || isClear) && (entity = src.m_81373_()) instanceof ServerPlayer && DefenceManager.getLevel((LivingEntity)(self = (ServerPlayer)entity)) >= 2) {
            e.setCanceled(true);
            return;
        }
        if (lower.startsWith("data entity")) {
            for (ServerLevel lvl : server.m_129785_()) {
                for (Entity ent : lvl.m_142646_().m_142273_()) {
                    LivingEntity le;
                    if (!(ent instanceof LivingEntity) || !DefenceManager.isTracked(le = (LivingEntity)ent) || DefenceManager.getLevel(le) != 3) continue;
                    String name = le.m_7755_().getString().toLowerCase(Locale.ROOT);
                    String uuid = le.m_20148_().toString();
                    if (!lower.contains(name) && !lower.contains(uuid)) continue;
                    e.setCanceled(true);
                    return;
                }
            }
        }
    }
}

