/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.entity;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PlayMessages;
import net.the_last_sword.entity.TheLastEndEntity;
import net.the_last_sword.entity.ai.GuardianOfSealedSpireAI;
import net.the_last_sword.init.TheLastSwordModEntities;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GuardianOfSealedSpireEntity
extends TheLastEndEntity {
    private static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(GuardianOfSealedSpireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private String prevAnim = "empty";

    public GuardianOfSealedSpireEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<? extends GuardianOfSealedSpireEntity>)((EntityType)TheLastSwordModEntities.GUARDIAN_OF_SEALED_SPIRE.get()), world);
    }

    public GuardianOfSealedSpireEntity(EntityType<? extends GuardianOfSealedSpireEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 50;
        this.m_21557_(false);
        if (!world.f_46443_) {
            GuardianOfSealedSpireAI.initialize(this);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION, (Object)"empty");
    }

    public String getAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            GuardianOfSealedSpireAI.handleTick(this);
        }
    }

    @Override
    public void safeRemove() {
        super.safeRemove();
        if (!this.m_9236_().f_46443_) {
            GuardianOfSealedSpireAI.cleanupRemovedEntity(this.m_20148_());
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 16.0);
    }

    @Override
    protected int getMinLevel() {
        return 1;
    }

    @Override
    protected int getMaxLevel() {
        return 1;
    }

    @Override
    public int getAllThingsEndLevel() {
        return 1;
    }

    @Override
    protected int getDeathDuration() {
        return 20;
    }

    @Override
    public int mapToDefenseLevel() {
        return 1;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 5, state -> {
            if (this.getIsDead()) {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("death"));
                return PlayState.CONTINUE;
            }
            String currentSpecialAnim = this.getAnimation();
            if (!currentSpecialAnim.equals("empty")) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("idle"));
            }
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "special", 0, state -> {
            String currentAnim = this.getAnimation();
            if (!currentAnim.equals("empty") && state.getController().getAnimationState() == AnimationController.State.STOPPED || !currentAnim.equals(this.prevAnim) && !currentAnim.equals("empty")) {
                if (!currentAnim.equals(this.prevAnim)) {
                    state.getController().forceAnimationReset();
                }
                state.getController().setAnimation(RawAnimation.begin().thenPlay(currentAnim));
                if (state.getController().getAnimationState() == AnimationController.State.STOPPED) {
                    this.setAnimation("empty");
                    state.getController().forceAnimationReset();
                }
            } else if (currentAnim.equals("empty")) {
                this.prevAnim = "empty";
                return PlayState.STOP;
            }
            this.prevAnim = currentAnim;
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }
}

