/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.entity;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.entity.PurpleLightingEntity;
import net.the_last_sword.init.TheLastSwordModEntities;
import net.the_last_sword.item.TheLastEndSword;
import net.the_last_sword.util.EntityUtil;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class TheLastSwordProjectile
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Items.f_42729_);
    private final UUID shooterUUID;
    private static final int MAX_TICKS = 240;

    public TheLastSwordProjectile(EntityType<? extends TheLastSwordProjectile> type, Level world) {
        super(type, world);
        this.shooterUUID = null;
    }

    public TheLastSwordProjectile(EntityType<? extends TheLastSwordProjectile> type, LivingEntity entity, Level world, UUID shooterUUID) {
        super(type, entity, world);
        this.shooterUUID = shooterUUID;
    }

    public TheLastSwordProjectile(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<? extends TheLastSwordProjectile>)((EntityType)TheLastSwordModEntities.THE_LAST_SWORD_POJECTILE.get()), world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_36703_) {
            double radius = 2.5;
            AABB damageBox = new AABB(this.m_20185_() - radius, this.m_20186_() - radius, this.m_20189_() - radius, this.m_20185_() + radius, this.m_20186_() + radius, this.m_20189_() + radius);
            for (Entity e : this.m_9236_().m_6249_((Entity)this, damageBox, ent -> ent.m_6084_() && ent instanceof LivingEntity)) {
                if (e == this.m_19749_() || EntityUtil.isOwnerOrAllyOrPet(e, this.shooterUUID, this.m_19749_()) || !EntityUtil.shouldAttack(e) || !(e instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)e;
                this.doProjectileDamage(livingEntity);
            }
        }
        if (this.m_9236_().m_5776_() && !this.f_36703_) {
            double cx = this.m_20185_();
            double cy = this.m_20186_();
            double cz = this.m_20189_();
            double r = 2.5;
            double offsetY = Math.random() * 2.0 * r - r;
            double offsetZ = Math.random() * 2.0 * r - r;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, cx + r, cy + offsetY, cz + offsetZ, 0.0, 0.0, 0.0);
            offsetY = Math.random() * 2.0 * r - r;
            offsetZ = Math.random() * 2.0 * r - r;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, cx - r, cy + offsetY, cz + offsetZ, 0.0, 0.0, 0.0);
            double offsetX = Math.random() * 2.0 * r - r;
            offsetZ = Math.random() * 2.0 * r - r;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, cx + offsetX, cy + r, cz + offsetZ, 0.0, 0.0, 0.0);
            offsetX = Math.random() * 2.0 * r - r;
            offsetZ = Math.random() * 2.0 * r - r;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, cx + offsetX, cy - r, cz + offsetZ, 0.0, 0.0, 0.0);
            offsetX = Math.random() * 2.0 * r - r;
            offsetY = Math.random() * 2.0 * r - r;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, cx + offsetX, cy + offsetY, cz + r, 0.0, 0.0, 0.0);
            offsetX = Math.random() * 2.0 * r - r;
            offsetY = Math.random() * 2.0 * r - r;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, cx + offsetX, cy + offsetY, cz - r, 0.0, 0.0, 0.0);
        }
        if (this.f_36703_) {
            this.m_146870_();
            return;
        }
        if (this.f_19797_ >= 240) {
            this.m_146870_();
            return;
        }
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        Entity target = entityHitResult.m_82443_();
        if (this.m_19749_() == null) {
            return;
        }
        if (EntityUtil.isOwnerOrAllyOrPet(target, this.shooterUUID, this.m_19749_())) {
            return;
        }
        if (!EntityUtil.shouldAttack(target)) {
            return;
        }
        super.m_5790_(entityHitResult);
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            this.doProjectileDamage(livingTarget);
        }
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PurpleLightingEntity lightning = new PurpleLightingEntity((EntityType<PurpleLightingEntity>)((EntityType)TheLastSwordModEntities.END_PORTAL_LIGHTING.get()), (Level)serverLevel);
            lightning.m_20219_(Vec3.m_82539_((Vec3i)blockHitResult.m_82425_()));
            lightning.m_20874_(true);
            serverLevel.m_7967_((Entity)lightning);
        }
    }

    private void doProjectileDamage(LivingEntity target) {
        Level mainHandItem;
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            Item item;
            ItemStack offHandItem;
            LivingEntity owner = (LivingEntity)entity;
            mainHandItem = owner instanceof Player ? ((Player)owner).m_21205_() : ItemStack.f_41583_;
            ItemStack itemStack = offHandItem = owner instanceof Player ? ((Player)owner).m_21206_() : ItemStack.f_41583_;
            Object weapon = mainHandItem.m_41720_() instanceof TheLastEndSword ? mainHandItem : (offHandItem.m_41720_() instanceof TheLastEndSword ? offHandItem : ItemStack.f_41583_);
            if (!weapon.m_41619_() && (item = weapon.m_41720_()) instanceof TheLastEndSword) {
                TheLastEndSword theLastSword = (TheLastEndSword)item;
                float basePhysicalDamage = theLastSword.getBasePhysicalDamage();
                if (basePhysicalDamage > 0.0f) {
                    DamageSource physicalDamageSource = owner instanceof Player ? target.m_269291_().m_269075_((Player)owner) : target.m_269291_().m_269333_(owner);
                    target.m_6469_(physicalDamageSource, basePhysicalDamage);
                }
                weapon.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(swordLevel -> {
                    int level = swordLevel.getLevel();
                    double increaseValue = TheLastSwordConfiguration.getIncreaseValueSafely();
                    double increaseValueHighLevel = TheLastSwordConfiguration.getIncreaseValueHighLevelSafely();
                    double extraDamage = (level < 6 ? increaseValue : increaseValueHighLevel) * (double)level;
                    if (extraDamage < 0.0) {
                        extraDamage = 0.0;
                    }
                    target.m_6469_(new DamageSource((Holder)owner.m_20193_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268724_), (Entity)owner, (Entity)owner), (float)extraDamage);
                });
            } else {
                target.m_6469_(target.m_269291_().m_269425_(), 10.0f);
            }
        }
        if ((mainHandItem = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)mainHandItem;
            PurpleLightingEntity lightning = new PurpleLightingEntity((EntityType<PurpleLightingEntity>)((EntityType)TheLastSwordModEntities.END_PORTAL_LIGHTING.get()), (Level)serverLevel);
            lightning.m_20219_(Vec3.m_82539_((Vec3i)BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_())));
            lightning.m_20874_(true);
            serverLevel.m_7967_((Entity)lightning);
        }
    }

    public static TheLastSwordProjectile shoot(Level world, LivingEntity entity, RandomSource source) {
        return TheLastSwordProjectile.shoot(world, entity, source, 2.5f, 1024.0, 3);
    }

    public static TheLastSwordProjectile shoot(Level world, LivingEntity shooter, RandomSource random, float power, double damage, int knockback) {
        float adjustedSpeed = power * 2.0f - 1.0f;
        TheLastSwordProjectile projectile = new TheLastSwordProjectile((EntityType<? extends TheLastSwordProjectile>)((EntityType)TheLastSwordModEntities.THE_LAST_SWORD_POJECTILE.get()), shooter, world, shooter.m_20148_());
        projectile.m_6686_(shooter.m_20252_((float)1.0f).f_82479_, shooter.m_20252_((float)1.0f).f_82480_, shooter.m_20252_((float)1.0f).f_82481_, adjustedSpeed, 0.0f);
        projectile.m_20225_(true);
        projectile.m_36762_(true);
        projectile.m_36781_(200.0);
        projectile.m_36735_(knockback);
        world.m_7967_((Entity)projectile);
        world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ender_dragon.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return projectile;
    }

    public static TheLastSwordProjectile shoot(LivingEntity shooter, LivingEntity target) {
        TheLastSwordProjectile projectile = new TheLastSwordProjectile((EntityType<? extends TheLastSwordProjectile>)((EntityType)TheLastSwordModEntities.THE_LAST_SWORD_POJECTILE.get()), shooter, shooter.m_9236_(), shooter.m_20148_());
        double dx = target.m_20185_() - shooter.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - shooter.m_20189_();
        projectile.m_6686_(dx, dy - projectile.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 5.0f, 12.0f);
        projectile.m_20225_(true);
        projectile.m_36781_(200.0);
        projectile.m_36735_(2);
        projectile.m_36762_(true);
        shooter.m_9236_().m_7967_((Entity)projectile);
        shooter.m_9236_().m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ender_dragon.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return projectile;
    }
}

