/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.entity.ai;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.the_last_sword.entity.GuardianOfSealedSpireEntity;

public final class GuardianOfSealedSpireAI {
    private static final Map<UUID, AIState> AI_STATES = new ConcurrentHashMap<UUID, AIState>();
    private static final double MAX_SEARCH_DISTANCE = 32.0;
    private static final double BOW_ATTACK_RANGE = 32.0;
    private static final double MELEE_ATTACK_RANGE = 3.0;

    private GuardianOfSealedSpireAI() {
    }

    public static void initialize(GuardianOfSealedSpireEntity guardian) {
        UUID id = guardian.m_20148_();
        AI_STATES.remove(id);
        AI_STATES.put(id, new AIState());
    }

    public static void handleTick(GuardianOfSealedSpireEntity guardian) {
        if (guardian.m_9236_().f_46443_) {
            return;
        }
        UUID id = guardian.m_20148_();
        AIState state = AI_STATES.computeIfAbsent(id, k -> new AIState());
        GuardianOfSealedSpireAI.updateTarget(guardian, state);
        LivingEntity target = guardian.m_5448_();
        if (target != null && target.m_6084_()) {
            GuardianOfSealedSpireAI.handleCombatAI(guardian, target, state);
        }
    }

    public static void cleanupRemovedEntity(UUID entityId) {
        AI_STATES.remove(entityId);
    }

    private static void updateTarget(GuardianOfSealedSpireEntity guardian, AIState state) {
        LivingEntity currentTarget = guardian.m_5448_();
        if (currentTarget != null) {
            boolean invalid;
            boolean bl = invalid = currentTarget.m_213877_() || !currentTarget.m_6084_() || (double)guardian.m_20270_((Entity)currentTarget) > 32.0;
            if (currentTarget instanceof Player) {
                Player player = (Player)currentTarget;
                boolean bl2 = invalid = invalid || player.m_7500_() || player.m_5833_();
            }
            if (invalid) {
                guardian.m_6710_(null);
            }
        }
    }

    private static void handleCombatAI(GuardianOfSealedSpireEntity guardian, LivingEntity target, AIState state) {
        ItemStack mainHandItem = guardian.m_21120_(InteractionHand.MAIN_HAND);
        if (mainHandItem.m_41720_() instanceof BowItem) {
            GuardianOfSealedSpireAI.handleBowAttack(guardian, target, state);
        } else {
            GuardianOfSealedSpireAI.handleMeleeAttack(guardian, target, state);
        }
    }

    private static void handleBowAttack(GuardianOfSealedSpireEntity guardian, LivingEntity target, AIState state) {
        boolean wasSeeing;
        double distSqr = guardian.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        boolean canSee = guardian.m_21574_().m_148306_((Entity)target);
        boolean bl = wasSeeing = state.bowSeeTime > 0;
        if (canSee != wasSeeing) {
            state.bowSeeTime = 0;
        }
        state.bowSeeTime = canSee ? ++state.bowSeeTime : --state.bowSeeTime;
        double attackRadiusSqr = 1024.0;
        if (!(distSqr > attackRadiusSqr) && state.bowSeeTime >= 20) {
            guardian.m_21573_().m_26573_();
            ++state.strafingTime;
        } else {
            guardian.m_21573_().m_5624_((Entity)target, 1.0);
            state.strafingTime = -1;
        }
        if (state.strafingTime >= 20) {
            if ((double)guardian.m_217043_().m_188501_() < 0.3) {
                boolean bl2 = state.strafingClockwise = !state.strafingClockwise;
            }
            if ((double)guardian.m_217043_().m_188501_() < 0.3) {
                state.strafingBackwards = !state.strafingBackwards;
            }
            state.strafingTime = 0;
        }
        if (state.strafingTime > -1) {
            if (distSqr > attackRadiusSqr * 0.75) {
                state.strafingBackwards = false;
            } else if (distSqr < attackRadiusSqr * 0.25) {
                state.strafingBackwards = true;
            }
            guardian.m_21566_().m_24988_(state.strafingBackwards ? -0.5f : 0.5f, state.strafingClockwise ? 0.5f : -0.5f);
            guardian.m_21391_((Entity)target, 30.0f, 30.0f);
        } else {
            guardian.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
        if (state.bowAttackTime == -1) {
            if (canSee && distSqr <= attackRadiusSqr) {
                state.bowAttackTime = 0;
                guardian.m_6672_(InteractionHand.MAIN_HAND);
                guardian.setAnimation("shoot");
            }
        } else {
            ++state.bowAttackTime;
            if (state.bowAttackTime == 25) {
                GuardianOfSealedSpireAI.performBowAttack(guardian, target);
            }
            if (state.bowAttackTime >= 30) {
                guardian.m_5810_();
                guardian.setAnimation("empty");
                state.bowAttackTime = -1;
            }
        }
        guardian.m_21561_(state.bowAttackTime > -1);
    }

    private static void performBowAttack(GuardianOfSealedSpireEntity guardian, LivingEntity target) {
        ItemStack bowStack = guardian.m_21120_(InteractionHand.MAIN_HAND);
        if (!(bowStack.m_41720_() instanceof BowItem)) {
            return;
        }
        ItemStack arrowStack = new ItemStack((ItemLike)Items.f_42412_);
        AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)guardian, (ItemStack)arrowStack, (float)1.0f);
        double dx = target.m_20185_() - guardian.m_20185_();
        double dy = target.m_20227_(0.3333333333333333) - arrow.m_20186_();
        double dz = target.m_20189_() - guardian.m_20189_();
        double distHorizontal = Math.sqrt(dx * dx + dz * dz);
        arrow.m_6686_(dx, dy + distHorizontal * (double)0.2f, dz, 1.6f, (float)(14 - guardian.m_9236_().m_46791_().m_19028_() * 4));
        guardian.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (guardian.m_217043_().m_188501_() * 0.4f + 0.8f));
        guardian.m_9236_().m_7967_((Entity)arrow);
    }

    private static void handleMeleeAttack(GuardianOfSealedSpireEntity guardian, LivingEntity target, AIState state) {
        guardian.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        double distSqr = guardian.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        state.ticksUntilNextPathRecalculation = Math.max(state.ticksUntilNextPathRecalculation - 1, 0);
        if (guardian.m_21574_().m_148306_((Entity)target) && state.ticksUntilNextPathRecalculation <= 0 && (target.m_20185_() != 0.0 || target.m_20186_() != 0.0 || target.m_20189_() != 0.0)) {
            state.ticksUntilNextPathRecalculation = 4 + guardian.m_217043_().m_188503_(7);
            if (distSqr > 1024.0) {
                state.ticksUntilNextPathRecalculation += 10;
            } else if (distSqr > 256.0) {
                state.ticksUntilNextPathRecalculation += 5;
            }
            if (!guardian.m_21573_().m_5624_((Entity)target, 1.0)) {
                state.ticksUntilNextPathRecalculation += 15;
            }
        }
        if (state.meleeAttackTime == -1) {
            state.ticksUntilNextMeleeAttack = Math.max(state.ticksUntilNextMeleeAttack - 1, 0);
            double attackReachSqr = guardian.m_20205_() * 2.0f * guardian.m_20205_() * 2.0f + target.m_20205_();
            if (distSqr <= attackReachSqr && state.ticksUntilNextMeleeAttack <= 0) {
                state.meleeAttackTime = 0;
                guardian.setAnimation("attack");
                guardian.m_21573_().m_26573_();
            }
        } else {
            ++state.meleeAttackTime;
            if (state.meleeAttackTime == 15) {
                GuardianOfSealedSpireAI.performMeleeAttack(guardian, target);
            }
            if (state.meleeAttackTime >= 20) {
                guardian.setAnimation("empty");
                state.meleeAttackTime = -1;
                state.ticksUntilNextMeleeAttack = 20;
            }
        }
        guardian.m_21561_(state.meleeAttackTime > -1);
    }

    private static void performMeleeAttack(GuardianOfSealedSpireEntity guardian, LivingEntity target) {
        guardian.m_7327_((Entity)target);
    }

    private static class AIState {
        int bowAttackTime = -1;
        int bowSeeTime = 0;
        boolean strafingClockwise = false;
        boolean strafingBackwards = false;
        int strafingTime = -1;
        int meleeAttackTime = -1;
        int ticksUntilNextPathRecalculation = 0;
        int ticksUntilNextMeleeAttack = 0;

        private AIState() {
        }
    }
}

