/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.entity.ai;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.the_last_sword.attack.AbsoluteDestructionDamageSource;
import net.the_last_sword.entity.LostWraithEntity;
import net.the_last_sword.entity.PurpleLightingEntity;
import net.the_last_sword.init.TheLastSwordModEntities;
import net.the_last_sword.init.TheLastSwordModMobEffects;

public final class LostWraithAI {
    private static final Map<UUID, SkillExecutionData> SKILL_EXECUTION = new ConcurrentHashMap<UUID, SkillExecutionData>();
    private static final Map<UUID, Integer> GLOBAL_SKILL_PREPARATION = new ConcurrentHashMap<UUID, Integer>();
    private static final double MAX_SEARCH_DISTANCE = 32.0;
    private static final int SKILL_PREPARATION_TIME = 20;

    private LostWraithAI() {
    }

    private static boolean teleportToTarget(LostWraithEntity wraith, LivingEntity target) {
        if (target == null || wraith.m_9236_().f_46443_) {
            return false;
        }
        Vec3 teleportPos = LostWraithAI.findPositionInFrontOfTarget(wraith, target);
        if (teleportPos == null) {
            teleportPos = LostWraithAI.findNearestSolidBlock(wraith, target.m_20182_(), 8.0);
        }
        if (teleportPos != null) {
            ServerLevel serverLevel;
            Vec3 oldPosition = wraith.m_20182_();
            Level level = wraith.m_9236_();
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                LostWraithAI.spawnTeleportParticles(serverLevel, oldPosition);
                wraith.m_9236_().m_5594_(null, new BlockPos((int)oldPosition.f_82479_, (int)oldPosition.f_82480_, (int)oldPosition.f_82481_), SoundEvents.f_11852_, wraith.m_5720_(), 1.0f, 1.0f);
            }
            wraith.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
            level = wraith.m_9236_();
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                LostWraithAI.spawnTeleportParticles(serverLevel, teleportPos);
                wraith.m_9236_().m_5594_(null, new BlockPos((int)teleportPos.f_82479_, (int)teleportPos.f_82480_, (int)teleportPos.f_82481_), SoundEvents.f_11852_, wraith.m_5720_(), 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    private static Vec3 findPositionInFrontOfTarget(LostWraithEntity wraith, LivingEntity target) {
        Vec3 targetLook = target.m_20154_();
        Vec3 targetPos = target.m_20182_();
        Vec3 frontPos = targetPos.m_82549_(targetLook.m_82490_(1.0));
        if (LostWraithAI.isValidTeleportPosition(wraith, frontPos)) {
            return frontPos;
        }
        Vec3 rightVector = targetLook.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        for (int i = 1; i <= 2; ++i) {
            Vec3 rightPos = frontPos.m_82549_(rightVector.m_82490_((double)i));
            if (LostWraithAI.isValidTeleportPosition(wraith, rightPos)) {
                return rightPos;
            }
            Vec3 leftPos = frontPos.m_82549_(rightVector.m_82490_((double)(-i)));
            if (!LostWraithAI.isValidTeleportPosition(wraith, leftPos)) continue;
            return leftPos;
        }
        return null;
    }

    private static Vec3 findNearestSolidBlock(LostWraithEntity wraith, Vec3 center, double searchRadius) {
        BlockPos centerPos = new BlockPos((int)center.f_82479_, (int)center.f_82480_, (int)center.f_82481_);
        BlockPos bestPos = null;
        double bestDistance = Double.MAX_VALUE;
        int radius = (int)searchRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double distance;
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    Vec3 checkVec = new Vec3((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_() + 1.0, (double)checkPos.m_123343_() + 0.5);
                    if (!LostWraithAI.isValidTeleportPosition(wraith, checkVec) || !((distance = center.m_82554_(checkVec)) < bestDistance)) continue;
                    bestDistance = distance;
                    bestPos = checkPos;
                }
            }
        }
        if (bestPos != null) {
            return new Vec3((double)bestPos.m_123341_() + 0.5, (double)bestPos.m_123342_() + 1.0, (double)bestPos.m_123343_() + 0.5);
        }
        return null;
    }

    private static boolean isValidTeleportPosition(LostWraithEntity wraith, Vec3 position) {
        BlockPos feetPos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_);
        BlockPos groundPos = feetPos.m_7495_();
        BlockPos headPos = feetPos.m_7494_();
        BlockState groundState = wraith.m_9236_().m_8055_(groundPos);
        if (!groundState.m_280296_() || !Block.m_49863_((LevelReader)wraith.m_9236_(), (BlockPos)groundPos, (Direction)Direction.UP)) {
            return false;
        }
        BlockState feetState = wraith.m_9236_().m_8055_(feetPos);
        BlockState headState = wraith.m_9236_().m_8055_(headPos);
        if (!feetState.m_60795_() && !feetState.m_247087_()) {
            return false;
        }
        return headState.m_60795_() || headState.m_247087_();
    }

    private static void spawnTeleportParticles(ServerLevel serverLevel, Vec3 position) {
        for (int i = 0; i < 32; ++i) {
            double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
            double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
            double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123789_, position.f_82479_ + (serverLevel.f_46441_.m_188500_() - 0.5) * 2.0, position.f_82480_ + serverLevel.f_46441_.m_188500_() * 2.0, position.f_82481_ + (serverLevel.f_46441_.m_188500_() - 0.5) * 2.0, 1, d0, d1, d2, 0.1);
        }
    }

    public static void initialize(LostWraithEntity wraith) {
        UUID id = wraith.m_20148_();
        SKILL_EXECUTION.remove(id);
        GLOBAL_SKILL_PREPARATION.remove(id);
    }

    public static void handleTick(LostWraithEntity wraith) {
        if (wraith.m_9236_().f_46443_) {
            return;
        }
        UUID id = wraith.m_20148_();
        SkillExecutionData skillData = SKILL_EXECUTION.get(id);
        if (skillData != null) {
            LostWraithAI.executeCurrentSkill(wraith, skillData);
            return;
        }
        LostWraithAI.findAndUpdateTarget(wraith);
        if (LostWraithAI.shouldExitCombat(wraith)) {
            wraith.m_21573_().m_26573_();
            return;
        }
        LivingEntity target = wraith.m_5448_();
        if (target == null) {
            return;
        }
        LostWraithAI.updateCooldowns(id);
        boolean isExecutingSkill = SKILL_EXECUTION.containsKey(id);
        if (isExecutingSkill) {
            wraith.m_21573_().m_26573_();
        } else {
            wraith.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (!wraith.m_21573_().m_26572_()) {
                wraith.m_21573_().m_5624_((Entity)target, 1.0);
            }
            if (!GLOBAL_SKILL_PREPARATION.containsKey(id)) {
                LostWraithAI.decideAndExecuteSkill(wraith, target);
            }
        }
    }

    public static void cleanupRemovedEntity(UUID entityId) {
        SKILL_EXECUTION.remove(entityId);
        GLOBAL_SKILL_PREPARATION.remove(entityId);
        SummonLightningSkill.LIGHTNING_TARGET_POSITIONS.remove(entityId);
    }

    private static void updateCooldowns(UUID entityId) {
        Integer globalPreparation = GLOBAL_SKILL_PREPARATION.get(entityId);
        if (globalPreparation != null) {
            if (globalPreparation <= 1) {
                GLOBAL_SKILL_PREPARATION.remove(entityId);
            } else {
                GLOBAL_SKILL_PREPARATION.put(entityId, globalPreparation - 1);
            }
        }
    }

    private static void findAndUpdateTarget(LostWraithEntity wraith) {
        Player closestPlayer;
        List nearbyPlayers;
        Player player2;
        LivingEntity attacker;
        Player player3;
        if (wraith.f_19797_ % 20 != 0) {
            return;
        }
        LivingEntity currentTarget = wraith.m_5448_();
        if (currentTarget != null && (currentTarget.m_213877_() || !currentTarget.m_6084_() || (double)wraith.m_20270_((Entity)currentTarget) > 32.0 || currentTarget instanceof Player && (player3 = (Player)currentTarget).m_7500_())) {
            wraith.m_6710_(null);
            currentTarget = null;
        }
        if ((attacker = wraith.m_21188_()) != null && attacker.m_6084_() && (double)wraith.m_20270_((Entity)attacker) <= 32.0 && (!(attacker instanceof Player) || !(player2 = (Player)attacker).m_7500_())) {
            wraith.m_6710_(attacker);
            return;
        }
        if (currentTarget == null && !(nearbyPlayers = wraith.m_9236_().m_6443_(Player.class, wraith.m_20191_().m_82400_(32.0), player -> player.m_6084_() && !player.m_5833_() && !player.m_7500_())).isEmpty() && (closestPlayer = (Player)nearbyPlayers.stream().min(Comparator.comparingDouble(p -> p.m_20280_((Entity)wraith))).orElse(null)) != null) {
            wraith.m_6710_((LivingEntity)closestPlayer);
        }
    }

    private static boolean shouldExitCombat(LostWraithEntity wraith) {
        LivingEntity target = wraith.m_5448_();
        return target == null || !target.m_6084_() || target.m_213877_() || (double)wraith.m_20270_((Entity)target) > 32.0;
    }

    private static void decideAndExecuteSkill(LostWraithEntity wraith, LivingEntity target) {
        UUID id = wraith.m_20148_();
        boolean hasVoidEnchantment = wraith.m_21023_((MobEffect)TheLastSwordModMobEffects.VOID_ENCHANTMENT.get());
        HashMap<String, Double> skillWeights = new HashMap<String, Double>();
        if (!hasVoidEnchantment) {
            skillWeights.put("enchant", 0.5);
        }
        skillWeights.put("punch", 0.5);
        skillWeights.put("dragon_fire_ball", 0.3);
        skillWeights.put("summon_lightning", 0.3);
        skillWeights.put("end_strike", 0.1);
        String skillToUse = LostWraithAI.selectSkillByWeight(skillWeights);
        if (skillToUse != null) {
            LostWraithAI.startSkillExecution(wraith, skillToUse, target);
        }
    }

    private static String selectSkillByWeight(Map<String, Double> weights) {
        if (weights.isEmpty()) {
            return null;
        }
        double totalWeight = weights.values().stream().mapToDouble(Double::doubleValue).sum();
        double randomValue = Math.random() * totalWeight;
        double currentWeight = 0.0;
        for (Map.Entry<String, Double> entry : weights.entrySet()) {
            if (!(randomValue <= (currentWeight += entry.getValue().doubleValue()))) continue;
            return entry.getKey();
        }
        return weights.keySet().iterator().next();
    }

    private static void startSkillExecution(LostWraithEntity wraith, String skillName, LivingEntity target) {
        UUID id = wraith.m_20148_();
        SkillExecutionData data = new SkillExecutionData(skillName, target, wraith.m_20182_());
        SKILL_EXECUTION.put(id, data);
        wraith.m_21573_().m_26573_();
        wraith.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        wraith.setAnimation(skillName);
    }

    private static void executeCurrentSkill(LostWraithEntity wraith, SkillExecutionData data) {
        ++data.tick;
        switch (data.skillName) {
            case "enchant": {
                EnchantSkill.execute(wraith, data.tick);
                break;
            }
            case "punch": {
                PunchSkill.execute(wraith, data.tick);
                break;
            }
            case "dragon_fire_ball": {
                DragonFireBallSkill.execute(wraith, data.tick);
                break;
            }
            case "summon_lightning": {
                SummonLightningSkill.execute(wraith, data.tick, data.targetPosition);
                break;
            }
            case "end_strike": {
                EndStrikeSkill.execute(wraith, data.tick);
            }
        }
        if (LostWraithAI.isSkillComplete(data.skillName, data.tick)) {
            LostWraithAI.finishSkillExecution(wraith);
        }
    }

    private static boolean isSkillComplete(String skillName, int tick) {
        switch (skillName) {
            case "enchant": {
                return tick >= 50;
            }
            case "punch": {
                return tick >= 30;
            }
            case "dragon_fire_ball": {
                return tick >= 60;
            }
            case "summon_lightning": {
                return tick >= 60;
            }
            case "end_strike": {
                return tick >= 80;
            }
        }
        return true;
    }

    private static void finishSkillExecution(LostWraithEntity wraith) {
        UUID id = wraith.m_20148_();
        SkillExecutionData data = SKILL_EXECUTION.remove(id);
        if (data != null) {
            GLOBAL_SKILL_PREPARATION.put(id, 20);
            wraith.setAnimation("empty");
        }
    }

    private static boolean isTargetBlocking(LivingEntity target, LivingEntity attacker) {
        if (!(target instanceof Player)) {
            return false;
        }
        Player player = (Player)target;
        if (!target.m_6117_()) {
            return false;
        }
        ItemStack useItem = target.m_21211_();
        boolean canBlock = false;
        if (useItem.m_150930_(Items.f_42740_)) {
            canBlock = player.m_36335_().m_41521_(useItem.m_41720_(), 0.0f) == 0.0f;
        } else if (useItem.m_41780_() == UseAnim.BLOCK) {
            boolean bl = canBlock = player.m_36335_().m_41521_(useItem.m_41720_(), 0.0f) == 0.0f;
        }
        if (!canBlock) {
            return false;
        }
        Vec3 toAttacker = attacker.m_20182_().m_82546_(target.m_20182_()).m_82541_();
        Vec3 targetLook = target.m_20154_();
        double dotProduct = targetLook.m_82526_(toAttacker);
        return dotProduct > 0.0;
    }

    private static class SkillExecutionData {
        public final String skillName;
        public final LivingEntity originalTarget;
        public final Vec3 targetPosition;
        public int tick = 0;

        public SkillExecutionData(String skillName, LivingEntity target, Vec3 wraitPosition) {
            this.skillName = skillName;
            this.originalTarget = target;
            this.targetPosition = target != null ? target.m_20182_() : wraitPosition;
        }
    }

    private static class SummonLightningSkill {
        private static final Map<UUID, Vec3> LIGHTNING_TARGET_POSITIONS = new ConcurrentHashMap<UUID, Vec3>();

        private SummonLightningSkill() {
        }

        public static void execute(LostWraithEntity wraith, int tick, Vec3 originalTargetPos) {
            Level recordedPos;
            UUID id = wraith.m_20148_();
            if (tick == 20) {
                LivingEntity target = wraith.m_5448_();
                recordedPos = target != null ? target.m_20182_() : originalTargetPos;
                LIGHTNING_TARGET_POSITIONS.put(id, (Vec3)recordedPos);
            }
            if (tick == 40 && (recordedPos = wraith.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)recordedPos;
                Vec3 targetPos = LIGHTNING_TARGET_POSITIONS.getOrDefault(id, originalTargetPos);
                BlockPos lightningPos = new BlockPos((int)targetPos.f_82479_, (int)targetPos.f_82480_, (int)targetPos.f_82481_);
                PurpleLightingEntity lightning = new PurpleLightingEntity((EntityType<PurpleLightingEntity>)((EntityType)TheLastSwordModEntities.PURPLE_LIGHTING.get()), (Level)serverLevel);
                lightning.m_6027_(lightningPos.m_123341_(), lightningPos.m_123342_(), lightningPos.m_123343_());
                serverLevel.m_7967_((Entity)lightning);
                AABB area = new AABB(targetPos.m_82492_(3.0, 3.0, 3.0), targetPos.m_82520_(3.0, 3.0, 3.0));
                List targets = wraith.m_9236_().m_6443_(LivingEntity.class, area, entity -> entity != wraith && !wraith.m_7307_((Entity)entity));
                float damage = (float)wraith.m_21133_(Attributes.f_22281_) * 2.0f;
                DamageSource damageSource = new DamageSource((Holder)wraith.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268450_), (Entity)wraith, (Entity)wraith);
                for (LivingEntity target : targets) {
                    target.m_6469_(damageSource, damage);
                }
                LIGHTNING_TARGET_POSITIONS.remove(id);
            }
        }
    }

    private static class EnchantSkill {
        private EnchantSkill() {
        }

        public static void execute(LostWraithEntity wraith, int tick) {
            if (tick == 50) {
                MobEffectInstance voidEnchant = new MobEffectInstance((MobEffect)TheLastSwordModMobEffects.VOID_ENCHANTMENT.get(), 1200, 0, false, false);
                wraith.m_7292_(voidEnchant);
                Level level = wraith.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 20; ++i) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, wraith.m_20185_() + (wraith.m_217043_().m_188500_() - 0.5) * 2.0, wraith.m_20186_() + wraith.m_217043_().m_188500_() * 2.0, wraith.m_20189_() + (wraith.m_217043_().m_188500_() - 0.5) * 2.0, 1, 0.0, 0.1, 0.0, 1.0);
                    }
                }
            }
        }
    }

    private static class PunchSkill {
        private PunchSkill() {
        }

        public static void execute(LostWraithEntity wraith, int tick) {
            LivingEntity target;
            if (tick == 1 && (target = wraith.m_5448_()) != null) {
                LostWraithAI.teleportToTarget(wraith, target);
            }
            if (tick == 24) {
                Vec3 forward = wraith.m_20154_();
                Vec3 pos = wraith.m_20182_();
                for (int i = 1; i <= 4; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        Vec3 right = forward.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
                        Vec3 checkPos = pos.m_82549_(forward.m_82490_((double)i)).m_82549_(right.m_82490_((double)j));
                        AABB area = new AABB(checkPos.m_82492_(0.5, 0.5, 0.5), checkPos.m_82520_(0.5, 0.5, 0.5));
                        List targets = wraith.m_9236_().m_6443_(LivingEntity.class, area, entity -> entity != wraith && !wraith.m_7307_((Entity)entity));
                        float damage = (float)wraith.m_21133_(Attributes.f_22281_);
                        DamageSource damageSource = new DamageSource((Holder)wraith.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268433_), (Entity)wraith, (Entity)wraith);
                        for (LivingEntity target2 : targets) {
                            if (LostWraithAI.isTargetBlocking(target2, (LivingEntity)wraith)) {
                                target2.m_9236_().m_5594_(null, target2.m_20183_(), SoundEvents.f_12346_, target2.m_5720_(), 1.0f, 0.8f + target2.m_9236_().f_46441_.m_188501_() * 0.4f);
                                Vec3 knockbackDir = target2.m_20182_().m_82546_(wraith.m_20182_()).m_82541_();
                                target2.m_147240_(0.5, knockbackDir.f_82479_, knockbackDir.f_82481_);
                                continue;
                            }
                            target2.m_6469_(damageSource, damage);
                        }
                    }
                }
            }
        }
    }

    private static class DragonFireBallSkill {
        private DragonFireBallSkill() {
        }

        public static void execute(LostWraithEntity wraith, int tick) {
            Level level;
            if (tick == 40 && (level = wraith.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                LivingEntity target = wraith.m_5448_();
                if (target != null) {
                    Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() * 0.5, 0.0);
                    Vec3 startPos = wraith.m_20182_().m_82520_(0.0, (double)wraith.m_20192_(), 0.0);
                    Vec3 direction = targetPos.m_82546_(startPos).m_82541_();
                    DragonFireball dragonFireball = new DragonFireball(wraith.m_9236_(), (LivingEntity)wraith, direction.f_82479_, direction.f_82480_, direction.f_82481_);
                    dragonFireball.m_6034_(startPos.f_82479_, startPos.f_82480_, startPos.f_82481_);
                    wraith.m_9236_().m_7967_((Entity)dragonFireball);
                    wraith.m_9236_().m_5594_(null, wraith.m_20183_(), SoundEvents.f_11896_, wraith.m_5720_(), 1.0f, 1.0f);
                }
            }
        }
    }

    private static class EndStrikeSkill {
        private static final Map<UUID, List<TargetPositionData>> PULL_TARGETS = new ConcurrentHashMap<UUID, List<TargetPositionData>>();

        private EndStrikeSkill() {
        }

        public static void execute(LostWraithEntity wraith, int tick) {
            List<TargetPositionData> pullData;
            LivingEntity target;
            UUID id = wraith.m_20148_();
            if (tick == 1 && (target = wraith.m_5448_()) != null) {
                LostWraithAI.teleportToTarget(wraith, target);
            }
            if (tick == 30) {
                Vec3 forward = wraith.m_20154_();
                Vec3 centerPos = wraith.m_20182_().m_82549_(forward.m_82490_(2.0));
                AABB area = new AABB(centerPos.m_82492_(2.0, 2.0, 2.0), centerPos.m_82520_(2.0, 2.0, 2.0));
                List targets = wraith.m_9236_().m_6443_(LivingEntity.class, area, entity -> {
                    Player player;
                    return entity != wraith && !wraith.m_7307_((Entity)entity) && (!(entity instanceof Player) || !(player = (Player)entity).m_7500_());
                });
                ArrayList<TargetPositionData> pullData2 = new ArrayList<TargetPositionData>();
                Vec3 pullTarget = wraith.m_20182_().m_82549_(forward.m_82490_(1.0));
                for (LivingEntity target2 : targets) {
                    pullData2.add(new TargetPositionData(target2, pullTarget));
                }
                PULL_TARGETS.put(id, pullData2);
            }
            if (tick > 30 && tick < 70 && (pullData = PULL_TARGETS.get(id)) != null) {
                pullData.removeIf(data -> !data.target.m_6084_());
                for (TargetPositionData data2 : pullData) {
                    data2.target.m_6021_(data2.position.f_82479_, data2.position.f_82480_, data2.position.f_82481_);
                }
            }
            if (tick == 70 && (pullData = PULL_TARGETS.remove(id)) != null) {
                float lostHealth = wraith.m_21233_() - wraith.m_21223_();
                float damage = lostHealth * 0.1f;
                for (TargetPositionData data3 : pullData) {
                    Player player;
                    Object object;
                    if (!data3.target.m_6084_()) continue;
                    if (LostWraithAI.isTargetBlocking(data3.target, (LivingEntity)wraith)) {
                        data3.target.m_9236_().m_5594_(null, data3.target.m_20183_(), SoundEvents.f_12346_, data3.target.m_5720_(), 1.0f, 0.8f + data3.target.m_9236_().f_46441_.m_188501_() * 0.4f);
                        object = data3.target;
                        if (object instanceof Player) {
                            player = (Player)object;
                            ItemStack blockingItem = data3.target.m_21211_();
                            player.m_36335_().m_41524_(blockingItem.m_41720_(), 260);
                        }
                        Vec3 knockback = wraith.m_20182_().m_82546_(data3.target.m_20182_()).m_82541_().m_82490_(-0.3);
                        data3.target.m_20256_(data3.target.m_20184_().m_82549_(knockback));
                        continue;
                    }
                    object = data3.target;
                    if (object instanceof Player && (player = (Player)object).m_7500_()) {
                        return;
                    }
                    AbsoluteDestructionDamageSource.applyAbsoluteDestructionIntelligently(data3.target, (Entity)wraith, damage);
                }
            }
        }
    }

    private static class TargetPositionData {
        public final LivingEntity target;
        public final Vec3 position;

        public TargetPositionData(LivingEntity target, Vec3 position) {
            this.target = target;
            this.position = position;
        }
    }
}

