/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.entity.ai;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.the_last_sword.attack.AbsoluteDestructionDamageSource;
import net.the_last_sword.compat.cataclysm.TheLastEndSwordWraithEntityCataclysmTalk;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.entity.TheLastEndEntity;
import net.the_last_sword.entity.TheLastEndSwordWraithEntity;
import net.the_last_sword.init.TheLastSwordModMobEffects;
import net.the_last_sword.util.EntityUtil;
import net.the_last_sword.util.TheLastSwordLogger;
import net.the_last_sword.util.UnsafeUtil;
import org.joml.Matrix4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;

public final class TheLastEndSwordWraithAI {
    private static final Map<UUID, Integer> AWKWARD_DISTANCE_TIMERS = new ConcurrentHashMap<UUID, Integer>();
    private static final Map<UUID, TargetTrackingData> TARGET_TRACKING = new ConcurrentHashMap<UUID, TargetTrackingData>();
    private static final double MAX_SEARCH_DISTANCE = 32.0;
    private static final double DASH_TRIGGER_DISTANCE = 16.0;
    private static final int AWKWARD_DISTANCE_TIMEOUT = 100;
    private static final int MAX_STUCK_TICKS = 200;
    private static final int MAX_NO_PROGRESS_TICKS = 300;
    private static final double MIN_PROGRESS_DISTANCE = 0.5;
    private static final double MAX_OWNER_DISTANCE = 32.0;

    private TheLastEndSwordWraithAI() {
    }

    private static double getCombatDistance(TheLastEndSwordWraithEntity wraith) {
        return wraith.getAttackRange();
    }

    public static void initialize(TheLastEndSwordWraithEntity wraith) {
        AWKWARD_DISTANCE_TIMERS.remove(wraith.m_20148_());
        TARGET_TRACKING.entrySet().removeIf(entry -> {
            TargetTrackingData data = (TargetTrackingData)entry.getValue();
            return data.lastPosition == null;
        });
        String currentAnimation = wraith.getSyncedAnimation();
        if (!currentAnimation.equals("spawn")) {
            wraith.setAnimationTick(0);
            wraith.setAnimation("empty");
        }
        wraith.setAllowMoving(true);
    }

    public static void handleTick(TheLastEndSwordWraithEntity wraith) {
        if (wraith.m_9236_().f_46443_) {
            return;
        }
        AllThingsEndActiveEffect.handleTick(wraith);
        if (TheLastEndSwordWraithAI.checkOwnerDistanceAndTeleport(wraith)) {
            return;
        }
        TheLastEndSwordWraithAI.updateTargetList(wraith);
        TheLastEndSwordWraithAI.updateCurrentTarget(wraith);
        if (!wraith.getIsSpawned()) {
            return;
        }
        if (TheLastEndSwordWraithAI.shouldExitCombat(wraith)) {
            TheLastEndSwordWraithAI.exitCombatState(wraith);
            return;
        }
        TheLastEndSwordWraithAI.updateAwkwardDistanceTimer(wraith);
        if (TheLastEndSwordWraithAI.isExecutingSkill(wraith)) {
            TheLastEndSwordWraithAI.updateSkillTick(wraith);
            TheLastEndSwordWraithAI.executeCurrentSkill(wraith);
            return;
        }
        TheLastEndSwordWraithAI.handleNavigationAndMovement(wraith);
        TheLastEndSwordWraithAI.tryStartNewSkill(wraith);
        if (wraith.f_19797_ % 60 == 0) {
            // empty if block
        }
    }

    private static boolean checkOwnerDistanceAndTeleport(TheLastEndSwordWraithEntity wraith) {
        LivingEntity owner = wraith.m_269323_();
        if (owner == null || !owner.m_6084_()) {
            return false;
        }
        double distanceToOwner = wraith.m_20270_((Entity)owner);
        if (distanceToOwner > 32.0) {
            if (TheLastEndSwordWraithAI.isExecutingSkill(wraith)) {
                return false;
            }
            TheLastEndSwordWraithAI.forceTeleportToOwner(wraith, owner);
            return true;
        }
        return false;
    }

    private static void forceTeleportToOwner(TheLastEndSwordWraithEntity wraith, LivingEntity owner) {
        TheLastEndSwordWraithAI.clearCombatStateForOwnerReturn(wraith);
        Vec3 teleportPos = TheLastEndSwordWraithAI.findSafeTeleportPosition(wraith, owner);
        TheLastEndSwordWraithAI.spawnTeleportEffects(wraith, teleportPos);
        UnsafeUtil.UnsafeTeleport((Entity)wraith, teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
    }

    private static void clearCombatStateForOwnerReturn(TheLastEndSwordWraithEntity wraith) {
        if (TheLastEndSwordWraithAI.isExecutingSkill(wraith)) {
            TheLastEndSwordWraithAI.endSkill(wraith);
        }
        wraith.targetList.clear();
        wraith.m_6710_(null);
        wraith.m_21573_().m_26573_();
        wraith.setAllowMoving(true);
        AWKWARD_DISTANCE_TIMERS.remove(wraith.m_20148_());
    }

    private static Vec3 findSafeTeleportPosition(TheLastEndSwordWraithEntity wraith, LivingEntity owner) {
        Vec3 ownerPos = owner.m_20182_();
        for (int attempts = 0; attempts < 8; ++attempts) {
            double z;
            double y;
            double angle = Math.PI * 2 * (double)attempts / 8.0;
            double distance = 2.0 + (double)attempts * 0.5;
            double x = ownerPos.f_82479_ + Math.cos(angle) * distance;
            if (!TheLastEndSwordWraithAI.isSafeTeleportPosition(wraith, x, y = ownerPos.f_82480_, z = ownerPos.f_82481_ + Math.sin(angle) * distance)) continue;
            return new Vec3(x, y, z);
        }
        return ownerPos;
    }

    private static boolean isSafeTeleportPosition(TheLastEndSwordWraithEntity wraith, double x, double y, double z) {
        Vec3 pos = new Vec3(x, y, z);
        return !wraith.m_9236_().m_8055_(new BlockPos((int)x, (int)y, (int)z)).m_280296_();
    }

    private static void spawnTeleportEffects(TheLastEndSwordWraithEntity wraith, Vec3 targetPos) {
        Level level;
        if (wraith.m_9236_().f_46443_ || !((level = wraith.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 oldPos = wraith.m_20182_();
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, oldPos.f_82479_, oldPos.f_82480_ + (double)wraith.m_20206_() * 0.5, oldPos.f_82481_, 20, 0.3, 0.3, 0.3, 0.1);
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, targetPos.f_82479_, targetPos.f_82480_ + (double)wraith.m_20206_() * 0.5, targetPos.f_82481_, 20, 0.3, 0.3, 0.3, 0.1);
        wraith.m_9236_().m_6263_(null, wraith.m_20185_(), wraith.m_20186_(), wraith.m_20189_(), SoundEvents.f_11852_, wraith.m_5720_(), 0.8f, 1.0f);
    }

    private static void updateTargetList(TheLastEndSwordWraithEntity wraith) {
        if (wraith.f_19797_ % 20 != 0) {
            return;
        }
        List<LivingEntity> targetList = wraith.targetList;
        targetList.removeIf(target -> target == null || !target.m_6084_() || target.m_213877_() || (double)wraith.m_20270_((Entity)target) > 32.0);
        List<Entity> newTargets = EntityUtil.getAttackTargets(wraith.m_9236_(), (LivingEntity)wraith, 32.0);
        for (Entity entity : newTargets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            UUID newUUID = livingEntity.m_20148_();
            boolean exists = targetList.stream().anyMatch(existing -> existing.m_20148_().equals(newUUID));
            if (exists) continue;
            targetList.add(livingEntity);
        }
    }

    private static void updateCurrentTarget(TheLastEndSwordWraithEntity wraith) {
        UUID targetId;
        TargetTrackingData tracking;
        List<LivingEntity> targetList = wraith.targetList;
        LivingEntity currentTarget = wraith.m_5448_();
        UUID wraithId = wraith.m_20148_();
        if (currentTarget != null && (tracking = TARGET_TRACKING.get(targetId = currentTarget.m_20148_())) != null) {
            tracking.updateProgress(wraith, currentTarget);
            if (tracking.shouldAbandon()) {
                TheLastEndSwordWraithAI.abandonTarget(wraith, currentTarget);
                currentTarget = null;
            }
        }
        if (!targetList.isEmpty()) {
            LivingEntity bestTarget = TheLastEndSwordWraithAI.selectTargetWithOwnerPriority(wraith, targetList);
            if (!(bestTarget == null || bestTarget == currentTarget || currentTarget != null && currentTarget.m_6084_() && targetList.contains(currentTarget) && !TheLastEndSwordWraithAI.shouldSwitchTarget(wraith, currentTarget, bestTarget))) {
                TheLastEndSwordWraithAI.setNewTarget(wraith, bestTarget);
            }
        } else if (currentTarget != null) {
            TheLastEndSwordWraithAI.abandonTarget(wraith, currentTarget);
        }
    }

    private static void setNewTarget(TheLastEndSwordWraithEntity wraith, LivingEntity newTarget) {
        LivingEntity oldTarget = wraith.m_5448_();
        if (oldTarget != null) {
            TARGET_TRACKING.remove(oldTarget.m_20148_());
        }
        wraith.m_6710_(newTarget);
        TARGET_TRACKING.put(newTarget.m_20148_(), new TargetTrackingData(newTarget.m_20148_()));
        try {
            TheLastEndSwordWraithEntityCataclysmTalk.onTargetSet(wraith, newTarget);
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Error triggering cataclysm talk: {}", e.getMessage());
        }
    }

    private static void abandonTarget(TheLastEndSwordWraithEntity wraith, LivingEntity target) {
        wraith.m_6710_(null);
        TARGET_TRACKING.remove(target.m_20148_());
        wraith.targetList.remove(target);
        if (TheLastEndSwordWraithAI.isExecutingSkill(wraith)) {
            TheLastEndSwordWraithAI.endSkill(wraith);
        }
        wraith.m_21573_().m_26573_();
        wraith.setAllowMoving(true);
    }

    private static LivingEntity selectTargetWithOwnerPriority(TheLastEndSwordWraithEntity wraith, List<LivingEntity> targetList) {
        if (targetList.isEmpty()) {
            return null;
        }
        LivingEntity owner = wraith.m_269323_();
        if (owner == null) {
            return TheLastEndSwordWraithAI.selectSmartTarget(wraith, targetList);
        }
        LivingEntity ownerTarget = owner.m_21214_();
        if (ownerTarget != null && targetList.contains(ownerTarget) && ownerTarget.m_6084_() && TheLastEndSwordWraithAI.isTargetAccessible(wraith, ownerTarget)) {
            return ownerTarget;
        }
        LivingEntity ownerAttacker = owner.m_21188_();
        if (ownerAttacker != null && targetList.contains(ownerAttacker) && ownerAttacker.m_6084_() && TheLastEndSwordWraithAI.isTargetAccessible(wraith, ownerAttacker)) {
            return ownerAttacker;
        }
        return TheLastEndSwordWraithAI.selectSmartTarget(wraith, targetList);
    }

    private static LivingEntity selectSmartTarget(TheLastEndSwordWraithEntity wraith, List<LivingEntity> candidates) {
        LivingEntity reachableTarget = candidates.stream().filter(target -> TheLastEndSwordWraithAI.isTargetReachable(wraith, target) && wraith.m_142582_((Entity)target)).min(Comparator.comparing(target -> Float.valueOf(wraith.m_20270_((Entity)target)))).orElse(null);
        if (reachableTarget != null) {
            return reachableTarget;
        }
        LivingEntity visibleTarget = candidates.stream().filter(target -> wraith.m_142582_((Entity)target)).min(Comparator.comparing(target -> Float.valueOf(wraith.m_20270_((Entity)target)))).orElse(null);
        if (visibleTarget != null) {
            return visibleTarget;
        }
        return TheLastEndSwordWraithAI.getClosestTarget(wraith, candidates);
    }

    private static boolean isTargetAccessible(TheLastEndSwordWraithEntity wraith, LivingEntity target) {
        return TheLastEndSwordWraithAI.isTargetReachable(wraith, target) && wraith.m_142582_((Entity)target);
    }

    private static boolean isTargetReachable(TheLastEndSwordWraithEntity wraith, LivingEntity target) {
        try {
            Path path = wraith.m_21573_().m_6570_((Entity)target, 0);
            return path != null && path.m_77403_();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static LivingEntity getClosestTarget(TheLastEndSwordWraithEntity wraith, List<LivingEntity> targetList) {
        LivingEntity closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (LivingEntity target : targetList) {
            double distance;
            if (target == null || !target.m_6084_() || !((distance = (double)wraith.m_20270_((Entity)target)) < closestDistance)) continue;
            closestDistance = distance;
            closest = target;
        }
        return closest;
    }

    private static boolean shouldSwitchTarget(TheLastEndSwordWraithEntity wraith, LivingEntity currentTarget, LivingEntity newTarget) {
        if (currentTarget == null || !currentTarget.m_6084_()) {
            return true;
        }
        LivingEntity owner = wraith.m_269323_();
        if (owner == null) {
            return false;
        }
        if (newTarget == owner.m_21214_()) {
            return true;
        }
        return newTarget == owner.m_21188_() && currentTarget != owner.m_21214_();
    }

    private static boolean shouldExitCombat(TheLastEndSwordWraithEntity wraith) {
        return wraith.m_5448_() == null || !wraith.m_5448_().m_6084_();
    }

    private static void exitCombatState(TheLastEndSwordWraithEntity wraith) {
        if (TheLastEndSwordWraithAI.isExecutingSkill(wraith)) {
            TheLastEndSwordWraithAI.endSkill(wraith);
        }
        wraith.m_21573_().m_26573_();
        TheLastEndSwordWraithAI.resetLookDirection(wraith);
        AWKWARD_DISTANCE_TIMERS.remove(wraith.m_20148_());
        wraith.setAllowMoving(true);
    }

    private static void updateAwkwardDistanceTimer(TheLastEndSwordWraithEntity wraith) {
        LivingEntity target = wraith.m_5448_();
        if (target == null || !target.m_6084_()) {
            AWKWARD_DISTANCE_TIMERS.remove(wraith.m_20148_());
            return;
        }
        double distance = wraith.m_20270_((Entity)target);
        double combatDistance = TheLastEndSwordWraithAI.getCombatDistance(wraith);
        UUID wraithId = wraith.m_20148_();
        if (distance > combatDistance && distance <= 16.0) {
            Integer currentTimer = AWKWARD_DISTANCE_TIMERS.get(wraithId);
            if (currentTimer == null) {
                AWKWARD_DISTANCE_TIMERS.put(wraithId, 1);
            } else {
                AWKWARD_DISTANCE_TIMERS.put(wraithId, currentTimer + 1);
            }
        } else {
            AWKWARD_DISTANCE_TIMERS.remove(wraithId);
        }
    }

    private static boolean shouldForceSlash(TheLastEndSwordWraithEntity wraith) {
        UUID wraithId = wraith.m_20148_();
        Integer timer = AWKWARD_DISTANCE_TIMERS.get(wraithId);
        return timer != null && timer >= 100;
    }

    private static void handleNavigationAndMovement(TheLastEndSwordWraithEntity wraith) {
        double combatDistance;
        LivingEntity target = wraith.m_5448_();
        if (target == null || !target.m_6084_()) {
            wraith.m_21573_().m_26573_();
            TheLastEndSwordWraithAI.resetLookDirection(wraith);
            return;
        }
        double distance = wraith.m_20270_((Entity)target);
        if (distance > (combatDistance = TheLastEndSwordWraithAI.getCombatDistance(wraith)) && distance <= 32.0) {
            wraith.setAllowMoving(true);
            if (wraith.f_19797_ % 40 == 0) {
                wraith.m_21573_().m_5624_((Entity)target, 1.0);
            }
        } else if (distance <= combatDistance) {
            wraith.m_21573_().m_26573_();
            wraith.setAllowMoving(false);
        }
        if (distance <= 16.0) {
            wraith.m_21563_().m_24950_(target.m_20185_(), wraith.m_20188_(), target.m_20189_(), 10.0f, 10.0f);
        }
    }

    private static void resetLookDirection(TheLastEndSwordWraithEntity wraith) {
        wraith.m_146926_(0.0f);
    }

    public static boolean isExecutingSkill(TheLastEndSwordWraithEntity wraith) {
        return wraith.getIsSpawned() && wraith.getAnimationTick() > 0 && !wraith.getSyncedAnimation().equals("empty") && !wraith.getSyncedAnimation().equals("idle");
    }

    private static void updateSkillTick(TheLastEndSwordWraithEntity wraith) {
        int currentTick = wraith.getAnimationTick();
        wraith.setAnimationTick(currentTick + 1);
    }

    private static void executeCurrentSkill(TheLastEndSwordWraithEntity wraith) {
        String currentSkill = wraith.getSyncedAnimation();
        int tick = wraith.getAnimationTick();
        switch (currentSkill) {
            case "idle": {
                TheLastEndSwordWraithAI.endSkillAndStartNext(wraith);
                break;
            }
            case "swift_dash": {
                SwiftDashSkill.execute(wraith, tick);
                break;
            }
            case "enchant": {
                EnchantSkill.execute(wraith, tick);
                break;
            }
            case "double_strike": {
                DoubleStrikeSkill.execute(wraith, tick);
                break;
            }
            case "cross_slash": {
                CrossSlashSkill.execute(wraith, tick);
                break;
            }
            case "end_of_all_things": {
                EndOfAllThingsSkill.execute(wraith, tick);
                break;
            }
            default: {
                TheLastEndSwordWraithAI.endSkillAndStartNext(wraith);
            }
        }
    }

    private static void tryStartNewSkill(TheLastEndSwordWraithEntity wraith) {
        LivingEntity target = wraith.m_5448_();
        if (target == null || !target.m_6084_()) {
            return;
        }
        double distance = wraith.m_20270_((Entity)target);
        double combatDistance = TheLastEndSwordWraithAI.getCombatDistance(wraith);
        if (TheLastEndSwordWraithAI.shouldForceSlash(wraith)) {
            TheLastEndSwordWraithAI.startSkill(wraith, "cross_slash");
            AWKWARD_DISTANCE_TIMERS.remove(wraith.m_20148_());
            return;
        }
        if (distance > combatDistance) {
            if (distance > 16.0) {
                TheLastEndSwordWraithAI.selectLongRangeSkill(wraith, target, distance);
            }
            return;
        }
        TheLastEndSwordWraithAI.selectSkillInCombat(wraith);
    }

    private static void selectLongRangeSkill(TheLastEndSwordWraithEntity wraith, LivingEntity target, double distance) {
        boolean targetStuck;
        boolean canDash = TheLastEndSwordWraithAI.canDashToTarget(wraith, target);
        TargetTrackingData tracking = TARGET_TRACKING.get(target.m_20148_());
        boolean bl = targetStuck = tracking != null && tracking.stuckTicks > 50;
        if (canDash && !targetStuck && Math.random() < 0.4) {
            TheLastEndSwordWraithAI.startSkill(wraith, "swift_dash");
        } else if (wraith.m_142582_((Entity)target) && Math.random() < 0.6) {
            TheLastEndSwordWraithAI.startSkill(wraith, "cross_slash");
        }
    }

    private static boolean canDashToTarget(TheLastEndSwordWraithEntity wraith, LivingEntity target) {
        Vec3 from = wraith.m_20182_().m_82520_(0.0, (double)wraith.m_20206_() * 0.5, 0.0);
        Vec3 to = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
        try {
            BlockHitResult hitResult = wraith.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)wraith));
            return hitResult.m_6662_() == HitResult.Type.MISS;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void selectSkillInCombat(TheLastEndSwordWraithEntity wraith) {
        HashMap<String, Integer> skillWeights = new HashMap<String, Integer>();
        if (wraith.getEndLevel() >= wraith.getAllThingsEndLevel() && !wraith.isAllThingsEnd()) {
            skillWeights.put("end_of_all_things", 100);
        } else if (skillWeights.isEmpty()) {
            skillWeights.put("double_strike", 100);
        }
        int totalWeight = skillWeights.values().stream().mapToInt(Integer::intValue).sum();
        int randomValue = wraith.m_217043_().m_188503_(totalWeight);
        int currentWeight = 0;
        for (Map.Entry entry : skillWeights.entrySet()) {
            if (randomValue >= (currentWeight += ((Integer)entry.getValue()).intValue())) continue;
            TheLastEndSwordWraithAI.startSkill(wraith, (String)entry.getKey());
            return;
        }
    }

    private static void startSkill(TheLastEndSwordWraithEntity wraith, String skillName) {
        wraith.setAnimation(skillName);
        wraith.setAnimationTick(1);
        wraith.setAnimation(skillName);
        if (!skillName.equals("swift_dash")) {
            wraith.setAllowMoving(false);
        }
    }

    private static void endSkillAndStartNext(TheLastEndSwordWraithEntity wraith) {
        double distanceToOwner;
        wraith.setAnimationTick(0);
        wraith.setAnimation("empty");
        LivingEntity owner = wraith.m_269323_();
        if (owner != null && owner.m_6084_() && (distanceToOwner = (double)wraith.m_20270_((Entity)owner)) > 32.0) {
            TheLastEndSwordWraithAI.forceTeleportToOwner(wraith, owner);
            return;
        }
        TheLastEndSwordWraithAI.tryStartNewSkill(wraith);
        if (wraith.getSyncedAnimation().equals("empty")) {
            wraith.setAnimation("empty");
            wraith.setAllowMoving(true);
        }
    }

    private static void endSkill(TheLastEndSwordWraithEntity wraith) {
        double distanceToOwner;
        wraith.setAnimation("empty");
        wraith.setAnimationTick(0);
        wraith.setAnimation("empty");
        wraith.setAllowMoving(true);
        LivingEntity owner = wraith.m_269323_();
        if (owner != null && owner.m_6084_() && (distanceToOwner = (double)wraith.m_20270_((Entity)owner)) > 32.0) {
            TheLastEndSwordWraithAI.forceTeleportToOwner(wraith, owner);
        }
    }

    private static Vec3 getLocatorPosition(TheLastEndSwordWraithEntity wraith, String locatorName) {
        try {
            BakedGeoModel model = wraith.getCurrentBakedModel();
            if (model == null) {
                return null;
            }
            GeoBone locatorBone = model.getBone(locatorName).orElse(null);
            if (locatorBone == null) {
                return null;
            }
            Matrix4f transform = locatorBone.getModelSpaceMatrix();
            double offsetX = transform.m30();
            double offsetY = transform.m31();
            double offsetZ = transform.m32();
            Vec3 entityPos = wraith.m_20182_();
            return new Vec3(entityPos.f_82479_ + offsetX, entityPos.f_82480_ + offsetY, entityPos.f_82481_ + offsetZ);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void syncEntityPositionToLocator(TheLastEndSwordWraithEntity wraith, String locatorName) {
        Vec3 locatorPos = TheLastEndSwordWraithAI.getLocatorPosition(wraith, locatorName);
        if (locatorPos != null) {
            UnsafeUtil.UnsafeTeleport((Entity)wraith, locatorPos.f_82479_, locatorPos.f_82480_, locatorPos.f_82481_);
        }
    }

    public static void cleanupRemovedEntity(UUID entityId) {
        AWKWARD_DISTANCE_TIMERS.remove(entityId);
        TARGET_TRACKING.entrySet().removeIf(entry -> {
            TargetTrackingData data = (TargetTrackingData)entry.getValue();
            return data.targetId.equals(entityId);
        });
        try {
            TheLastEndSwordWraithEntityCataclysmTalk.cleanupTalkedBoss(entityId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void forceExecuteEndOfAllThings(TheLastEndSwordWraithEntity wraith) {
        if (!TheLastEndSwordWraithAI.isExecutingSkill(wraith)) {
            TheLastEndSwordWraithAI.startSkill(wraith, "end_of_all_things");
        }
    }

    public static void handleLevelChange(TheLastEndSwordWraithEntity wraith, int oldLevel, int newLevel) {
        if (TheLastEndSwordWraithAI.isExecutingSkill(wraith)) {
            TheLastEndSwordWraithAI.endSkill(wraith);
        }
    }

    public static void onAllThingsEndUnlocked(TheLastEndSwordWraithEntity wraith) {
    }

    public static void onAllThingsEndLost(TheLastEndSwordWraithEntity wraith) {
        if (wraith.getSyncedAnimation().equals("end_of_all_things")) {
            TheLastEndSwordWraithAI.endSkill(wraith);
        }
        AllThingsEndActiveEffect.forceStop(wraith.m_20148_());
    }

    public static boolean hasActiveAllThingsEndEffect(TheLastEndSwordWraithEntity wraith) {
        return AllThingsEndActiveEffect.isActive(wraith);
    }

    public static int getAllThingsEndRemainingTime(TheLastEndSwordWraithEntity wraith) {
        return AllThingsEndActiveEffect.getRemainingTime(wraith);
    }

    private static class AllThingsEndActiveEffect {
        private static final Map<UUID, Integer> ACTIVE_EFFECTS = new ConcurrentHashMap<UUID, Integer>();
        private static final int DURATION = 260;
        private static final int CHECK_INTERVAL = 20;

        private AllThingsEndActiveEffect() {
        }

        public static void start(TheLastEndSwordWraithEntity wraith) {
            ACTIVE_EFFECTS.put(wraith.m_20148_(), 0);
        }

        public static void handleTick(TheLastEndSwordWraithEntity wraith) {
            UUID id = wraith.m_20148_();
            Integer currentTick = ACTIVE_EFFECTS.get(id);
            if (currentTick == null) {
                return;
            }
            int newTick = currentTick + 1;
            if (newTick % 20 == 0) {
                AllThingsEndActiveEffect.executeDeathJudgment(wraith);
            }
            if (newTick >= 260) {
                AllThingsEndActiveEffect.end(wraith);
            } else {
                ACTIVE_EFFECTS.put(id, newTick);
            }
        }

        public static void end(TheLastEndSwordWraithEntity wraith) {
            ACTIVE_EFFECTS.remove(wraith.m_20148_());
        }

        public static void forceStop(UUID entityId) {
            ACTIVE_EFFECTS.remove(entityId);
        }

        public static boolean isActive(TheLastEndSwordWraithEntity wraith) {
            return ACTIVE_EFFECTS.containsKey(wraith.m_20148_());
        }

        public static int getRemainingTime(TheLastEndSwordWraithEntity wraith) {
            Integer currentTick = ACTIVE_EFFECTS.get(wraith.m_20148_());
            if (currentTick == null) {
                return 0;
            }
            return Math.max(0, 260 - currentTick);
        }

        private static void executeDeathJudgment(TheLastEndSwordWraithEntity wraith) {
            if (wraith.m_9236_().f_46443_) {
                return;
            }
            double searchRange = wraith.m_21133_(Attributes.f_22277_);
            List nearbyEntities = wraith.m_9236_().m_6443_(LivingEntity.class, wraith.m_20191_().m_82400_(searchRange), entity -> entity != wraith && entity.m_6084_() && !entity.m_213877_());
            for (LivingEntity target : nearbyEntities) {
                if (!AllThingsEndActiveEffect.isValidTarget(wraith, target)) continue;
                AllThingsEndActiveEffect.applyEndDeath(wraith, target);
            }
        }

        private static boolean isValidTarget(TheLastEndSwordWraithEntity wraith, LivingEntity target) {
            TamableAnimal tamable;
            Player player;
            if (target instanceof Player && wraith.m_21830_((LivingEntity)(player = (Player)target))) {
                return false;
            }
            if (target instanceof TheLastEndEntity) {
                return false;
            }
            return !(target instanceof TamableAnimal) || !(tamable = (TamableAnimal)target).m_21824_() || wraith.m_269323_() == null || !wraith.m_269323_().equals((Object)tamable.m_269323_());
        }

        private static void applyEndDeath(TheLastEndSwordWraithEntity wraith, LivingEntity target) {
            if (wraith.m_9236_().f_46443_) {
                return;
            }
            DamageSource endDeathSource = AbsoluteDestructionDamageSource.absoluteDestruction((Entity)wraith);
            float lethalDamage = Math.max(target.m_21233_() * 2.0f, 1000.0f);
            target.m_6469_(endDeathSource, lethalDamage);
            AllThingsEndActiveEffect.spawnDeathParticles(target);
            AllThingsEndActiveEffect.playDeathSound(target);
        }

        private static void spawnDeathParticles(LivingEntity target) {
            Level level;
            if (target.m_9236_().f_46443_ || !((level = target.m_9236_()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 pos = target.m_20182_();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123789_, pos.f_82479_, pos.f_82480_ + (double)target.m_20206_() * 0.5, pos.f_82481_, 30, 0.5, 0.5, 0.5, 0.2);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123799_, pos.f_82479_, pos.f_82480_ + (double)target.m_20206_() * 0.5, pos.f_82481_, 20, 0.3, 0.3, 0.3, 0.1);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, pos.f_82479_, pos.f_82480_ + (double)target.m_20206_() * 0.5, pos.f_82481_, 15, 0.4, 0.4, 0.4, 0.05);
        }

        private static void playDeathSound(LivingEntity target) {
            if (target.m_9236_().f_46443_) {
                return;
            }
            target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12556_, target.m_5720_(), 1.0f, 0.8f + target.m_9236_().f_46441_.m_188501_() * 0.4f);
        }

        public static void cleanup() {
            ACTIVE_EFFECTS.clear();
        }
    }

    private static class TargetTrackingData {
        final UUID targetId;
        int stuckTicks = 0;
        double lastDistance = -1.0;
        int noProgressTicks = 0;
        Vec3 lastPosition;
        boolean hasLineOfSight = true;

        TargetTrackingData(UUID targetId) {
            this.targetId = targetId;
        }

        boolean shouldAbandon() {
            return this.stuckTicks > 200 || this.noProgressTicks > 300;
        }

        void updateProgress(TheLastEndSwordWraithEntity wraith, LivingEntity target) {
            Vec3 currentPos = wraith.m_20182_();
            double currentDistance = wraith.m_20270_((Entity)target);
            if (this.lastPosition != null) {
                double moveDistance = currentPos.m_82554_(this.lastPosition);
                this.stuckTicks = moveDistance < 0.1 ? ++this.stuckTicks : 0;
            }
            if (this.lastDistance > 0.0) {
                double progress = this.lastDistance - currentDistance;
                this.noProgressTicks = progress < 0.5 ? ++this.noProgressTicks : 0;
            }
            this.hasLineOfSight = wraith.m_142582_((Entity)target);
            this.lastPosition = currentPos;
            this.lastDistance = currentDistance;
        }
    }

    private static class SwiftDashSkill {
        private static final int SKILL_DURATION = 60;
        private static final int DASH_START_TICK = 35;

        private SwiftDashSkill() {
        }

        public static void execute(TheLastEndSwordWraithEntity wraith, int tick) {
            LivingEntity target = wraith.m_5448_();
            if (tick >= 35 && target != null) {
                Vec3 wraithPos = wraith.m_20182_();
                Vec3 targetPos = target.m_20182_();
                Vec3 direction = targetPos.m_82546_(wraithPos).m_82541_();
                double dashSpeed = 1.5;
                wraith.m_20334_(direction.f_82479_ * dashSpeed, Math.max(0.2, direction.f_82480_ * dashSpeed), direction.f_82481_ * dashSpeed);
            }
            if (tick >= 60) {
                TheLastEndSwordWraithAI.endSkillAndStartNext(wraith);
            }
        }
    }

    private static class EnchantSkill {
        private static final int SKILL_DURATION = 45;
        private static final int ENCHANT_START_TICK = 25;
        private static final int ENCHANT_DURATION = 600;

        private EnchantSkill() {
        }

        public static void execute(TheLastEndSwordWraithEntity wraith, int tick) {
            if (tick == 25) {
                EnchantSkill.applyVoidEnchantment(wraith);
                EnchantSkill.playEnchantSound(wraith);
            }
            if (tick >= 25 && tick % 5 == 0) {
                EnchantSkill.spawnEnchantingParticles(wraith);
            }
            if (tick >= 45) {
                TheLastEndSwordWraithAI.endSkillAndStartNext(wraith);
            }
        }

        private static void playEnchantSound(TheLastEndSwordWraithEntity wraith) {
            if (wraith.m_9236_().f_46443_) {
                return;
            }
            wraith.m_9236_().m_6263_(null, wraith.m_20185_(), wraith.m_20186_(), wraith.m_20189_(), SoundEvents.f_11887_, wraith.m_5720_(), 1.0f, 1.0f);
        }

        private static void applyVoidEnchantment(TheLastEndSwordWraithEntity wraith) {
            if (wraith.m_9236_().f_46443_) {
                return;
            }
            int wraithLevel = wraith.getEndLevel();
            int enchantmentAmplifier = Math.max(0, wraithLevel - 1);
            MobEffectInstance voidEnchantment = new MobEffectInstance((MobEffect)TheLastSwordModMobEffects.VOID_ENCHANTMENT.get(), 600, enchantmentAmplifier, false, ((Boolean)TheLastSwordConfiguration.VOID_ENCHANTMENT_PARTICLE_EFFECTS.get()).booleanValue(), true);
            wraith.m_7292_(voidEnchantment);
        }

        private static void spawnEnchantingParticles(TheLastEndSwordWraithEntity wraith) {
            Level level;
            if (wraith.m_9236_().f_46443_ || !((level = wraith.m_9236_()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 wraithPos = wraith.m_20182_();
            double leftAngle = Math.toRadians(wraith.m_146908_() + 90.0f);
            double particleX = wraithPos.f_82479_ + Math.cos(leftAngle) * 1.0;
            double particleY = wraithPos.f_82480_ + 0.8;
            double particleZ = wraithPos.f_82481_ + Math.sin(leftAngle) * 1.0;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, particleX, particleY, particleZ, 20, 0.3, 0.3, 0.3, 0.02);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, particleX, particleY, particleZ, 10, 0.2, 0.2, 0.2, 0.05);
            int ringParticles = 8;
            double ringRadius = 1.5;
            double ringHeight = wraithPos.f_82480_ + 1.0;
            for (int i = 0; i < ringParticles; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)ringParticles + (double)wraith.f_19797_ * 0.1;
                double ringX = wraithPos.f_82479_ + Math.cos(angle) * ringRadius;
                double ringZ = wraithPos.f_82481_ + Math.sin(angle) * ringRadius;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, ringX, ringHeight, ringZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, wraithPos.f_82479_, wraithPos.f_82480_ + 1.0, wraithPos.f_82481_, 5, 0.1, 0.1, 0.1, 0.01);
        }
    }

    private static class DoubleStrikeSkill {
        private static final int SKILL_DURATION = 40;
        private static final int FIRST_STRIKE_TICK = 10;
        private static final int SECOND_STRIKE_TICK = 20;

        private DoubleStrikeSkill() {
        }

        public static void execute(TheLastEndSwordWraithEntity wraith, int tick) {
            if (tick == 10) {
                DoubleStrikeSkill.executeFirstStrike(wraith);
            }
            if (tick == 20) {
                DoubleStrikeSkill.executeSecondStrike(wraith);
            }
            if (tick >= 40) {
                TheLastEndSwordWraithAI.endSkillAndStartNext(wraith);
            }
        }

        private static void playSweepSound(TheLastEndSwordWraithEntity wraith) {
            if (wraith.m_9236_().f_46443_) {
                return;
            }
            wraith.m_9236_().m_6263_(null, wraith.m_20185_(), wraith.m_20186_(), wraith.m_20189_(), SoundEvents.f_12317_, wraith.m_5720_(), 1.0f, 1.0f);
        }

        private static void spawnSweepParticles(TheLastEndSwordWraithEntity wraith, boolean isFirstStrike) {
            Vec3 endOffset;
            Vec3 startOffset;
            Level level;
            if (wraith.m_9236_().f_46443_ || !((level = wraith.m_9236_()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            double attackRange = TheLastEndSwordWraithAI.getCombatDistance(wraith);
            float yaw = wraith.m_146908_();
            double yawRad = Math.toRadians(yaw);
            Vec3 forward = new Vec3(-Math.sin(yawRad), 0.0, Math.cos(yawRad)).m_82541_();
            Vec3 right = new Vec3(forward.f_82481_, 0.0, -forward.f_82479_).m_82541_();
            Vec3 up = new Vec3(0.0, 1.0, 0.0);
            if (isFirstStrike) {
                startOffset = forward.m_82546_(right).m_82549_(up).m_82490_(attackRange);
                endOffset = forward.m_82549_(right).m_82546_(up).m_82490_(attackRange);
            } else {
                startOffset = forward.m_82549_(right).m_82549_(up).m_82490_(attackRange);
                endOffset = forward.m_82546_(right).m_82546_(up).m_82490_(attackRange);
            }
            int steps = 12;
            for (int i = 0; i <= steps; ++i) {
                double t = (double)i / (double)steps;
                double px = wraith.m_20185_() + DoubleStrikeSkill.lerp(t, startOffset.f_82479_, endOffset.f_82479_);
                double py = wraith.m_20186_() + DoubleStrikeSkill.lerp(t, startOffset.f_82480_, endOffset.f_82480_);
                double pz = wraith.m_20189_() + DoubleStrikeSkill.lerp(t, startOffset.f_82481_, endOffset.f_82481_);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                if (isFirstStrike) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, px, py, pz, 10, 0.1, 0.1, 0.1, 0.05);
                    continue;
                }
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, px, py, pz, 12, 0.4, 0.4, 0.4, 0.05);
            }
        }

        private static double lerp(double t, double start, double end) {
            return start + t * (end - start);
        }

        private static void executeFirstStrike(TheLastEndSwordWraithEntity wraith) {
            double attackRange = TheLastEndSwordWraithAI.getCombatDistance(wraith);
            DoubleStrikeSkill.playSweepSound(wraith);
            List<LivingEntity> targets = EntityUtil.getTargetsInHemisphere((LivingEntity)wraith, attackRange, 120.0);
            for (LivingEntity livingTarget : targets) {
                livingTarget.f_19802_ = 0;
                float damage = (float)wraith.m_21133_(Attributes.f_22281_);
                livingTarget.m_6469_(wraith.m_269291_().m_269333_((LivingEntity)wraith), damage);
            }
            DoubleStrikeSkill.spawnSweepParticles(wraith, true);
        }

        private static void executeSecondStrike(TheLastEndSwordWraithEntity wraith) {
            double attackRange = TheLastEndSwordWraithAI.getCombatDistance(wraith);
            DoubleStrikeSkill.playSweepSound(wraith);
            List<LivingEntity> targets = EntityUtil.getTargetsInHemisphere((LivingEntity)wraith, attackRange, 120.0);
            for (LivingEntity livingTarget : targets) {
                livingTarget.f_19802_ = 0;
                float damage = (float)wraith.m_21133_(Attributes.f_22281_);
                DamageSource magicDamage = new DamageSource((Holder)wraith.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268515_), (Entity)wraith, (Entity)wraith);
                livingTarget.m_6469_(magicDamage, damage);
            }
            DoubleStrikeSkill.spawnSweepParticles(wraith, false);
        }
    }

    private static class CrossSlashSkill {
        private static final int SKILL_DURATION = 80;
        private static final int FIRST_SLASH_TICK = 55;
        private static final int SECOND_SLASH_TICK = 75;

        private CrossSlashSkill() {
        }

        public static void execute(TheLastEndSwordWraithEntity wraith, int tick) {
            if (tick == 15) {
                CrossSlashSkill.playAnvilSound(wraith);
            }
            if (tick == 55) {
                CrossSlashSkill.executeSlash(wraith);
            }
            if (tick == 75) {
                CrossSlashSkill.executeSlash(wraith);
            }
            if (tick >= 80) {
                TheLastEndSwordWraithAI.endSkillAndStartNext(wraith);
            }
        }

        private static void executeSlash(TheLastEndSwordWraithEntity wraith) {
            LivingEntity target = wraith.m_5448_();
            if (target == null || !target.m_6084_()) {
                return;
            }
            double attackRange = TheLastEndSwordWraithAI.getCombatDistance(wraith) + 2.0;
            double targetX = target.m_20185_();
            double targetY = target.m_20186_();
            double targetZ = target.m_20189_();
            CrossSlashSkill.playTeleportSound(wraith);
            CrossSlashSkill.spawnTeleportParticles(wraith, targetX, targetY, targetZ);
            UnsafeUtil.UnsafeTeleport((Entity)wraith, targetX, targetY, targetZ);
            target.f_19802_ = 0;
            float damage = (float)wraith.m_21133_(Attributes.f_22281_) * 1.5f;
            AbsoluteDestructionDamageSource.applyAbsoluteDestructionIntelligently(target, (Entity)wraith, damage);
            List<LivingEntity> nearbyTargets = EntityUtil.getTargetsInHemisphere((LivingEntity)wraith, attackRange, 120.0);
            for (LivingEntity nearbyTarget : nearbyTargets) {
                if (nearbyTarget.equals((Object)target)) continue;
                nearbyTarget.f_19802_ = 0;
                AbsoluteDestructionDamageSource.applyAbsoluteDestructionIntelligently(nearbyTarget, (Entity)wraith, damage);
            }
        }

        private static void playAnvilSound(TheLastEndSwordWraithEntity wraith) {
            if (wraith.m_9236_().f_46443_) {
                return;
            }
            wraith.m_9236_().m_6263_(null, wraith.m_20185_(), wraith.m_20186_(), wraith.m_20189_(), SoundEvents.f_11671_, wraith.m_5720_(), 1.0f, 1.0f);
        }

        private static void playTeleportSound(TheLastEndSwordWraithEntity wraith) {
            if (wraith.m_9236_().f_46443_) {
                return;
            }
            wraith.m_9236_().m_6263_(null, wraith.m_20185_(), wraith.m_20186_(), wraith.m_20189_(), SoundEvents.f_11852_, wraith.m_5720_(), 1.0f, 1.0f);
        }

        private static void spawnTeleportParticles(TheLastEndSwordWraithEntity wraith, double x, double y, double z) {
            Level level;
            if (wraith.m_9236_().f_46443_ || !((level = wraith.m_9236_()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 oldPos = wraith.m_20182_();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, oldPos.f_82479_, oldPos.f_82480_ + (double)wraith.m_20206_() * 0.5, oldPos.f_82481_, 30, 0.5, 0.5, 0.5, 0.1);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y + (double)wraith.m_20206_() * 0.5, z, 30, 0.5, 0.5, 0.5, 0.1);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123789_, x, y + (double)wraith.m_20206_() * 0.5, z, 15, 0.3, 0.3, 0.3, 0.05);
        }
    }

    private static class EndOfAllThingsSkill {
        private static final int SKILL_DURATION = 190;
        private static final int PARTICLE_START_TICK = 10;
        private static final int PARTICLE_STABLE_END_TICK = 150;
        private static final int PARTICLE_SHRINK_END_TICK = 170;
        private static final int ACTIVATE_ALL_THINGS_END_TICK = 170;

        private EndOfAllThingsSkill() {
        }

        public static void execute(TheLastEndSwordWraithEntity wraith, int tick) {
            if (tick >= 75 && tick <= 150) {
                TheLastEndSwordWraithAI.syncEntityPositionToLocator(wraith, "locator");
            }
            if (tick >= 10 && tick <= 170) {
                EndOfAllThingsSkill.spawnAllThingsEndParticles(wraith, tick);
            }
            if (tick == 170) {
                wraith.setAllThingsEndState(true);
                AllThingsEndActiveEffect.start(wraith);
            }
            if (tick >= 190) {
                TheLastEndSwordWraithAI.endSkillAndStartNext(wraith);
            }
        }

        private static void spawnAllThingsEndParticles(TheLastEndSwordWraithEntity wraith, int tick) {
            Level level;
            if (wraith.m_9236_().f_46443_ || !((level = wraith.m_9236_()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 centerPos = TheLastEndSwordWraithAI.getLocatorPosition(wraith, "locator");
            if (centerPos == null) {
                centerPos = wraith.m_20182_().m_82520_(0.0, (double)wraith.m_20206_() * 0.5, 0.0);
            }
            double baseRadius = 2.0;
            if (tick <= 150) {
                EndOfAllThingsSkill.spawnHorizontalCircle(serverLevel, centerPos, baseRadius, (ParticleOptions)ParticleTypes.f_123810_);
                EndOfAllThingsSkill.spawnVerticalCircle(serverLevel, centerPos, baseRadius, (ParticleOptions)ParticleTypes.f_123765_);
            } else {
                double shrinkProgress = (double)(tick - 150) / 20.0;
                EndOfAllThingsSkill.spawnShrinkingCircles(serverLevel, centerPos, baseRadius, shrinkProgress);
            }
            if (tick > 150) {
                if (tick % 2 == 0) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123799_, centerPos.f_82479_, centerPos.f_82480_, centerPos.f_82481_, 8, 0.2, 0.2, 0.2, 0.05);
                }
            } else if (tick % 5 == 0) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123799_, centerPos.f_82479_, centerPos.f_82480_, centerPos.f_82481_, 5, 0.1, 0.1, 0.1, 0.02);
            }
        }

        private static void spawnHorizontalCircle(ServerLevel level, Vec3 center, double radius, ParticleOptions particle) {
            int particleCount = Math.max(8, (int)(radius * 16.0));
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)particleCount;
                double x = center.f_82479_ + Math.cos(angle) * radius;
                double z = center.f_82481_ + Math.sin(angle) * radius;
                double y = center.f_82480_;
                level.m_8767_(particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        private static void spawnVerticalCircle(ServerLevel level, Vec3 center, double radius, ParticleOptions particle) {
            int particleCount = Math.max(8, (int)(radius * 16.0));
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)particleCount;
                double x = center.f_82479_ + Math.cos(angle) * radius;
                double y = center.f_82480_ + Math.sin(angle) * radius;
                double z = center.f_82481_;
                level.m_8767_(particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        private static void spawnShrinkingCircles(ServerLevel level, Vec3 center, double originalRadius, double shrinkProgress) {
            double currentZ;
            double currentY;
            double currentX;
            double originalX;
            double angle;
            int i;
            int particleCount = Math.max(8, (int)(originalRadius * 16.0));
            for (i = 0; i < particleCount; ++i) {
                angle = Math.PI * 2 * (double)i / (double)particleCount;
                originalX = center.f_82479_ + Math.cos(angle) * originalRadius;
                double originalZ = center.f_82481_ + Math.sin(angle) * originalRadius;
                double originalY = center.f_82480_;
                currentX = originalX + (center.f_82479_ - originalX) * shrinkProgress;
                currentY = originalY + (center.f_82480_ - originalY) * shrinkProgress;
                currentZ = originalZ + (center.f_82481_ - originalZ) * shrinkProgress;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123810_, currentX, currentY, currentZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < particleCount; ++i) {
                angle = Math.PI * 2 * (double)i / (double)particleCount;
                originalX = center.f_82479_ + Math.cos(angle) * originalRadius;
                double originalY = center.f_82480_ + Math.sin(angle) * originalRadius;
                double originalZ = center.f_82481_;
                currentX = originalX + (center.f_82479_ - originalX) * shrinkProgress;
                currentY = originalY + (center.f_82480_ - originalY) * shrinkProgress;
                currentZ = originalZ + (center.f_82481_ - originalZ) * shrinkProgress;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123765_, currentX, currentY, currentZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

