/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.entity.music;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.entity.LostWraithEntity;
import net.the_last_sword.entity.TheLastEndSwordWraithEntity;
import net.the_last_sword.init.TheLastSwordModSounds;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CombatMusicHandler {
    private static boolean isPlaying = false;
    private static SoundInstance currentMusic;
    private static String currentMusicType;
    private static int musicCheckCounter;
    private static final int MUSIC_CHECK_INTERVAL = 20;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null || mc.m_91104_()) {
            return;
        }
        if (!((Boolean)TheLastSwordConfiguration.ENABLE_BATTLE_MUSIC.get()).booleanValue()) {
            if (isPlaying) {
                CombatMusicHandler.stopBattleMusic();
            }
            return;
        }
        if (++musicCheckCounter < 20) {
            return;
        }
        musicCheckCounter = 0;
        ClientLevel level = (ClientLevel)player.m_9236_();
        AABB searchArea = new AABB(player.m_20185_() - 64.0, player.m_20186_() - 32.0, player.m_20189_() - 64.0, player.m_20185_() + 64.0, player.m_20186_() + 32.0, player.m_20189_() + 64.0);
        List wraithEntities = level.m_45976_(TheLastEndSwordWraithEntity.class, searchArea);
        List lostWraithEntities = level.m_45976_(LostWraithEntity.class, searchArea);
        lostWraithEntities.removeIf(entity -> !entity.getIsSpawned());
        String requiredMusicType = "";
        if (!wraithEntities.isEmpty()) {
            requiredMusicType = "wraith";
        } else if (!lostWraithEntities.isEmpty()) {
            requiredMusicType = "lost_wraith";
        }
        if (requiredMusicType.isEmpty()) {
            if (isPlaying) {
                CombatMusicHandler.stopBattleMusic();
            }
        } else if (!isPlaying || !currentMusicType.equals(requiredMusicType)) {
            if (isPlaying) {
                CombatMusicHandler.stopBattleMusic();
            }
            CombatMusicHandler.playBattleMusic(requiredMusicType);
        }
    }

    public static void playBattleMusic(String musicType) {
        SoundEvent musicEvent;
        if (isPlaying) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null) {
            return;
        }
        switch (musicType) {
            case "wraith": {
                musicEvent = (SoundEvent)TheLastSwordModSounds.THE_LAST_END_SWORD_WRAITH.get();
                break;
            }
            case "lost_wraith": {
                musicEvent = (SoundEvent)TheLastSwordModSounds.LOST_WRAITH.get();
                break;
            }
            default: {
                return;
            }
        }
        currentMusic = new SimpleSoundInstance(musicEvent.m_11660_(), SoundSource.MUSIC, 1.0f, 1.0f, SoundInstance.m_235150_(), true, 0, SoundInstance.Attenuation.NONE, player.m_20185_(), player.m_20186_(), player.m_20189_(), false);
        mc.m_91106_().m_120367_(currentMusic);
        isPlaying = true;
        currentMusicType = musicType;
    }

    public static void playBattleMusic() {
        CombatMusicHandler.playBattleMusic("wraith");
    }

    private static void stopBattleMusic() {
        Minecraft mc = Minecraft.m_91087_();
        if (currentMusic != null) {
            mc.m_91106_().m_120399_(currentMusic);
            currentMusic = null;
        }
        isPlaying = false;
        currentMusicType = "";
    }

    static {
        currentMusicType = "";
        musicCheckCounter = 0;
    }
}

