/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.network.ClearPreviewPacket;
import net.the_last_sword.network.NetworkHandler;
import net.the_last_sword.network.PreviewBlocksPacket;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BlockEventHandler {
    private static final Map<UUID, MiningPreview> playerPreviews = new HashMap<UUID, MiningPreview>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            BlockEventHandler.cleanupExpiredPreviews();
        }
    }

    public static void performMining(Player player, Level world) {
        if (world.f_46443_) {
            return;
        }
        UUID playerId = player.m_20148_();
        MiningPreview existingPreview = playerPreviews.get(playerId);
        if (existingPreview != null && !existingPreview.isExpired()) {
            BlockEventHandler.executeMining(world, player, existingPreview);
            playerPreviews.remove(playerId);
            BlockEventHandler.clearClientPreview(player);
        } else {
            BlockEventHandler.createPreview(world, player);
        }
    }

    private static void createPreview(Level world, Player player) {
        BlockHitResult hitResult = (BlockHitResult)player.m_19907_(20.0, 0.0f, false);
        BlockPos targetPos = hitResult.m_82425_();
        BlockState targetState = world.m_8055_(targetPos);
        if (targetState.m_60800_((BlockGetter)world, targetPos) < 0.0f) {
            return;
        }
        HashSet<BlockPos> blocksToDestroy = new HashSet<BlockPos>();
        int radius = (Integer)TheLastSwordConfiguration.MINING_RADIUS.get();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos currentPos = targetPos.m_7918_(x, y, z);
                    BlockState currentState = world.m_8055_(currentPos);
                    if (currentState.m_60795_()) continue;
                    if (!((Boolean)TheLastSwordConfiguration.SUPER_DESTROY.get()).booleanValue()) {
                        if (!(currentState.m_60800_((BlockGetter)world, currentPos) >= 0.0f)) continue;
                        blocksToDestroy.add(currentPos);
                        continue;
                    }
                    blocksToDestroy.add(currentPos);
                }
            }
        }
        MiningPreview preview = new MiningPreview(targetPos, blocksToDestroy);
        playerPreviews.put(player.m_20148_(), preview);
        BlockEventHandler.sendPreviewToClient(player, blocksToDestroy);
    }

    public static void cleanupExpiredPreviews() {
        playerPreviews.entrySet().removeIf(entry -> ((MiningPreview)entry.getValue()).isExpired());
    }

    private static void executeMining(Level world, Player player, MiningPreview preview) {
        for (BlockPos pos : preview.blocksToDestroy) {
            BlockState state = world.m_8055_(pos);
            if (!((Boolean)TheLastSwordConfiguration.SUPER_DESTROY.get()).booleanValue()) {
                if (!(state.m_60800_((BlockGetter)world, pos) >= 0.0f)) continue;
                world.m_46953_(pos, true, (Entity)player);
                continue;
            }
            BlockEventHandler.forceDropBlock(world, pos, player);
        }
    }

    private static void forceDropBlock(Level world, BlockPos pos, Player player) {
        List drops;
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block == Blocks.f_50016_ || block.m_49966_().m_60795_()) {
            return;
        }
        ItemStack dropStack = new ItemStack((ItemLike)block);
        if ((block instanceof DropExperienceBlock || block.m_60589_() != null) && !(drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)player.m_21205_())).isEmpty()) {
            dropStack = (ItemStack)drops.get(0);
        }
        if (!dropStack.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, dropStack);
            world.m_7967_((Entity)itemEntity);
        }
        world.m_7471_(pos, false);
    }

    private static void sendPreviewToClient(Player player, Set<BlockPos> blocks) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.sendToPlayer(new PreviewBlocksPacket(blocks), serverPlayer);
        }
    }

    private static void clearClientPreview(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.sendToPlayer(new ClearPreviewPacket(), serverPlayer);
        }
    }

    public static boolean hasActivePreview(Player player) {
        UUID playerId = player.m_20148_();
        MiningPreview preview = playerPreviews.get(playerId);
        return preview != null && !preview.isExpired();
    }

    public static boolean cancelPreview(Player player) {
        UUID playerId = player.m_20148_();
        MiningPreview preview = playerPreviews.remove(playerId);
        if (preview != null && !preview.isExpired()) {
            BlockEventHandler.clearClientPreview(player);
            return true;
        }
        return false;
    }

    public static class MiningPreview {
        public final BlockPos centerPos;
        public final Set<BlockPos> blocksToDestroy;
        public final long timestamp;

        public MiningPreview(BlockPos centerPos, Set<BlockPos> blocksToDestroy) {
            this.centerPos = centerPos;
            this.blocksToDestroy = blocksToDestroy;
            this.timestamp = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 10000L;
        }
    }
}

