/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.event;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class BlockPreviewRenderer {
    private static final Set<BlockPos> previewBlocks = new HashSet<BlockPos>();
    private static long lastUpdateTime = 0L;

    public static void setPreviewBlocks(Set<BlockPos> blocks) {
        previewBlocks.clear();
        previewBlocks.addAll(blocks);
        lastUpdateTime = System.currentTimeMillis();
    }

    public static void clearPreview() {
        previewBlocks.clear();
    }

    public static boolean hasActivePreview() {
        if (previewBlocks.isEmpty()) {
            return false;
        }
        if (System.currentTimeMillis() - lastUpdateTime > 10000L) {
            BlockPreviewRenderer.clearPreview();
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (previewBlocks.isEmpty()) {
            return;
        }
        if (System.currentTimeMillis() - lastUpdateTime > 10000L) {
            BlockPreviewRenderer.clearPreview();
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        BlockPreviewRenderer.renderPreviewBlocks(poseStack, event.getCamera());
    }

    private static void renderPreviewBlocks(PoseStack poseStack, Camera camera) {
        Vec3 cameraPos = camera.m_90583_();
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        BufferBuilder bufferBuilder = new BufferBuilder(256);
        MultiBufferSource.BufferSource immediateBufferSource = MultiBufferSource.m_109898_((BufferBuilder)bufferBuilder);
        VertexConsumer buffer = immediateBufferSource.m_6299_(RenderType.m_110504_());
        float time = (float)(System.currentTimeMillis() % 2000L) / 2000.0f;
        float alpha = 0.5f + 0.3f * (float)Math.sin((double)time * Math.PI * 2.0);
        float red = 0.0f;
        float green = 1.0f;
        float blue = 0.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        for (BlockPos pos : previewBlocks) {
            BlockPreviewRenderer.renderBlockOutline(buffer, matrix, pos, red, green, blue, alpha);
        }
        immediateBufferSource.m_109911_();
        poseStack.m_85849_();
    }

    private static void renderBlockOutline(VertexConsumer buffer, Matrix4f matrix, BlockPos pos, float red, float green, float blue, float alpha) {
        float x1 = pos.m_123341_();
        float y1 = pos.m_123342_();
        float z1 = pos.m_123343_();
        float x2 = x1 + 1.0f;
        float y2 = y1 + 1.0f;
        float z2 = z1 + 1.0f;
        BlockPreviewRenderer.addLine(buffer, matrix, x1, y1, z1, x2, y1, z1, red, green, blue, alpha);
        BlockPreviewRenderer.addLine(buffer, matrix, x2, y1, z1, x2, y1, z2, red, green, blue, alpha);
        BlockPreviewRenderer.addLine(buffer, matrix, x2, y1, z2, x1, y1, z2, red, green, blue, alpha);
        BlockPreviewRenderer.addLine(buffer, matrix, x1, y1, z2, x1, y1, z1, red, green, blue, alpha);
        BlockPreviewRenderer.addLine(buffer, matrix, x1, y2, z1, x2, y2, z1, red, green, blue, alpha);
        BlockPreviewRenderer.addLine(buffer, matrix, x2, y2, z1, x2, y2, z2, red, green, blue, alpha);
        BlockPreviewRenderer.addLine(buffer, matrix, x2, y2, z2, x1, y2, z2, red, green, blue, alpha);
        BlockPreviewRenderer.addLine(buffer, matrix, x1, y2, z2, x1, y2, z1, red, green, blue, alpha);
        BlockPreviewRenderer.addLine(buffer, matrix, x1, y1, z1, x1, y2, z1, red, green, blue, alpha);
        BlockPreviewRenderer.addLine(buffer, matrix, x2, y1, z1, x2, y2, z1, red, green, blue, alpha);
        BlockPreviewRenderer.addLine(buffer, matrix, x2, y1, z2, x2, y2, z2, red, green, blue, alpha);
        BlockPreviewRenderer.addLine(buffer, matrix, x1, y1, z2, x1, y2, z2, red, green, blue, alpha);
    }

    private static void addLine(VertexConsumer buffer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha) {
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }
}

