/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.event;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.TheLastSwordMod;
import net.the_last_sword.recipe.ConfigDragonCrystalSmithingManager;
import net.the_last_sword.util.TheLastSwordLogger;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ConfigSyncHandler {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (!event.getEntity().m_9236_().m_5776_() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TheLastSwordMod.queueServerWork(1, () -> {
                try {
                    TheLastSwordMod.syncConfigToPlayer(serverPlayer);
                    ConfigDragonCrystalSmithingManager.syncRecipesToPlayer(serverPlayer);
                    TheLastSwordLogger.info("Configuration and recipes automatically synced to joining player: {}", serverPlayer.m_7755_().getString());
                }
                catch (Exception e) {
                    TheLastSwordLogger.error("Failed to sync config and recipes to joining player {}: {}", serverPlayer.m_7755_().getString(), e.getMessage());
                }
            });
        }
    }
}

