/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.event;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.the_last_sword.attack.AttackEffectManager;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.item.TheLastEndArmorItems;
import net.the_last_sword.item.TheLastEndSwordItems;
import net.the_last_sword.util.DynamicHealthDetector;
import net.the_last_sword.util.EntityUtil;
import net.the_last_sword.util.TheLastSwordLogger;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ServerEventHandler {
    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        ItemEntity itemEntity;
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && ((itemEntity = (ItemEntity)entity).m_32055_().m_41720_() instanceof TheLastEndSwordItems || itemEntity.m_32055_().m_41720_() instanceof TheLastEndArmorItems)) {
            itemEntity.m_146915_(true);
            itemEntity.m_32064_();
        }
    }

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        DynamicHealthDetector.clearAllCaches();
        EntityUtil.clearAllEntityCaches();
        TheLastSwordLogger.info("Dynamic health detection caches and entity caches cleared for new session");
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        if (event.getLevel() instanceof ServerLevel) {
            DynamicHealthDetector.clearWorldCaches();
            TheLastSwordLogger.info("Dynamic health detection world caches cleared for world load");
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel() instanceof ServerLevel) {
            DynamicHealthDetector.clearWorldCaches();
            TheLastSwordLogger.info("Dynamic health detection world caches cleared for world unload");
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        try {
            Player player = event.getEntity();
            ServerEventHandler.clearAttackSystemOnRespawn(player);
            ServerEventHandler.resetDefenseSystemOnRespawn(player);
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Error handling player respawn event", e);
        }
    }

    private static void clearAttackSystemOnRespawn(Player player) {
        try {
            if (AttackEffectManager.isHealNegated((Entity)player)) {
                AttackEffectManager.clearHealNegation((Entity)player);
            }
            if (AttackEffectManager.isTracked((Entity)player)) {
                AttackEffectManager.clearAll((Entity)player);
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Error clearing attack system for respawned player", e);
        }
    }

    private static void resetDefenseSystemOnRespawn(Player player) {
        try {
            int defenseLevel = DefenceManager.getLevel((LivingEntity)player);
            float realHealth = DefenceManager.getStoredHealth((LivingEntity)player);
            if (defenseLevel >= 1) {
                if (realHealth < 0.0f || Float.isNaN(realHealth) || Float.isInfinite(realHealth)) {
                    float maxHealth = player.m_21233_();
                    DefenceManager.modifyHealth(player.m_20148_(), maxHealth);
                } else {
                    float maxHealth = player.m_21233_();
                    DefenceManager.modifyHealth(player.m_20148_(), maxHealth);
                }
            } else if (DefenceManager.isTracked((LivingEntity)player)) {
                DefenceManager.clear((LivingEntity)player);
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Error resetting defense system for respawned player", e);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        try {
            ServerEventHandler.clearPlayerSystemsOnDeath(player);
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Error handling player death event", e);
        }
    }

    private static void clearPlayerSystemsOnDeath(Player player) {
        try {
            if (AttackEffectManager.isTracked((Entity)player)) {
                AttackEffectManager.clearAll((Entity)player);
            }
            if (DefenceManager.isTracked((LivingEntity)player)) {
                DefenceManager.clear((LivingEntity)player);
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Error clearing player systems on death", e);
        }
    }

    private ServerEventHandler() {
    }
}

