/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.capability.DefaultLevel;
import net.the_last_sword.capability.ForgeEnergyProvider;
import net.the_last_sword.capability.ILevel;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.client.renderer.DragonArmorArmorRenderer;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.init.TheLastSwordModItems;
import net.the_last_sword.init.TheLastSwordModMobEffects;
import net.the_last_sword.item.TheLastEndArmorItems;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class DragonArmor
extends TheLastEndArmorItems
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public DragonArmor(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 0;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{8, 12, 12, 8})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 30;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.beacon.activate"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_151265_();
            }

            public String m_6082_() {
                return "dragon_armor";
            }

            public float m_6651_() {
                return 10.0f;
            }

            public float m_6649_() {
                return 5.0f;
            }
        }, type, properties.m_41486_().m_41497_(Rarity.EPIC));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new DragonArmorArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    @Override
    protected int[] getBaseArmorValues() {
        return new int[]{8, 12, 12, 8};
    }

    @Override
    protected double getBaseToughness() {
        return 10.0;
    }

    @Override
    protected String getArmorName() {
        return "DragonArmor";
    }

    @Override
    protected double getArmorLevelIncrease() {
        return TheLastSwordConfiguration.getDragonArmorLevelArmorIncreaseSafely();
    }

    @Override
    protected double getToughnessLevelIncrease() {
        return TheLastSwordConfiguration.getDragonArmorLevelToughnessIncreaseSafely();
    }

    @Override
    protected double getHealthLevelIncrease() {
        return TheLastSwordConfiguration.getDragonArmorLevelHealthIncreaseSafely();
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        return new ICapabilityProvider(){
            private final ForgeEnergyProvider energyProvider;
            private final LazyOptional<ILevel> levelCap;
            {
                this.energyProvider = new ForgeEnergyProvider(stack, 0x100000);
                this.levelCap = LazyOptional.of(() -> new DefaultLevel(6));
            }

            public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                if (cap == ForgeCapabilities.ENERGY) {
                    return this.energyProvider.getCapability(cap, side);
                }
                if (cap == ItemCapability.LEVEL_CAPABILITY) {
                    return this.levelCap.cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(energy -> {
            int maxEnergy = energy.getMaxEnergyStored();
            int currentEnergy = energy.getEnergyStored();
            if (maxEnergy == 0) {
                return 0;
            }
            return Math.round(13.0f * (float)currentEnergy / (float)maxEnergy);
        }).orElse(0);
    }

    public int m_142159_(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(energy -> {
            int maxEnergy = energy.getMaxEnergyStored();
            int currentEnergy = energy.getEnergyStored();
            if (maxEnergy == 0) {
                return 9109759;
            }
            float ratio = (float)currentEnergy / (float)maxEnergy;
            if (ratio < 0.25f) {
                return 0xFF0000;
            }
            if (ratio < 0.5f) {
                return 16747520;
            }
            if (ratio < 0.75f) {
                return 10170623;
            }
            return 0xBF00FF;
        }).orElse(9109759);
    }

    @Override
    protected void appendSpecificTooltip(ItemStack itemstack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        itemstack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.energy").m_130946_(": \u00a7a" + energy.getEnergyStored() + " \u00a7r/ " + energy.getMaxEnergyStored() + " FE")));
        EquipmentSlot slot = this.m_40402_();
        switch (slot) {
            case HEAD: {
                list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.dragon_armor_helmet"));
                break;
            }
            case CHEST: {
                list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.dragon_armor_chestplate"));
                break;
            }
            case LEGS: {
                list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.dragon_armor_leggings"));
                break;
            }
            case FEET: {
                list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.dragon_armor_boots"));
            }
        }
        list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.dragon_armor_skill"));
        list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.dragon_armor"));
    }

    private PlayState predicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            Entity entity = (Entity)event.getData(DataTickets.ENTITY);
            if (entity instanceof ArmorStand) {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
                return PlayState.CONTINUE;
            }
            ObjectOpenHashSet wornArmor = new ObjectOpenHashSet();
            for (ItemStack stack : entity.m_6168_()) {
                if (stack.m_41619_()) {
                    return PlayState.STOP;
                }
                wornArmor.add(stack.m_41720_());
            }
            boolean isWearingAll = wornArmor.containsAll((Collection<?>)ObjectArrayList.of((Object[])new Item[]{(Item)TheLastSwordModItems.DRAGON_ARMOR_BOOTS.get(), (Item)TheLastSwordModItems.DRAGON_ARMOR_LEGGINGS.get(), (Item)TheLastSwordModItems.DRAGON_ARMOR_CHESTPLATE.get(), (Item)TheLastSwordModItems.DRAGON_ARMOR_HELMET.get()}));
            if (!isWearingAll) {
                return PlayState.STOP;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                boolean isDragonArmorFlying = false;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
                    boolean wearingDragonChestplate = !chestplate.m_41619_() && chestplate.m_41720_() instanceof Chestplate;
                    boolean bl = isDragonArmorFlying = wearingDragonChestplate && player.m_150110_().f_35935_;
                }
                if (isDragonArmorFlying) {
                    event.getController().setAnimation(RawAnimation.begin().thenLoop("fly"));
                } else {
                    event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
                }
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            Entity entity;
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
            if ((entity = (Entity)event.getData(DataTickets.ENTITY)) instanceof ArmorStand) {
                return PlayState.CONTINUE;
            }
            ObjectOpenHashSet wornArmor = new ObjectOpenHashSet();
            for (ItemStack stack : entity.m_6168_()) {
                if (stack.m_41619_()) {
                    return PlayState.STOP;
                }
                wornArmor.add(stack.m_41720_());
            }
            boolean isWearingAll = wornArmor.containsAll((Collection<?>)ObjectArrayList.of((Object[])new Item[]{(Item)TheLastSwordModItems.DRAGON_ARMOR_BOOTS.get(), (Item)TheLastSwordModItems.DRAGON_ARMOR_LEGGINGS.get(), (Item)TheLastSwordModItems.DRAGON_ARMOR_CHESTPLATE.get(), (Item)TheLastSwordModItems.DRAGON_ARMOR_HELMET.get()}));
            return isWearingAll ? PlayState.CONTINUE : PlayState.STOP;
        }
        if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedureController", 5, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static class Chestplate
    extends DragonArmor {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41486_().m_41497_(Rarity.EPIC));
        }

        @Override
        public EquipmentSlot m_40402_() {
            return EquipmentSlot.CHEST;
        }
    }

    @Mod.EventBusSubscriber(modid="the_last_sword")
    public static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
            if (ev.phase != TickEvent.Phase.END || ev.player.m_9236_().m_5776_()) {
                return;
            }
            Player p = ev.player;
            EventHandler.applyDragonArmorEffects(p);
            EventHandler.handleFlying(p);
            EventHandler.handleFullSetEffects(p);
        }

        private static void handleFullSetEffects(Player p) {
            boolean wearingFullSet = true;
            int fullSetWithEnergy = 0;
            for (EquipmentSlot s : EquipmentSlot.values()) {
                if (s.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack st = p.m_6844_(s);
                if (st.m_41619_() || !(st.m_41720_() instanceof DragonArmor)) {
                    wearingFullSet = false;
                    break;
                }
                boolean hasEnergy = st.getCapability(ForgeCapabilities.ENERGY).map(energy -> energy.getEnergyStored() > 0).orElse(false);
                if (hasEnergy) {
                    ++fullSetWithEnergy;
                }
                st.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> energy.extractEnergy(10, false));
            }
            if (wearingFullSet && fullSetWithEnergy == 4) {
                p.m_7292_(new MobEffectInstance(MobEffects.f_19618_, 240, 4, false, false));
                p.m_146917_(0);
                p.m_20095_();
            }
            if (wearingFullSet && fullSetWithEnergy == 4 && p.m_150110_().f_35935_) {
                p.m_7292_(new MobEffectInstance((MobEffect)TheLastSwordModMobEffects.PHASING.get(), 240, 0, false, false));
                ItemStack chestplate = p.m_6844_(EquipmentSlot.CHEST);
                chestplate.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> energy.extractEnergy(10, false));
            }
        }

        @SubscribeEvent
        public static void onDragonArmorHurt(LivingHurtEvent event) {
            boolean isExplosion;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player p = (Player)livingEntity;
            boolean wearingFullSet = true;
            for (EquipmentSlot s : EquipmentSlot.values()) {
                ItemStack st;
                if (s.m_20743_() != EquipmentSlot.Type.ARMOR || !(st = p.m_6844_(s)).m_41619_() && st.m_41720_() instanceof DragonArmor) continue;
                wearingFullSet = false;
                break;
            }
            if (!wearingFullSet) {
                return;
            }
            DamageSource source = event.getSource();
            boolean isNonPlayerAttack = source.m_7639_() != null && !(source.m_7639_() instanceof Player);
            boolean bl = isExplosion = source.m_276093_(DamageTypes.f_268565_) || source.m_276093_(DamageTypes.f_268448_) || source.m_276093_(DamageTypes.f_268428_) || source.m_276093_(DamageTypes.f_268650_);
            if (isNonPlayerAttack || isExplosion) {
                event.setAmount(event.getAmount() * 0.1f);
            }
        }

        private static void handleFlying(Player p) {
            boolean wearingDragonChestplate;
            ItemStack chestplate = p.m_6844_(EquipmentSlot.CHEST);
            boolean bl = wearingDragonChestplate = !chestplate.m_41619_() && chestplate.m_41720_() instanceof Chestplate;
            if (wearingDragonChestplate && !p.m_7500_() && !p.m_5833_()) {
                if (!p.m_150110_().f_35936_) {
                    p.m_150110_().f_35936_ = true;
                    p.getPersistentData().m_128379_("DragonArmorFly", true);
                    p.m_6885_();
                }
            } else if (!p.m_7500_() && !p.m_5833_() && p.getPersistentData().m_128471_("DragonArmorFly")) {
                p.m_150110_().f_35936_ = false;
                p.m_150110_().f_35935_ = false;
                p.getPersistentData().m_128473_("DragonArmorFly");
                p.m_6885_();
            }
        }

        private static void applyDragonArmorEffects(Player p) {
            block6: for (EquipmentSlot s : EquipmentSlot.values()) {
                ItemStack st;
                if (s.m_20743_() != EquipmentSlot.Type.ARMOR || (st = p.m_6844_(s)).m_41619_() || !(st.m_41720_() instanceof DragonArmor)) continue;
                boolean hasEnergy = st.getCapability(ForgeCapabilities.ENERGY).map(energy -> energy.getEnergyStored() > 0).orElse(false);
                int baseLevel = hasEnergy ? 4 : 3;
                int speedJumpLevel = hasEnergy ? 3 : 2;
                switch (s) {
                    case HEAD: {
                        if (TheLastSwordConfiguration.getDragonArmorEnableNightVisionSafely()) {
                            p.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 240, baseLevel, false, false));
                        }
                        p.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 240, baseLevel, false, false));
                        continue block6;
                    }
                    case CHEST: {
                        p.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 240, baseLevel, false, false));
                        p.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 240, baseLevel, false, false));
                        continue block6;
                    }
                    case LEGS: {
                        p.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 240, baseLevel, false, false));
                        p.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 240, speedJumpLevel, false, false));
                        continue block6;
                    }
                    case FEET: {
                        p.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 240, speedJumpLevel, false, false));
                        p.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 240, baseLevel, false, false));
                    }
                }
            }
        }
    }

    public static class Boots
    extends DragonArmor {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties().m_41486_().m_41497_(Rarity.EPIC));
        }

        @Override
        public EquipmentSlot m_40402_() {
            return EquipmentSlot.FEET;
        }
    }

    public static class Leggings
    extends DragonArmor {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties().m_41486_().m_41497_(Rarity.EPIC));
        }

        @Override
        public EquipmentSlot m_40402_() {
            return EquipmentSlot.LEGS;
        }
    }

    public static class Helmet
    extends DragonArmor {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties().m_41486_().m_41497_(Rarity.EPIC));
        }

        @Override
        public EquipmentSlot m_40402_() {
            return EquipmentSlot.HEAD;
        }
    }
}

