/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.item;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.summon.WraithSummonManager;

public class DragonSoulLanternItem
extends BlockItem {
    public DragonSoulLanternItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6047_() && !world.f_46443_) {
            WraithSummonManager.invokeWraith(player, stack, world);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_6047_()) {
            return super.m_6225_(context);
        }
        Player player = context.m_43723_();
        if (player != null && !context.m_43725_().f_46443_) {
            ItemStack stack = context.m_43722_();
            WraithSummonManager.invokeWraith(player, stack, context.m_43725_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        stack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(cap -> {
            int itemLevel = cap.getLevel();
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.level").m_130946_(" " + itemLevel));
        });
        stack.getCapability(ItemCapability.MODE_CAPABILITY).ifPresent(cap -> {
            int mode = cap.getMode();
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.mode").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)cap.getModeTextKey(mode))));
        });
        tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.dragon_soul_lantern"));
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.shift"));
        } else {
            stack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(levelCap -> {
                float attackPerLevel;
                float healthPerLevel;
                int itemLevel = levelCap.getLevel();
                if (itemLevel >= 6) {
                    healthPerLevel = (float)TheLastSwordConfiguration.getSwordWraithHealthPerHighLevelSafely();
                    attackPerLevel = (float)TheLastSwordConfiguration.getSwordWraithAttackPerHighLevelSafely();
                } else {
                    healthPerLevel = (float)TheLastSwordConfiguration.getSwordWraithHealthPerLevelSafely();
                    attackPerLevel = (float)TheLastSwordConfiguration.getSwordWraithAttackPerLevelSafely();
                }
                float healthBonus = (float)itemLevel * healthPerLevel;
                float attackBonus = (float)itemLevel * attackPerLevel;
                tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.dragon_soul_lantern_descr", (Object[])new Object[]{String.format("%.0f", Float.valueOf(healthBonus)), String.format("%.0f", Float.valueOf(attackBonus))}));
            });
        }
    }
}

