/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.the_last_sword.capability.ILevel;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.init.TheLastSwordModAttributes;
import org.jetbrains.annotations.NotNull;

public abstract class TheLastEndArmorItems
extends ArmorItem
implements ICapabilityProvider {
    private static final UUID[] ARMOR_MODIFIER_UUIDS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private static final UUID[] TOUGHNESS_MODIFIER_UUIDS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6C"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0E"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48F"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB151")};

    protected TheLastEndArmorItems(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    protected int getLevel(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("level")) {
            return stack.m_41783_().m_128451_("level");
        }
        return stack.getCapability(ItemCapability.LEVEL_CAPABILITY, null).map(ILevel::getLevel).orElse(0);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == this.m_40402_()) {
            double actualShieldBonus;
            HashMultimap modifiers = HashMultimap.create();
            int itemLevel = this.getLevel(stack);
            int slotIndex = slot.m_20749_();
            int[] baseArmorValues = this.getBaseArmorValues();
            double armorIncrease = this.getArmorLevelIncrease();
            double finalArmor = (double)baseArmorValues[slotIndex] + (double)itemLevel * armorIncrease;
            double baseToughness = this.getBaseToughness();
            double toughnessIncrease = this.getToughnessLevelIncrease();
            double finalToughness = baseToughness + (double)itemLevel * toughnessIncrease;
            modifiers.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_MODIFIER_UUIDS[slotIndex], "Armor modifier", finalArmor, AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(TOUGHNESS_MODIFIER_UUIDS[slotIndex], "Armor toughness", finalToughness, AttributeModifier.Operation.ADDITION));
            if (this.f_40378_ > 0.0f) {
                modifiers.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(UUID.nameUUIDFromBytes((this.getArmorName() + "_Knockback_" + slot.m_20751_()).getBytes()), "Armor knockback resistance", (double)this.f_40378_, AttributeModifier.Operation.ADDITION));
            }
            if (itemLevel > 0) {
                double healthIncrease = this.getHealthLevelIncrease();
                double healthBonus = (double)itemLevel * healthIncrease;
                modifiers.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.nameUUIDFromBytes((this.getArmorName() + "_Health_" + slot.m_20751_()).getBytes()), this.getArmorName() + " Health Bonus", healthBonus, AttributeModifier.Operation.ADDITION));
            }
            if ((actualShieldBonus = stack.getCapability(ItemCapability.Item_JUSTIFIED_DEFENCE_CAPABILITY).map(cap -> cap.getDefence()).orElse(0.0).doubleValue()) > 0.0) {
                modifiers.put((Object)((Attribute)TheLastSwordModAttributes.MAX_JUSTIFIED_DEFENCE.get()), (Object)new AttributeModifier(UUID.nameUUIDFromBytes((this.getArmorName() + "_MaxShield_" + slot.m_20751_()).getBytes()), this.getArmorName() + " Max Shield", actualShieldBonus, AttributeModifier.Operation.ADDITION));
            }
            return modifiers;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void m_7373_(ItemStack itemstack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, level, list, flag);
        int itemLevel = this.getLevel(itemstack);
        if (itemLevel > 0) {
            list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.level").m_130946_(" " + itemLevel));
        }
        this.appendSpecificTooltip(itemstack, level, list, flag);
    }

    public boolean m_41386_(DamageSource damageSource) {
        return false;
    }

    public abstract EquipmentSlot m_40402_();

    protected abstract int[] getBaseArmorValues();

    protected abstract double getBaseToughness();

    protected abstract String getArmorName();

    protected double getArmorLevelIncrease() {
        return TheLastSwordConfiguration.getArmorLevelArmorIncreaseSafely();
    }

    protected double getToughnessLevelIncrease() {
        return TheLastSwordConfiguration.getArmorLevelToughnessIncreaseSafely();
    }

    protected double getHealthLevelIncrease() {
        return TheLastSwordConfiguration.getArmorLevelHealthIncreaseSafely();
    }

    protected void appendSpecificTooltip(ItemStack itemstack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return LazyOptional.empty();
    }
}

