/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.mixin;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.entity.EntityTickList;
import net.the_last_sword.attack.AttackEffectManager;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.util.TheLastSwordLogger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityTickList.class})
public class EntityTickListMixin {
    @Shadow
    private Int2ObjectMap<Entity> f_156903_;
    @Shadow
    private Int2ObjectMap<Entity> f_156904_;
    @Shadow
    private Int2ObjectMap<Entity> f_156905_;

    @Inject(method={"add"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventBannedEntityAdd(Entity entity, CallbackInfo ci) {
        if (AttackEffectManager.isReviveBan(entity)) {
            ci.cancel();
        }
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventDefendedEntityRemoval(Entity entity, CallbackInfo ci) {
        LivingEntity livingEntity;
        int level;
        if (entity instanceof LivingEntity && (level = DefenceManager.getLevel(livingEntity = (LivingEntity)entity)) >= 3) {
            ci.cancel();
        }
    }

    @ModifyVariable(method={"forEach"}, at=@At(value="HEAD"), argsOnly=true)
    private Consumer<Entity> wrapConsumer(Consumer<Entity> originalConsumer) {
        return entity -> {
            if (entity == null) {
                return;
            }
            originalConsumer.accept((Entity)entity);
        };
    }

    @Inject(method={"forEach"}, at={@At(value="RETURN")})
    private void cleanupNullAfterForEach(Consumer<Entity> consumer, CallbackInfo ci) {
        try {
            IntArrayList keysToRemove = new IntArrayList();
            for (Int2ObjectMap.Entry entry : this.f_156903_.int2ObjectEntrySet()) {
                if (entry.getValue() != null) continue;
                keysToRemove.add(entry.getIntKey());
            }
            for (Int2ObjectMap.Entry entry : this.f_156904_.int2ObjectEntrySet()) {
                if (entry.getValue() != null) continue;
                keysToRemove.add(entry.getIntKey());
            }
            if (this.f_156905_ != null && this.f_156905_ != this.f_156903_ && this.f_156905_ != this.f_156904_) {
                for (Int2ObjectMap.Entry entry : this.f_156905_.int2ObjectEntrySet()) {
                    if (entry.getValue() != null) continue;
                    keysToRemove.add(entry.getIntKey());
                }
            }
            if (!keysToRemove.isEmpty()) {
                ObjectIterator objectIterator = keysToRemove.iterator();
                while (objectIterator.hasNext()) {
                    int key = (Integer)objectIterator.next();
                    this.f_156903_.remove(key);
                    this.f_156904_.remove(key);
                    if (this.f_156905_ == null) continue;
                    this.f_156905_.remove(key);
                }
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Failed to cleanup null entities: {}", e.getMessage());
        }
    }
}

