/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.mixin;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.the_last_sword.attack.AbsoluteDestructionDamageSource;
import net.the_last_sword.attack.AttackEffectManager;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.defence.DefenceServerEvent;
import net.the_last_sword.init.TheLastSwordModAttributes;
import net.the_last_sword.summon.WraithSummonManager;
import net.the_last_sword.util.EntityUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, priority=1024)
public class LivingEntityMixin {
    @Unique
    private boolean theLastSword$isEntityFullyInitialized(LivingEntity entity) {
        return entity.m_9236_() != null;
    }

    @Unique
    private int theLastSword$getDefenseLevel(LivingEntity entity) {
        return DefenceManager.isTracked(entity) ? DefenceManager.getLevel(entity) : 0;
    }

    @Unique
    private float theLastSword$calculateDamageLimit(float originalDamage) {
        double damageReduction = (Double)TheLastSwordConfiguration.CUSTOM_HEALTH_DAMAGE_REDUCTION.get();
        double maxDamagePerHit = (Double)TheLastSwordConfiguration.MAX_DAMAGE_PER_HIT.get();
        double limitedDamage = (double)originalDamage * damageReduction;
        return (float)Math.min(limitedDamage, maxDamagePerHit);
    }

    @Unique
    private boolean theLastSword$isAbsoluteDestructionDamage(DamageSource source) {
        return source instanceof AbsoluteDestructionDamageSource;
    }

    @Unique
    private void theLastSword$handleDefenceLevel2(LivingEntity entity) {
        Collection activeEffects;
        if (entity.m_6060_()) {
            entity.m_20095_();
        }
        if (entity.m_146890_() || entity.m_146888_() > 0) {
            entity.m_146917_(0);
        }
        if (!(activeEffects = entity.m_21220_()).isEmpty()) {
            ArrayList<MobEffect> effectsToRemove = new ArrayList<MobEffect>();
            for (MobEffectInstance effectInstance : activeEffects) {
                MobEffect effect = effectInstance.m_19544_();
                if (effect.m_19486_() || effect == MobEffects.f_19617_) continue;
                effectsToRemove.add(effect);
            }
            for (MobEffect effect : effectsToRemove) {
                entity.m_21195_(effect);
            }
        }
    }

    @Unique
    private boolean theLastSword$isReviveBanned(LivingEntity entity) {
        return AttackEffectManager.isReviveBan((Entity)entity);
    }

    @Unique
    private void theLastSword$handleHealNegationSystem(LivingEntity entity) {
        if (AttackEffectManager.isHealNegated((Entity)entity)) {
            float expectedHealth = AttackEffectManager.getHealNegationHealth((Entity)entity);
            EntityUtil.TheLastEndSetHealth(entity, expectedHealth);
        }
    }

    @Unique
    private void theLastSword$handleDefenseSystem(LivingEntity entity) {
        int defenseLevel = this.theLastSword$getDefenseLevel(entity);
        if (defenseLevel >= 1) {
            if (AttackEffectManager.isHealNegated((Entity)entity)) {
                float healNegationHealth = AttackEffectManager.getHealNegationHealth((Entity)entity);
                DefenceManager.modifyHealth(entity.m_20148_(), healNegationHealth);
            }
            DefenceManager.pushToEntity(entity);
            if (TheLastSwordConfiguration.getEnableRadicalLogicSafely()) {
                EntityUtil.clearExternalEntityData(entity);
            }
        }
        if (defenseLevel >= 2) {
            this.theLastSword$handleDefenceLevel2(entity);
        }
        float storedHealth = DefenceManager.getStoredHealth(entity);
        if (defenseLevel >= 2 && storedHealth > 0.0f && !this.theLastSword$isReviveBanned(entity)) {
            EntityUtil.TheLastEndRevive(entity);
        }
    }

    @Unique
    private boolean theLastSword$hasJustifiedDefenceShield(LivingEntity entity) {
        if (!this.theLastSword$isEntityFullyInitialized(entity)) {
            return false;
        }
        try {
            AttributeInstance shieldAttr = entity.m_21051_((Attribute)TheLastSwordModAttributes.JUSTIFIED_DEFENCE.get());
            return shieldAttr != null && shieldAttr.m_22135_() > 0.0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void theLastSword$onLivingEntityTick(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (!entity.m_9236_().f_46443_ && entity.f_19797_ > 0 && (this.theLastSword$hasJustifiedDefenceShield(entity) || entity.m_21051_((Attribute)TheLastSwordModAttributes.MAX_JUSTIFIED_DEFENCE.get()) != null)) {
            DefenceServerEvent.autoRegenerate(entity);
        }
        this.theLastSword$handleHealNegationSystem(entity);
        this.theLastSword$handleDefenseSystem(entity);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void theLastSword$onLivingEntityTickReturn(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (!entity.m_9236_().f_46443_ && entity.f_19797_ > 0 && (this.theLastSword$hasJustifiedDefenceShield(entity) || entity.m_21051_((Attribute)TheLastSwordModAttributes.MAX_JUSTIFIED_DEFENCE.get()) != null)) {
            DefenceServerEvent.autoRegenerate(entity);
        }
        this.theLastSword$handleHealNegationSystem(entity);
        this.theLastSword$handleDefenseSystem(entity);
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$hurtProtection(DamageSource damageSource, float damageAmount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        Entity entity2 = damageSource.m_7639_();
        if (entity2 instanceof LivingEntity) {
            Player wraithOwner;
            LivingEntity attacker = (LivingEntity)entity2;
            if (WraithSummonManager.isWraith(attacker) && (wraithOwner = WraithSummonManager.getOwner(attacker, entity.m_9236_())) != null && (entity.equals((Object)wraithOwner) || EntityUtil.areAllies((Entity)entity, (Entity)wraithOwner))) {
                cir.setReturnValue((Object)false);
                return;
            }
            if (WraithSummonManager.isWraith(entity) && TheLastSwordConfiguration.getSwordWraithFriendlyFireProtectionSafely() && (wraithOwner = WraithSummonManager.getOwner(entity, entity.m_9236_())) != null && (attacker.equals((Object)wraithOwner) || EntityUtil.areAllies((Entity)attacker, (Entity)wraithOwner))) {
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$gradeBasedHurtProtection(DamageSource damageSource, float damageAmount, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        Entity entity2 = damageSource.m_7639_();
        if (entity2 instanceof LivingEntity) {
            Player wraithOwner;
            LivingEntity attacker = (LivingEntity)entity2;
            if (WraithSummonManager.isWraith(attacker) && (wraithOwner = WraithSummonManager.getOwner(attacker, entity.m_9236_())) != null && (entity.equals((Object)wraithOwner) || EntityUtil.areAllies((Entity)entity, (Entity)wraithOwner))) {
                ci.cancel();
                return;
            }
            if (WraithSummonManager.isWraith(entity) && TheLastSwordConfiguration.getSwordWraithFriendlyFireProtectionSafely() && (wraithOwner = WraithSummonManager.getOwner(entity, entity.m_9236_())) != null && (attacker.equals((Object)wraithOwner) || EntityUtil.areAllies((Entity)attacker, (Entity)wraithOwner))) {
                ci.cancel();
                return;
            }
        }
        if (AttackEffectManager.isHealNegated((Entity)entity) && !this.theLastSword$isAbsoluteDestructionDamage(damageSource)) {
            float currentHealNegationHealth = AttackEffectManager.getHealNegationHealth((Entity)entity);
            float expectedHealthAfterDamage = Math.max(0.0f, currentHealNegationHealth - damageAmount);
            AttackEffectManager.updateHealNegationHealth((Entity)entity, expectedHealthAfterDamage);
            ci.cancel();
            return;
        }
        if (DefenceManager.isTracked(entity)) {
            float storedHealth = DefenceManager.getStoredHealth(entity);
            int defenseLevel = DefenceManager.getLevel(entity);
            float maxHealth = (float)entity.m_21133_(Attributes.f_22276_);
            float a = maxHealth * ((Double)TheLastSwordConfiguration.CUSTOM_HEALTH_DAMAGE_REDUCTION.get()).floatValue();
            float b = ((Double)TheLastSwordConfiguration.MAX_DAMAGE_PER_HIT.get()).floatValue();
            float damageLimit = Math.min(a, b);
            boolean damageBlocked = false;
            if (defenseLevel == 2 && damageAmount > damageLimit) {
                damageBlocked = true;
            } else if (defenseLevel >= 3) {
                damageBlocked = true;
            }
            if (!damageBlocked) {
                float realDamage = defenseLevel == 1 ? Math.min(damageAmount, damageLimit) : damageAmount;
                float newHealth = storedHealth - realDamage;
                DefenceManager.modifyHealth(entity.m_20148_(), newHealth);
            }
            ci.cancel();
        }
    }

    @Inject(method={"heal"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$handleHealMethod(float healAmount, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (AttackEffectManager.isHealNegated((Entity)entity)) {
            ci.cancel();
            return;
        }
        if (DefenceManager.isTracked(entity)) {
            float storedHealth = DefenceManager.getStoredHealth(entity);
            float maxHealth = entity.m_21233_();
            float newHealth = Math.min(storedHealth + healAmount, maxHealth);
            DefenceManager.modifyHealth(entity.m_20148_(), newHealth);
            ci.cancel();
        }
    }

    @Inject(method={"setHealth"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventSetLowHealth(float health, CallbackInfo ci) {
        float currentHealth;
        LivingEntity entity = (LivingEntity)this;
        if (AttackEffectManager.isHealNegated((Entity)entity)) {
            float currentHealNegationHealth = AttackEffectManager.getHealNegationHealth((Entity)entity);
            if (health > currentHealNegationHealth) {
                ci.cancel();
                return;
            }
            if (health < currentHealNegationHealth) {
                AttackEffectManager.updateHealNegationHealth((Entity)entity, health);
            }
            return;
        }
        if (this.theLastSword$hasJustifiedDefenceShield(entity) && health < (currentHealth = entity.m_21223_())) {
            EntityUtil.TheLastEndSetHealth(entity, entity.m_21233_());
            AttributeInstance shieldAttr = entity.m_21051_((Attribute)TheLastSwordModAttributes.JUSTIFIED_DEFENCE.get());
            if (shieldAttr != null) {
                double currentShield = shieldAttr.m_22135_();
                shieldAttr.m_22100_(Math.max(0.0, currentShield - 1.0));
            }
            ci.cancel();
            return;
        }
        int defenseLevel = this.theLastSword$getDefenseLevel(entity);
        float storedHealth = DefenceManager.getStoredHealth(entity);
        if (defenseLevel >= 1 && storedHealth > 0.0f && health <= 0.0f) {
            ci.cancel();
        }
    }

    @Inject(method={"getHealth"}, at={@At(value="RETURN")}, cancellable=true)
    private void theLastSword$returnStoredHealth(CallbackInfoReturnable<Float> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (AttackEffectManager.isHealNegated((Entity)entity)) {
            float healNegationHealth = AttackEffectManager.getHealNegationHealth((Entity)entity);
            cir.setReturnValue((Object)Float.valueOf(healNegationHealth));
            return;
        }
        int defenseLevel = this.theLastSword$getDefenseLevel(entity);
        float storedHealth = DefenceManager.getStoredHealth(entity);
        if (defenseLevel >= 1 && storedHealth > 0.0f) {
            cir.setReturnValue((Object)Float.valueOf(storedHealth));
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventDie(DamageSource damageSource, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (DefenceManager.isTracked(entity)) {
            ci.cancel();
        }
        AttackEffectManager.clearHealNegation((Entity)entity);
        AttackEffectManager.clearAll((Entity)entity);
    }

    @Inject(method={"isDeadOrDying"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventDeadOrDying(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (DefenceManager.isTracked(entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tickDeath"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventTickDeath(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (DefenceManager.isTracked(entity)) {
            entity.f_20919_ = 0;
            ci.cancel();
        }
    }
}

