/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.mixin;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.function.Predicate;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.defence.DefenceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public final class PacketMixin {
    private PacketMixin() {
    }

    @Mixin(value={Connection.class})
    public static abstract class ConnPrevent {
        @Shadow
        private PacketListener f_129470_;

        @Inject(method={"disconnect"}, at={@At(value="HEAD")}, cancellable=true)
        private void tls$blockConnDisconnect(Component reason, CallbackInfo ci) {
            PacketListener packetListener = this.f_129470_;
            if (packetListener instanceof ServerGamePacketListenerImpl) {
                ServerGamePacketListenerImpl listener = (ServerGamePacketListenerImpl)packetListener;
                ServerPlayer sp = listener.f_9743_;
                if (TheLastSwordConfiguration.getEnableRadicalLogicSafely() && sp != null && DefenceManager.isTracked((LivingEntity)sp) && DefenceManager.getLevel((LivingEntity)sp) >= 2) {
                    ci.cancel();
                }
            }
        }
    }

    @Mixin(value={ServerGamePacketListenerImpl.class})
    public static abstract class KickPrevent {
        @Shadow
        public ServerPlayer f_9743_;

        @Inject(method={"disconnect"}, at={@At(value="HEAD")}, cancellable=true)
        private void tls$blockKick(Component reason, CallbackInfo ci) {
            if (TheLastSwordConfiguration.getEnableRadicalLogicSafely() && DefenceManager.isTracked((LivingEntity)this.f_9743_) && DefenceManager.getLevel((LivingEntity)this.f_9743_) >= 2) {
                ci.cancel();
            }
        }

        @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;)V"}, at={@At(value="HEAD")}, cancellable=true)
        private void tls$blockDangerPackets(Packet<?> packet, CallbackInfo ci) {
            if (!TheLastSwordConfiguration.getEnableRadicalLogicSafely()) {
                return;
            }
            if (packet instanceof ClientboundDisconnectPacket) {
                if (DefenceManager.isTracked((LivingEntity)this.f_9743_) && DefenceManager.getLevel((LivingEntity)this.f_9743_) >= 2) {
                    ci.cancel();
                }
                return;
            }
            if (packet instanceof ClientboundSetHealthPacket) {
                if (DefenceManager.isTracked((LivingEntity)this.f_9743_) && DefenceManager.getLevel((LivingEntity)this.f_9743_) >= 2) {
                    ci.cancel();
                }
                return;
            }
            if (packet instanceof ClientboundRemoveEntitiesPacket) {
                ClientboundRemoveEntitiesPacket removePacket = (ClientboundRemoveEntitiesPacket)packet;
                if (this.theLastSword$containsProtectedEntity(removePacket)) {
                    ci.cancel();
                }
                return;
            }
            if (packet instanceof ClientboundTeleportEntityPacket) {
                ClientboundTeleportEntityPacket teleportPacket = (ClientboundTeleportEntityPacket)packet;
                if (this.theLastSword$isProtectedEntityTeleport(teleportPacket)) {
                    ci.cancel();
                }
                return;
            }
            if (packet instanceof ClientboundEntityEventPacket) {
                ClientboundEntityEventPacket eventPacket = (ClientboundEntityEventPacket)packet;
                if (this.theLastSword$isProtectedEntityEvent(eventPacket)) {
                    ci.cancel();
                }
                return;
            }
        }

        @Unique
        private boolean theLastSword$containsProtectedEntity(ClientboundRemoveEntitiesPacket packet) {
            IntList entityIds = packet.m_182730_();
            IntListIterator intListIterator = entityIds.iterator();
            while (intListIterator.hasNext()) {
                LivingEntity livingEntity;
                int level;
                int entityId = (Integer)intListIterator.next();
                Entity entity = this.f_9743_.m_9236_().m_6815_(entityId);
                if (!(entity instanceof LivingEntity) || (level = DefenceManager.getLevel(livingEntity = (LivingEntity)entity)) < 3) continue;
                return true;
            }
            return false;
        }

        @Unique
        private boolean theLastSword$isProtectedEntityTeleport(ClientboundTeleportEntityPacket packet) {
            int entityId = packet.m_133545_();
            Entity entity = this.f_9743_.m_9236_().m_6815_(entityId);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                int level = DefenceManager.getLevel(livingEntity);
                return level >= 3;
            }
            return false;
        }

        @Unique
        private boolean theLastSword$isProtectedPlayerHealthPacket(ClientboundSetHealthPacket packet) {
            return DefenceManager.isTracked((LivingEntity)this.f_9743_) && DefenceManager.getLevel((LivingEntity)this.f_9743_) >= 2;
        }

        @Unique
        private boolean theLastSword$isProtectedEntityEvent(ClientboundEntityEventPacket packet) {
            LivingEntity livingEntity;
            int level;
            byte eventId = packet.m_132102_();
            Entity entity = packet.m_132094_(this.f_9743_.m_9236_());
            if (entity instanceof LivingEntity && (level = DefenceManager.getLevel(livingEntity = (LivingEntity)entity)) >= 3) {
                return eventId == 3 || eventId == 60;
            }
            return false;
        }
    }

    @Mixin(value={Inventory.class})
    public static abstract class ClearPrevent {
        @Final
        @Shadow
        public Player f_35978_;

        @Inject(method={"clearOrCountMatchingItems"}, at={@At(value="HEAD")}, cancellable=true)
        private void tls$blockClear(Predicate<ItemStack> predicate, int maxCount, Container container, CallbackInfoReturnable<Integer> cir) {
            if (TheLastSwordConfiguration.getEnableRadicalLogicSafely() && DefenceManager.isTracked((LivingEntity)this.f_35978_) && DefenceManager.getLevel((LivingEntity)this.f_35978_) >= 2) {
                cir.setReturnValue((Object)0);
            }
        }

        @Inject(method={"clearContent"}, at={@At(value="HEAD")}, cancellable=true)
        private void tls$blockClearContent(CallbackInfo ci) {
            if (TheLastSwordConfiguration.getEnableRadicalLogicSafely() && DefenceManager.isTracked((LivingEntity)this.f_35978_) && DefenceManager.getLevel((LivingEntity)this.f_35978_) >= 2) {
                ci.cancel();
            }
        }
    }
}

