/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.mixin;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.the_last_sword.attack.AttackEffectManager;
import net.the_last_sword.defence.DefenceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PersistentEntitySectionManager.class})
public class PersistentEntitySectionManagerMixin {
    @Inject(method={"addEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$interceptAddEntity(EntityAccess entity, boolean flag, CallbackInfoReturnable<Boolean> cir) {
        Entity realEntity;
        if (entity instanceof Entity && AttackEffectManager.isReviveBan(realEntity = (Entity)entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"addNewEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$interceptNewEntity(EntityAccess entity, CallbackInfoReturnable<Boolean> cir) {
        Entity realEntity;
        if (entity instanceof Entity && AttackEffectManager.isReviveBan(realEntity = (Entity)entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"unloadEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventUnload(EntityAccess entity, CallbackInfo ci) {
        LivingEntity livingEntity;
        int level;
        if (entity instanceof LivingEntity && (level = DefenceManager.getLevel(livingEntity = (LivingEntity)entity)) >= 3) {
            ci.cancel();
        }
    }

    @Inject(method={"stopTicking"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventStopTicking(EntityAccess entity, CallbackInfo ci) {
        LivingEntity livingEntity;
        int level;
        if (entity instanceof LivingEntity && (level = DefenceManager.getLevel(livingEntity = (LivingEntity)entity)) >= 3) {
            ci.cancel();
        }
    }

    @Inject(method={"stopTracking"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventStopTracking(EntityAccess entity, CallbackInfo ci) {
        LivingEntity livingEntity;
        int level;
        if (entity instanceof LivingEntity && (level = DefenceManager.getLevel(livingEntity = (LivingEntity)entity)) >= 3) {
            ci.cancel();
        }
    }

    @Mixin(value={PersistentEntitySectionManager.Callback.class})
    public static class CallbackMixin {
        @Final
        @Shadow
        private EntityAccess f_157609_;

        @Inject(method={"onRemove"}, at={@At(value="HEAD")}, cancellable=true)
        private void theLastSword$preventCallbackRemoval(Entity.RemovalReason reason, CallbackInfo ci) {
            LivingEntity livingEntity;
            int level;
            EntityAccess entityAccess = this.f_157609_;
            if (entityAccess instanceof LivingEntity && (level = DefenceManager.getLevel(livingEntity = (LivingEntity)entityAccess)) >= 3) {
                ci.cancel();
            }
        }
    }
}

