/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.mixin;

import java.lang.reflect.Field;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.the_last_sword.util.DynamicHealthDetector;
import net.the_last_sword.util.EntityUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SynchedEntityData.class})
public class SynchedEntityDataMixin {
    @Shadow
    @Final
    private Entity f_135344_;
    @Unique
    private static EntityDataAccessor<Float> HEALTH_DATA_ACCESSOR = null;

    @Inject(method={"set"}, at={@At(value="HEAD")})
    private <T> void onEntityDataSet(EntityDataAccessor<T> accessor, T value, CallbackInfo ci) {
        try {
            if (accessor.m_135015_() != 9 || !(value instanceof Float)) {
                return;
            }
            float healthValue = ((Float)value).floatValue();
            Entity entity = this.theLastSword$getEntity();
            if (entity == null || !(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.getClass().getName().contains("Player")) {
                return;
            }
            String entityName = entity.getClass().getSimpleName();
            if (!EntityUtil.isEntityMarkedForDetection(livingEntity)) {
                return;
            }
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            boolean hasCustomCode = false;
            String entityClassName = livingEntity.getClass().getName();
            String entityPackageBase = SynchedEntityDataMixin.extractFirst3PackageLevels(entityClassName);
            for (StackTraceElement element : stackTrace) {
                String className = element.getClassName();
                if (className.startsWith("net.minecraft") || className.startsWith("java.") || className.startsWith("jdk.") || className.startsWith("net.the_last_sword") || className.startsWith("org.spongepowered") || className.startsWith("com.mojang") || className.startsWith("sun.") || className.startsWith("cpw.mods") || className.startsWith("net.minecraftforge") || entityPackageBase.isEmpty() || !className.startsWith(entityPackageBase)) continue;
                hasCustomCode = true;
                break;
            }
            if (hasCustomCode) {
                DynamicHealthDetector.onCustomHealthWriteWithEntity(stackTrace, healthValue, livingEntity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private Entity theLastSword$getEntity() {
        try {
            return this.f_135344_;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unique
    private static boolean theLastSword$isHealthDataAccessor(EntityDataAccessor<?> accessor) {
        if (HEALTH_DATA_ACCESSOR == null) {
            try {
                Field healthField = LivingEntity.class.getDeclaredField("DATA_HEALTH_ID");
                healthField.setAccessible(true);
                HEALTH_DATA_ACCESSOR = (EntityDataAccessor)healthField.get(null);
            }
            catch (Exception e) {
                return accessor.m_135016_().toString().contains("FLOAT") && accessor.m_135015_() == 9;
            }
        }
        return accessor.equals(HEALTH_DATA_ACCESSOR);
    }

    @Unique
    private static String extractFirst3PackageLevels(String fullClassName) {
        String[] parts = fullClassName.split("\\.");
        if (parts.length >= 3) {
            return parts[0] + "." + parts[1] + "." + parts[2];
        }
        if (parts.length == 2) {
            return parts[0] + "." + parts[1];
        }
        if (parts.length == 1) {
            return parts[0];
        }
        return "";
    }
}

