/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.mixin;

import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.the_last_sword.summon.WraithSummonManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TamableAnimal.class})
public class TamableAnimalMixin {
    @Inject(method={"getOwnerUUID"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetOwnerUUID(CallbackInfoReturnable<UUID> cir) {
        Player owner;
        LivingEntity entity = (LivingEntity)this;
        if (WraithSummonManager.isWraith(entity) && (owner = WraithSummonManager.getOwner(entity, entity.m_9236_())) != null) {
            cir.setReturnValue((Object)owner.m_20148_());
        }
    }

    @Inject(method={"isOwnedBy"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsOwnedBy(LivingEntity owner, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (WraithSummonManager.isWraith(entity)) {
            Player wraithOwner = WraithSummonManager.getOwner(entity, entity.m_9236_());
            boolean owned = wraithOwner != null && wraithOwner.equals((Object)owner);
            cir.setReturnValue((Object)owned);
        }
    }

    @Inject(method={"isTame"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsTame(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (WraithSummonManager.isWraith(entity)) {
            cir.setReturnValue((Object)true);
        }
    }
}

