/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.network;

import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import net.the_last_sword.world.inventory.SummonWraithGuiMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class OpenSummonWraithMessage {
    int handSlot;
    int pressedms;

    public OpenSummonWraithMessage() {
        this.handSlot = 0;
        this.pressedms = 0;
    }

    public OpenSummonWraithMessage(int handSlot, int pressedms) {
        this.handSlot = handSlot;
        this.pressedms = pressedms;
    }

    public OpenSummonWraithMessage(FriendlyByteBuf buffer) {
        this.handSlot = buffer.readInt();
        this.pressedms = buffer.readInt();
    }

    public static void buffer(OpenSummonWraithMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.handSlot);
        buffer.writeInt(message.pressedms);
    }

    public static void handler(OpenSummonWraithMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> OpenSummonWraithMessage.pressAction((Player)context.getSender(), message.handSlot, message.pressedms));
        context.setPacketHandled(true);
    }

    public static void pressAction(Player entity, final int handSlot, int pressedms) {
        Level world = entity.m_9236_();
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        if (!world.m_46805_(entity.m_20183_())) {
            return;
        }
        if (entity == null) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer _ent = (ServerPlayer)entity;
            final BlockPos _bpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            NetworkHooks.openScreen((ServerPlayer)_ent, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237115_((String)"gui.the_last_sword.summon_wraith_gui");
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                    buffer.m_130064_(_bpos);
                    buffer.writeByte(1);
                    buffer.writeByte(handSlot);
                    return new SummonWraithGuiMenu(id, inventory, buffer);
                }
            }, (BlockPos)_bpos);
        }
    }
}

