/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.potion;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.init.TheLastSwordModMobEffects;
import net.the_last_sword.util.TheLastSwordLogger;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class VoidEnchantingEffect
extends MobEffect {
    public VoidEnchantingEffect() {
        super(MobEffectCategory.BENEFICIAL, -13421773);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        Level level;
        super.m_6742_(livingEntity, amplifier);
        if (!livingEntity.m_9236_().f_46443_ && (level = livingEntity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VoidEnchantingEffect.spawnEnchantParticles(livingEntity, serverLevel);
        }
    }

    public boolean m_8093_() {
        return false;
    }

    public static void spawnEnchantParticles(LivingEntity entity, ServerLevel serverLevel) {
        double centerX = entity.m_20185_();
        double centerY = entity.m_20186_();
        double centerZ = entity.m_20189_();
        double radius = 1.5;
        float rotateAngle = serverLevel.m_46467_() % 360L * 2L;
        for (int i = 0; i < 18; ++i) {
            double angle = Math.toRadians(rotateAngle + (float)(i * 20));
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, centerX + radius * Math.cos(angle), centerY, centerZ + radius * Math.sin(angle), 2, 0.1, 0.1, 0.1, 0.02);
        }
        int starPoints = 5;
        double starRadius = radius * 0.8;
        for (int i = 0; i < starPoints; ++i) {
            double angle1 = Math.toRadians(rotateAngle + (float)(72 * i));
            double angle2 = Math.toRadians(rotateAngle + (float)(72 * i) + 144.0f);
            Vec3 start = new Vec3(centerX + starRadius * Math.cos(angle1), centerY, centerZ + starRadius * Math.sin(angle1));
            Vec3 end = new Vec3(centerX + starRadius * Math.cos(angle2), centerY, centerZ + starRadius * Math.sin(angle2));
            int steps = 8;
            for (int j = 0; j <= steps; ++j) {
                double t = (double)j / (double)steps;
                Vec3 pos = start.m_82549_(end.m_82546_(start).m_82490_(t));
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.1, 0.0, 0.0);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        Level level;
        LivingEntity victim = event.getEntity();
        DamageSource damageSource = event.getSource();
        Entity entity = damageSource.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (!attacker.m_21023_((MobEffect)TheLastSwordModMobEffects.VOID_ENCHANTMENT.get())) {
            return;
        }
        if (damageSource.m_276093_(DamageTypes.f_268724_)) {
            return;
        }
        int amplifier = attacker.m_21124_((MobEffect)TheLastSwordModMobEffects.VOID_ENCHANTMENT.get()).m_19564_();
        double attackDamage = attacker.m_21133_(Attributes.f_22281_);
        float voidDamageMultiplier = (float)((double)(amplifier + 1) * (Double)TheLastSwordConfiguration.VOID_ENCHANTMENT_DAMAGE_PERCENTAGE.get());
        float voidDamage = (float)(attackDamage * (double)voidDamageMultiplier);
        DamageSource voidDamageSource = VoidEnchantingEffect.createVoidDamageSource(attacker);
        if (!attacker.m_9236_().f_46443_ && (level = attacker.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().execute(() -> {
                if (victim.m_6084_()) {
                    VoidEnchantingEffect.applyVoidDamage(victim, voidDamageSource, voidDamage, serverLevel);
                }
            });
        }
    }

    private static DamageSource createVoidDamageSource(LivingEntity attacker) {
        return new DamageSource((Holder)attacker.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268724_), (Entity)attacker, (Entity)attacker);
    }

    private static void applyVoidDamage(LivingEntity victim, DamageSource voidDamageSource, float damage, ServerLevel serverLevel) {
        try {
            victim.f_19802_ = 0;
            boolean damaged = victim.m_6469_(voidDamageSource, damage);
            if (damaged) {
                VoidEnchantingEffect.spawnVoidEnchantingEffects(victim, serverLevel);
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Error applying void enchanting damage: {}", e.getMessage());
            e.printStackTrace();
        }
    }

    private static void spawnVoidEnchantingEffects(LivingEntity victim, ServerLevel serverLevel) {
        double centerX = victim.m_20185_();
        double centerY = victim.m_20186_() + (double)victim.m_20206_() * 0.5;
        double centerZ = victim.m_20189_();
        int particleCount = 16;
        double maxRadius = 1.5;
        for (int i = 0; i < particleCount; ++i) {
            double theta = Math.random() * Math.PI * 2.0;
            double phi = Math.random() * Math.PI;
            double radius = 0.5 + Math.random() * maxRadius;
            double x = centerX + radius * Math.sin(phi) * Math.cos(theta);
            double y = centerY + radius * Math.cos(phi);
            double z = centerZ + radius * Math.sin(phi) * Math.sin(theta);
            double velX = (x - centerX) * 0.15;
            double velY = (y - centerY) * 0.15;
            double velZ = (z - centerZ) * 0.15;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123799_, x, y, z, 1, velX, velY, velZ, 0.0);
        }
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, centerX, centerY, centerZ, 3, 0.1, 0.1, 0.1, 0.02);
    }
}

