/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import net.the_last_sword.TheLastSwordMod;
import net.the_last_sword.configuration.TheLastSwordConfigManager;
import net.the_last_sword.network.ConfigRecipeSyncPacket;
import net.the_last_sword.recipe.DragonCrystalSmithingRecipe;
import net.the_last_sword.recipe.DragonCrystalSmithingSerializer;

public class ConfigDragonCrystalSmithingManager {
    private static final Map<ResourceLocation, DragonCrystalSmithingRecipe> RECIPE_CACHE = new ConcurrentHashMap<ResourceLocation, DragonCrystalSmithingRecipe>();
    private static volatile boolean cacheLoaded = false;

    public static List<DragonCrystalSmithingRecipe> getAllRecipes() {
        ConfigDragonCrystalSmithingManager.ensureRecipesLoaded();
        return new ArrayList<DragonCrystalSmithingRecipe>(RECIPE_CACHE.values());
    }

    public static DragonCrystalSmithingRecipe findMatchingRecipe(TransientCraftingContainer container, Level level) {
        ConfigDragonCrystalSmithingManager.ensureRecipesLoaded();
        if (RECIPE_CACHE.isEmpty()) {
            cacheLoaded = false;
            ConfigDragonCrystalSmithingManager.loadRecipesFromConfig();
        }
        for (DragonCrystalSmithingRecipe recipe : RECIPE_CACHE.values()) {
            if (!recipe.matches((CraftingContainer)container, level)) continue;
            return recipe;
        }
        return null;
    }

    public static void reloadRecipes() {
        RECIPE_CACHE.clear();
        cacheLoaded = false;
        ConfigDragonCrystalSmithingManager.loadRecipesFromConfig();
    }

    private static void ensureRecipesLoaded() {
        if (!cacheLoaded || RECIPE_CACHE.isEmpty()) {
            ConfigDragonCrystalSmithingManager.loadRecipesFromConfig();
        }
    }

    private static void loadRecipesFromConfig() {
        RECIPE_CACHE.clear();
        Path recipesDir = TheLastSwordConfigManager.getRecipesDirectory();
        if (!Files.exists(recipesDir, new LinkOption[0])) {
            cacheLoaded = true;
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(recipesDir, "*.json");){
            for (Path recipeFile : stream) {
                try {
                    String fileName = recipeFile.getFileName().toString();
                    String recipeName = fileName.substring(0, fileName.lastIndexOf(46));
                    ResourceLocation recipeId = new ResourceLocation("the_last_sword", recipeName);
                    DragonCrystalSmithingRecipe recipe = ConfigDragonCrystalSmithingManager.loadRecipeFromFile(recipeId, recipeFile);
                    if (recipe == null) continue;
                    RECIPE_CACHE.put(recipeId, recipe);
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        cacheLoaded = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DragonCrystalSmithingRecipe loadRecipeFromFile(ResourceLocation recipeId, Path recipeFile) {
        try (FileReader reader = new FileReader(recipeFile.toFile());){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (!json.has("type") || !json.get("type").getAsString().equals("the_last_sword:dragon_crystal_smithing")) {
                DragonCrystalSmithingRecipe dragonCrystalSmithingRecipe = null;
                return dragonCrystalSmithingRecipe;
            }
            DragonCrystalSmithingRecipe dragonCrystalSmithingRecipe = DragonCrystalSmithingSerializer.INSTANCE.fromJson(recipeId, json);
            return dragonCrystalSmithingRecipe;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void updateClientCache(Map<ResourceLocation, DragonCrystalSmithingRecipe> clientRecipes) {
        RECIPE_CACHE.clear();
        RECIPE_CACHE.putAll(clientRecipes);
        cacheLoaded = true;
    }

    public static void syncRecipesToPlayer(ServerPlayer player) {
        ConfigDragonCrystalSmithingManager.ensureRecipesLoaded();
        ConcurrentHashMap<String, String> recipeData = new ConcurrentHashMap<String, String>();
        Gson gson = new Gson();
        for (Map.Entry<ResourceLocation, DragonCrystalSmithingRecipe> entry : RECIPE_CACHE.entrySet()) {
            try {
                JsonObject json = DragonCrystalSmithingSerializer.INSTANCE.toJson(entry.getValue());
                recipeData.put(entry.getKey().m_135815_(), gson.toJson((JsonElement)json));
            }
            catch (Exception exception) {}
        }
        ConfigRecipeSyncPacket packet = new ConfigRecipeSyncPacket(recipeData);
        TheLastSwordMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void syncRecipesToAllPlayers() {
        ConfigDragonCrystalSmithingManager.ensureRecipesLoaded();
        ConcurrentHashMap<String, String> recipeData = new ConcurrentHashMap<String, String>();
        Gson gson = new Gson();
        for (Map.Entry<ResourceLocation, DragonCrystalSmithingRecipe> entry : RECIPE_CACHE.entrySet()) {
            try {
                JsonObject json = DragonCrystalSmithingSerializer.INSTANCE.toJson(entry.getValue());
                recipeData.put(entry.getKey().m_135815_(), gson.toJson((JsonElement)json));
            }
            catch (Exception exception) {}
        }
        ConfigRecipeSyncPacket packet = new ConfigRecipeSyncPacket(recipeData);
        TheLastSwordMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }
}

