/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.the_last_sword.TheLastSwordMod;
import net.the_last_sword.capability.DefaultExtraAttackDamage;
import net.the_last_sword.capability.ILevel;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonCrystalSmithingRecipe
implements Recipe<CraftingContainer> {
    private static final Logger LOGGER = LogManager.getLogger(DragonCrystalSmithingRecipe.class);
    private final ResourceLocation id;
    private final Ingredient template;
    private final Ingredient input;
    public final int inputLevel;
    private final Ingredient addition;
    private final ItemStack result;
    public final int resultLevel;

    public DragonCrystalSmithingRecipe(ResourceLocation id, Ingredient template, Ingredient input, int inputLevel, Ingredient addition, ItemStack result, int resultLevel) {
        this.id = id;
        this.template = template;
        this.input = input;
        this.inputLevel = inputLevel;
        this.addition = addition;
        this.result = result;
        this.resultLevel = resultLevel;
        this.result.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(cap -> cap.setLevel(resultLevel));
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        ItemStack resultStack = this.result.m_41777_();
        resultStack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(levelCap -> {
            levelCap.setLevel(this.resultLevel);
            resultStack.getCapability(ItemCapability.EXTRA_ATTACK_DAMAGE_CAPABILITY).ifPresent(extra -> ((DefaultExtraAttackDamage)extra).updateExtraAttackDamage(this.resultLevel));
            double per = (Double)TheLastSwordConfiguration.ARMOR_LEVEL_JUSTIFIED_DEFENCE_INCREASE.get();
            double total = (double)this.resultLevel * per;
            resultStack.getCapability(ItemCapability.Item_JUSTIFIED_DEFENCE_CAPABILITY).ifPresent(def -> def.setDefence(total));
        });
        return resultStack;
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack templateStack = container.m_8020_(0);
        ItemStack inputStack = container.m_8020_(1);
        ItemStack additionStack = container.m_8020_(2);
        int inputStackLevel = inputStack.getCapability(ItemCapability.LEVEL_CAPABILITY).map(ILevel::getLevel).orElse(0);
        boolean matches = this.template.test(templateStack) && this.input.test(inputStack) && this.addition.test(additionStack) && this.inputLevel == inputStackLevel;
        return matches;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack resultStack = this.result.m_41777_();
        resultStack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(levelCap -> {
            levelCap.setLevel(this.resultLevel);
            resultStack.getCapability(ItemCapability.EXTRA_ATTACK_DAMAGE_CAPABILITY).ifPresent(extra -> ((DefaultExtraAttackDamage)extra).updateExtraAttackDamage(this.resultLevel));
            double per = (Double)TheLastSwordConfiguration.ARMOR_LEVEL_JUSTIFIED_DEFENCE_INCREASE.get();
            double total = (double)this.resultLevel * per;
            resultStack.getCapability(ItemCapability.Item_JUSTIFIED_DEFENCE_CAPABILITY).ifPresent(def -> def.setDefence(total));
        });
        return resultStack;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TheLastSwordMod.DRAGON_CRYSTAL_SMITHING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TheLastSwordMod.DRAGON_CRYSTAL_SMITHING.get();
    }

    public Ingredient getTemplate() {
        return this.template;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Ingredient getAddition() {
        return this.addition;
    }
}

