/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.recipe.DragonCrystalSmithingRecipe;

public class DragonCrystalSmithingSerializer
implements RecipeSerializer<DragonCrystalSmithingRecipe> {
    public static final DragonCrystalSmithingSerializer INSTANCE = new DragonCrystalSmithingSerializer();
    public static final ResourceLocation ID = new ResourceLocation("the_last_sword", "dragon_crystal_smithing");

    public DragonCrystalSmithingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        Ingredient template = this.parseIngredient(json.get("template"));
        JsonObject inputJson = json.getAsJsonObject("input");
        Ingredient input = this.parseIngredient((JsonElement)inputJson);
        if (!json.has("inputLevel")) {
            throw new JsonSyntaxException("Missing inputLevel, expected to find a Int");
        }
        int inputLevel = GsonHelper.m_13927_((JsonObject)json, (String)"inputLevel");
        Ingredient addition = this.parseIngredient(json.get("addition"));
        JsonObject resultJson = json.getAsJsonObject("result");
        ItemStack result = ShapedRecipe.m_151274_((JsonObject)resultJson);
        int resultLevel = GsonHelper.m_13927_((JsonObject)resultJson, (String)"level");
        return new DragonCrystalSmithingRecipe(recipeId, template, input, inputLevel, addition, result, resultLevel);
    }

    private Ingredient parseIngredient(JsonElement element) {
        JsonObject obj;
        if (element.isJsonObject() && (obj = element.getAsJsonObject()).has("item")) {
            try {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(obj.get("item").getAsString()));
                if (item != null) {
                    return Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Ingredient.m_43917_((JsonElement)element);
    }

    public DragonCrystalSmithingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient template = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int inputLevel = buffer.readInt();
        Ingredient addition = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack result = buffer.m_130267_();
        int resultLevel = buffer.readInt();
        return new DragonCrystalSmithingRecipe(recipeId, template, input, inputLevel, addition, result, resultLevel);
    }

    public void toNetwork(FriendlyByteBuf buffer, DragonCrystalSmithingRecipe recipe) {
        recipe.getTemplate().m_43923_(buffer);
        recipe.getInput().m_43923_(buffer);
        buffer.writeInt(recipe.inputLevel);
        recipe.getAddition().m_43923_(buffer);
        buffer.m_130055_(recipe.m_8043_(null));
        buffer.writeInt(recipe.resultLevel);
    }

    public JsonObject toJson(DragonCrystalSmithingRecipe recipe) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "the_last_sword:dragon_crystal_smithing");
        json.add("template", recipe.getTemplate().m_43942_());
        json.add("input", recipe.getInput().m_43942_());
        json.addProperty("inputLevel", (Number)recipe.inputLevel);
        json.add("addition", recipe.getAddition().m_43942_());
        JsonObject resultJson = new JsonObject();
        ItemStack result = recipe.m_8043_(null);
        resultJson.addProperty("item", result.m_41720_().toString());
        if (result.m_41613_() != 1) {
            resultJson.addProperty("count", (Number)result.m_41613_());
        }
        resultJson.addProperty("level", (Number)recipe.resultLevel);
        json.add("result", (JsonElement)resultJson);
        return json;
    }
}

