/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.summon;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.summon.WraithSummonManager;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WraithDataSavedData
extends SavedData {
    private final Map<UUID, CompoundTag> wraithRecordsNBT = new HashMap<UUID, CompoundTag>();

    private WraithDataSavedData() {
    }

    public static WraithDataSavedData get(ServerLevel level) {
        return (WraithDataSavedData)level.m_8895_().m_164861_(WraithDataSavedData::load, WraithDataSavedData::new, "the_last_sword_wraith_data");
    }

    private static WraithDataSavedData load(CompoundTag root) {
        WraithDataSavedData data = new WraithDataSavedData();
        CompoundTag all = root.m_128469_("WraithRecords");
        for (String k : all.m_128431_()) {
            try {
                UUID uuid = UUID.fromString(k);
                data.wraithRecordsNBT.put(uuid, all.m_128469_(k));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag root) {
        CompoundTag all = new CompoundTag();
        this.wraithRecordsNBT.forEach((id, tag) -> all.m_128365_(id.toString(), (Tag)tag));
        root.m_128365_("WraithRecords", (Tag)all);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistData(ServerLevel level) {
        WraithDataSavedData store = WraithDataSavedData.get(level);
        Class<WraithSummonManager> clazz = WraithSummonManager.class;
        synchronized (WraithSummonManager.class) {
            store.wraithRecordsNBT.clear();
            Map<UUID, CompoundTag> latest = WraithSummonManager.exportRecords();
            store.wraithRecordsNBT.putAll(latest);
            store.m_77762_();
            WraithSummonManager.markSaved();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadToManager(ServerLevel level) {
        WraithDataSavedData store = WraithDataSavedData.get(level);
        Class<WraithSummonManager> clazz = WraithSummonManager.class;
        synchronized (WraithSummonManager.class) {
            WraithSummonManager.mergeRecords(store.wraithRecordsNBT);
            WraithSummonManager.markSaved();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadFromAllDimensions(ServerLevel anyLevel) {
        Class<WraithSummonManager> clazz = WraithSummonManager.class;
        synchronized (WraithSummonManager.class) {
            WraithSummonManager.clearAllRecords();
            anyLevel.m_7654_().m_129785_().forEach(lvl -> {
                WraithDataSavedData store = WraithDataSavedData.get(lvl);
                WraithSummonManager.mergeRecords(store.wraithRecordsNBT);
            });
            WraithSummonManager.markSaved();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
        ServerPlayer sp;
        Player player = e.getEntity();
        if (player instanceof ServerPlayer && (player = (sp = (ServerPlayer)player).m_9236_()) instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)player;
            WraithDataSavedData.reloadFromAllDimensions(lvl);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        ServerPlayer sp;
        Player player = e.getEntity();
        if (player instanceof ServerPlayer && (player = (sp = (ServerPlayer)player).m_9236_()) instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)player;
            if (WraithSummonManager.needsSave()) {
                WraithDataSavedData.persistData(lvl);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent e) {
        if (!WraithSummonManager.needsSave()) {
            return;
        }
        e.getServer().m_129785_().forEach(WraithDataSavedData::persistData);
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load e) {
        LevelAccessor levelAccessor = e.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)levelAccessor;
            WraithDataSavedData.loadToManager(lvl);
        }
    }
}

