/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.summon;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.attack.AbsoluteDestructionDamageSource;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.entity.TheLastEndEntity;
import net.the_last_sword.entity.TheLastEndSwordWraithEntity;
import net.the_last_sword.item.DragonCrystalSoulStone;
import net.the_last_sword.item.DragonCrystalSword;
import net.the_last_sword.item.TheLastEndSword;
import net.the_last_sword.util.EntityUtil;
import net.the_last_sword.util.TheLastSwordLogger;

@Mod.EventBusSubscriber(modid="the_last_sword")
public class WraithSummonManager {
    private static final ConcurrentHashMap<UUID, WraithRecord> WRAITH_RECORDS = new ConcurrentHashMap();
    private static final Map<UUID, Double> TEMPORARY_SHIELDS = new ConcurrentHashMap<UUID, Double>();
    private static volatile boolean needsSave = false;
    private static final double MAX_OWNER_DISTANCE = 32.0;
    private static final double FOLLOW_DISTANCE = 4.5;
    private static int playerShieldCheckCounter = 0;
    private static final int PLAYER_SHIELD_CHECK_INTERVAL = 20;
    private static int bossBarCleanupCounter = 0;
    private static final int BOSS_BAR_CLEANUP_INTERVAL = 20;

    public static boolean invokeWraith(Player player, ItemStack weaponStack, Level level) {
        WraithRecord record;
        CompoundTag nbt;
        if (level.f_46443_) {
            return false;
        }
        ItemStack soulStone = WraithSummonManager.getSoulStoneFromWeapon(weaponStack);
        if (soulStone.m_41619_()) {
            player.m_213846_((Component)Component.m_237115_((String)"message.the_last_sword.no_soul_stone").m_130940_(ChatFormatting.RED));
            return false;
        }
        String entityId = null;
        UUID wraitheUUID = null;
        Item item = soulStone.m_41720_();
        if (item instanceof DragonCrystalSoulStone) {
            DragonCrystalSoulStone soulStoneItem = (DragonCrystalSoulStone)item;
            entityId = soulStoneItem.getDefaultBoundEntityId();
        }
        if (entityId == null && (nbt = soulStone.m_41783_()) != null && nbt.m_128441_("wraith_entity_id")) {
            entityId = nbt.m_128461_("wraith_entity_id");
        }
        if ((nbt = soulStone.m_41783_()) != null && nbt.m_128441_("wraith_uuid")) {
            try {
                wraitheUUID = UUID.fromString(nbt.m_128461_("wraith_uuid"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (entityId == null) {
            player.m_213846_((Component)Component.m_237115_((String)"message.the_last_sword.soul_stone_empty").m_130940_(ChatFormatting.RED));
            return false;
        }
        if (wraitheUUID == null) {
            wraitheUUID = UUID.randomUUID();
            CompoundTag soulStoneNBT = soulStone.m_41784_();
            soulStoneNBT.m_128359_("wraith_entity_id", entityId);
            soulStoneNBT.m_128359_("wraith_uuid", wraitheUUID.toString());
            WraithSummonManager.saveSoulStoneToWeapon(weaponStack, soulStone);
        }
        if ((record = WRAITH_RECORDS.get(wraitheUUID)) == null) {
            return WraithSummonManager.performFirstTimeSummon(player, weaponStack, level, entityId, wraitheUUID, soulStone);
        }
        if (record.isSummoned) {
            return WraithSummonManager.performRecall(player, weaponStack, level, record);
        }
        if (record.wasNormalRecall) {
            return WraithSummonManager.performResummon(player, weaponStack, level, record);
        }
        TheLastSwordLogger.info("Wraith was abnormally removed or never recalled, creating fresh entity to avoid state corruption");
        return WraithSummonManager.performFirstTimeSummon(player, weaponStack, level, entityId, wraitheUUID, soulStone);
    }

    private static boolean performFirstTimeSummon(Player player, ItemStack weaponStack, Level level, String entityId, UUID wraitheUUID, ItemStack soulStone) {
        EntityType<?> entityType = WraithSummonManager.getEntityTypeFromString(entityId);
        if (entityType == null) {
            player.m_213846_((Component)Component.m_237115_((String)"message.the_last_sword.summon_failed").m_130940_(ChatFormatting.RED));
            return false;
        }
        Entity entity = entityType.m_20615_(level);
        if (!(entity instanceof LivingEntity)) {
            player.m_213846_((Component)Component.m_237115_((String)"message.the_last_sword.summon_failed").m_130940_(ChatFormatting.RED));
            return false;
        }
        LivingEntity wraith = (LivingEntity)entity;
        wraith.m_20084_(wraitheUUID);
        Vec3 spawnPos = WraithSummonManager.findSafeSpawnPosition(player);
        wraith.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        boolean addSuccess = level.m_7967_((Entity)wraith);
        if (!addSuccess) {
            player.m_213846_((Component)Component.m_237115_((String)"message.the_last_sword.summon_blocked").m_130940_(ChatFormatting.RED));
            TheLastSwordLogger.warn("Failed to add wraith entity to level: entity type may be blocked or banned");
            return false;
        }
        float healthBonus = WraithSummonManager.calculateHealthBonus(weaponStack);
        float attackBonus = WraithSummonManager.calculateAttackBonus(weaponStack);
        WraithSummonManager.applyBonusToEntity(wraith, healthBonus, attackBonus);
        WraithSummonManager.setWraithCustomName(wraith, player);
        WraithSummonManager.setupOwnership(wraith, player);
        WraithSummonManager.clearNativeAI(wraith);
        EntityUtil.theLastEndCleanupBossBar((Entity)wraith);
        WraithSummonManager.registerWraithDefense(wraith, weaponStack);
        CompoundTag entityNBT = new CompoundTag();
        wraith.m_20223_(entityNBT);
        WraithRecord record = new WraithRecord(wraitheUUID, player.m_20148_(), entityNBT, entityId);
        record.isSummoned = true;
        record.healthBonus = healthBonus;
        record.attackBonus = attackBonus;
        record.dimension = level.m_46472_();
        record.weaponLevel = weaponStack.getCapability(ItemCapability.LEVEL_CAPABILITY).map(levelCap -> levelCap.getLevel()).orElse(1);
        WRAITH_RECORDS.put(wraitheUUID, record);
        WraithSummonManager.markDirty();
        WraithSummonManager.sendSummonMessage(player, wraith);
        return true;
    }

    private static boolean performRecall(Player player, ItemStack weaponStack, Level level, WraithRecord record) {
        LivingEntity wraith = WraithSummonManager.findWraithEntity(level, record.wraitheUUID, record.entityType);
        if (wraith == null) {
            TheLastSwordLogger.warn("Wraith entity not found but marked as summoned, auto-fixing state");
            record.isSummoned = false;
            record.healthBonus = 0.0f;
            record.attackBonus = 0.0f;
            WraithSummonManager.markDirty();
            return WraithSummonManager.performResummon(player, weaponStack, level, record);
        }
        WraithSummonManager.removeBonusFromEntity(wraith, record.healthBonus, record.attackBonus);
        float currentHealth = wraith.m_21223_();
        CompoundTag entityNBT = new CompoundTag();
        wraith.m_20223_(entityNBT);
        record.entityNBT = entityNBT;
        record.lastSaveTime = System.currentTimeMillis();
        record.healthBonus = 0.0f;
        record.attackBonus = 0.0f;
        record.isSummoned = false;
        record.wasNormalRecall = true;
        WraithSummonManager.markDirty();
        DefenceManager.clear(wraith);
        EntityUtil.TheLastEndRemove((Entity)wraith, Entity.RemovalReason.DISCARDED);
        WraithSummonManager.addTemporaryShield(player, weaponStack, currentHealth);
        WraithSummonManager.applyCooldown(player, weaponStack);
        player.m_213846_((Component)Component.m_237115_((String)"message.the_last_sword.recall_success").m_130940_(ChatFormatting.GREEN));
        return true;
    }

    private static boolean performResummon(Player player, ItemStack weaponStack, Level level, WraithRecord record) {
        Entity entity = EntityType.m_20645_((CompoundTag)record.entityNBT, (Level)level, e -> e);
        if (!(entity instanceof LivingEntity)) {
            player.m_213846_((Component)Component.m_237115_((String)"message.the_last_sword.summon_failed").m_130940_(ChatFormatting.RED));
            return false;
        }
        LivingEntity wraith = (LivingEntity)entity;
        Vec3 spawnPos = WraithSummonManager.findSafeSpawnPosition(player);
        wraith.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        boolean addSuccess = level.m_7967_((Entity)wraith);
        if (!addSuccess) {
            player.m_213846_((Component)Component.m_237115_((String)"message.the_last_sword.summon_blocked").m_130940_(ChatFormatting.RED));
            TheLastSwordLogger.warn("Failed to resummon wraith entity to level: entity type may be blocked or banned");
            return false;
        }
        float healthBonus = WraithSummonManager.calculateHealthBonus(weaponStack);
        float attackBonus = WraithSummonManager.calculateAttackBonus(weaponStack);
        WraithSummonManager.applyBonusToEntity(wraith, healthBonus, attackBonus);
        WraithSummonManager.setWraithCustomName(wraith, player);
        WraithSummonManager.setupOwnership(wraith, player);
        WraithSummonManager.clearNativeAI(wraith);
        EntityUtil.theLastEndCleanupBossBar((Entity)wraith);
        WraithSummonManager.registerWraithDefense(wraith, weaponStack);
        record.isSummoned = true;
        record.healthBonus = healthBonus;
        record.attackBonus = attackBonus;
        record.dimension = level.m_46472_();
        record.wasNormalRecall = false;
        record.weaponLevel = weaponStack.getCapability(ItemCapability.LEVEL_CAPABILITY).map(levelCap -> levelCap.getLevel()).orElse(1);
        WraithSummonManager.markDirty();
        WraithSummonManager.sendSummonMessage(player, wraith);
        return true;
    }

    public static boolean isWraith(UUID entityUUID) {
        return entityUUID != null && WRAITH_RECORDS.containsKey(entityUUID);
    }

    public static boolean isWraith(LivingEntity entity) {
        return entity != null && WraithSummonManager.isWraith(entity.m_20148_());
    }

    public static UUID getOwnerUUID(UUID wraitheUUID) {
        WraithRecord record = WRAITH_RECORDS.get(wraitheUUID);
        return record != null ? record.ownerUUID : null;
    }

    public static Player getOwner(LivingEntity wraith, Level level) {
        if (wraith == null || level == null) {
            return null;
        }
        UUID ownerUUID = WraithSummonManager.getOwnerUUID(wraith.m_20148_());
        if (ownerUUID == null) {
            return null;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_7654_().m_6846_().m_11259_(ownerUUID);
        }
        return null;
    }

    public static int getWraithWeaponLevel(UUID wraitheUUID) {
        WraithRecord record = WRAITH_RECORDS.get(wraitheUUID);
        return record != null ? record.weaponLevel : 1;
    }

    public static boolean hasWeaponSummoned(ItemStack weaponStack) {
        ItemStack soulStone = WraithSummonManager.getSoulStoneFromWeapon(weaponStack);
        if (soulStone.m_41619_()) {
            return false;
        }
        CompoundTag nbt = soulStone.m_41783_();
        if (nbt == null || !nbt.m_128441_("wraith_uuid")) {
            return false;
        }
        try {
            UUID wraitheUUID = UUID.fromString(nbt.m_128461_("wraith_uuid"));
            WraithRecord record = WRAITH_RECORDS.get(wraitheUUID);
            return record != null && record.isSummoned;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasTemporaryShield(Player player) {
        return TEMPORARY_SHIELDS.containsKey(player.m_20148_());
    }

    public static Map<UUID, CompoundTag> exportRecords() {
        HashMap<UUID, CompoundTag> out = new HashMap<UUID, CompoundTag>();
        for (Map.Entry<UUID, WraithRecord> entry : WRAITH_RECORDS.entrySet()) {
            WraithRecord record = entry.getValue();
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("OwnerUUID", record.ownerUUID.toString());
            tag.m_128365_("EntityNBT", (Tag)record.entityNBT);
            tag.m_128359_("EntityType", record.entityType);
            tag.m_128379_("IsSummoned", record.isSummoned);
            tag.m_128350_("HealthBonus", record.healthBonus);
            tag.m_128350_("AttackBonus", record.attackBonus);
            tag.m_128356_("LastSaveTime", record.lastSaveTime);
            tag.m_128379_("WasNormalRecall", record.wasNormalRecall);
            tag.m_128405_("WeaponLevel", record.weaponLevel);
            if (record.dimension != null) {
                tag.m_128359_("Dimension", record.dimension.m_135782_().toString());
            }
            out.put(entry.getKey(), tag);
        }
        return out;
    }

    public static void mergeRecords(Map<UUID, CompoundTag> in) {
        if (in == null) {
            return;
        }
        for (Map.Entry<UUID, CompoundTag> entry : in.entrySet()) {
            if (WRAITH_RECORDS.containsKey(entry.getKey())) continue;
            CompoundTag tag = entry.getValue();
            try {
                UUID ownerUUID = UUID.fromString(tag.m_128461_("OwnerUUID"));
                CompoundTag entityNBT = tag.m_128469_("EntityNBT");
                String entityType = tag.m_128461_("EntityType");
                WraithRecord record = new WraithRecord(entry.getKey(), ownerUUID, entityNBT, entityType);
                record.isSummoned = tag.m_128471_("IsSummoned");
                record.healthBonus = tag.m_128457_("HealthBonus");
                record.attackBonus = tag.m_128457_("AttackBonus");
                record.lastSaveTime = tag.m_128454_("LastSaveTime");
                record.wasNormalRecall = tag.m_128471_("WasNormalRecall");
                int n = record.weaponLevel = tag.m_128441_("WeaponLevel") ? tag.m_128451_("WeaponLevel") : 1;
                if (tag.m_128441_("Dimension")) {
                    ResourceLocation dimLoc = new ResourceLocation(tag.m_128461_("Dimension"));
                    record.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimLoc);
                }
                WRAITH_RECORDS.put(entry.getKey(), record);
            }
            catch (Exception e) {
                TheLastSwordLogger.error("Failed to merge wraith record: " + entry.getKey(), e);
            }
        }
    }

    public static boolean needsSave() {
        return needsSave;
    }

    public static void markSaved() {
        needsSave = false;
    }

    public static void clearAllRecords() {
        WRAITH_RECORDS.clear();
        WraithSummonManager.markDirty();
    }

    public static int getRecordCount() {
        return WRAITH_RECORDS.size();
    }

    private static void markDirty() {
        needsSave = true;
    }

    private static ItemStack getSoulStoneFromWeapon(ItemStack weaponStack) {
        ItemStack savedSoulStone;
        CompoundTag weaponNBT = weaponStack.m_41783_();
        if (weaponNBT != null && weaponNBT.m_128441_("wraith_soul_stone_data") && !(savedSoulStone = ItemStack.m_41712_((CompoundTag)weaponNBT.m_128469_("wraith_soul_stone_data"))).m_41619_() && savedSoulStone.m_41720_() instanceof DragonCrystalSoulStone) {
            return savedSoulStone;
        }
        return ItemStack.f_41583_;
    }

    private static void saveSoulStoneToWeapon(ItemStack weaponStack, ItemStack soulStone) {
        CompoundTag weaponNBT = weaponStack.m_41784_();
        CompoundTag soulStoneTag = new CompoundTag();
        soulStone.m_41739_(soulStoneTag);
        weaponNBT.m_128365_("wraith_soul_stone_data", (Tag)soulStoneTag);
    }

    private static LivingEntity findWraithEntity(Level level, UUID wraitheUUID, String entityType) {
        ResourceLocation expectedType;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        try {
            expectedType = new ResourceLocation(entityType);
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Invalid entity type string: " + entityType, e);
            return null;
        }
        for (Entity entity : serverLevel.m_8583_()) {
            ResourceLocation actualType;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            if (!entity.m_20148_().equals(wraitheUUID) || !expectedType.equals((Object)(actualType = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_())))) continue;
            return living;
        }
        return null;
    }

    private static EntityType<?> getEntityTypeFromString(String entityTypeStr) {
        try {
            ResourceLocation rl = new ResourceLocation(entityTypeStr);
            return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rl);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Vec3 findSafeSpawnPosition(Player owner) {
        Vec3 ownerPos = owner.m_20182_();
        double angle = owner.m_9236_().f_46441_.m_188500_() * 2.0 * Math.PI;
        double distance = 2.0 + owner.m_9236_().f_46441_.m_188500_();
        double x = ownerPos.f_82479_ + Math.cos(angle) * distance;
        double z = ownerPos.f_82481_ + Math.sin(angle) * distance;
        return new Vec3(x, ownerPos.f_82480_, z);
    }

    private static float calculateHealthBonus(ItemStack weaponStack) {
        float[] bonus = new float[]{0.0f};
        weaponStack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(levelCap -> {
            int level = levelCap.getLevel();
            bonus[0] = level >= 6 ? (float)level * (float)TheLastSwordConfiguration.getSwordWraithHealthPerHighLevelSafely() : (float)level * (float)TheLastSwordConfiguration.getSwordWraithHealthPerLevelSafely();
        });
        return bonus[0];
    }

    private static float calculateAttackBonus(ItemStack weaponStack) {
        float[] bonus = new float[]{0.0f};
        weaponStack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(levelCap -> {
            int level = levelCap.getLevel();
            bonus[0] = level >= 6 ? (float)level * (float)TheLastSwordConfiguration.getSwordWraithAttackPerHighLevelSafely() : (float)level * (float)TheLastSwordConfiguration.getSwordWraithAttackPerLevelSafely();
        });
        return bonus[0];
    }

    private static void applyBonusToEntity(LivingEntity entity, float healthBonus, float attackBonus) {
        AttributeInstance attackAttr;
        AttributeInstance healthAttr;
        if (healthBonus > 0.0f && (healthAttr = entity.m_21051_(Attributes.f_22276_)) != null) {
            double newMaxHealth = healthAttr.m_22115_() + (double)healthBonus;
            healthAttr.m_22100_(newMaxHealth);
            entity.m_21153_((float)newMaxHealth);
        }
        if (attackBonus > 0.0f && (attackAttr = entity.m_21051_(Attributes.f_22281_)) != null) {
            double newAttack = attackAttr.m_22115_() + (double)attackBonus;
            attackAttr.m_22100_(newAttack);
        }
    }

    private static void removeBonusFromEntity(LivingEntity entity, float healthBonus, float attackBonus) {
        AttributeInstance attackAttr;
        AttributeInstance healthAttr;
        if (healthBonus > 0.0f && (healthAttr = entity.m_21051_(Attributes.f_22276_)) != null) {
            double newMaxHealth = Math.max(1.0, healthAttr.m_22115_() - (double)healthBonus);
            healthAttr.m_22100_(newMaxHealth);
            if ((double)entity.m_21223_() > newMaxHealth) {
                entity.m_21153_((float)newMaxHealth);
            }
        }
        if (attackBonus > 0.0f && (attackAttr = entity.m_21051_(Attributes.f_22281_)) != null) {
            double newAttack = Math.max(0.0, attackAttr.m_22115_() - (double)attackBonus);
            attackAttr.m_22100_(newAttack);
        }
    }

    private static void setWraithCustomName(LivingEntity wraith, Player owner) {
        try {
            Component originalName = wraith.m_6095_().m_20676_();
            MutableComponent newName = Component.m_237110_((String)"entity.the_last_sword.sword_wraith", (Object[])new Object[]{owner.m_5446_().getString(), originalName.getString()});
            wraith.m_6593_((Component)newName);
            wraith.m_20340_(true);
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Failed to set wraith custom name", e);
        }
    }

    private static void setupOwnership(LivingEntity wraith, Player owner) {
        if (wraith instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)wraith;
            tamable.m_21816_(owner.m_20148_());
            tamable.m_7105_(true);
        }
    }

    private static void clearNativeAI(LivingEntity wraith) {
        if (wraith instanceof TamableAnimal) {
            return;
        }
        if (wraith instanceof Mob) {
            Mob mob = (Mob)wraith;
            mob.f_21346_.m_148105_().clear();
        }
    }

    private static void registerWraithDefense(LivingEntity wraith, ItemStack weaponStack) {
        if (wraith == null || weaponStack == null) {
            return;
        }
        int weaponLevel = weaponStack.getCapability(ItemCapability.LEVEL_CAPABILITY).map(levelCap -> levelCap.getLevel()).orElse(1);
        if (wraith instanceof TheLastEndEntity) {
            TheLastEndEntity endEntity = (TheLastEndEntity)wraith;
            endEntity.setEndLevel(weaponLevel);
            return;
        }
        if (TheLastSwordConfiguration.getSwordWraithAsEndEntitySafely()) {
            int defenseLevel = WraithSummonManager.mapWeaponLevelToDefenseLevel(weaponLevel);
            DefenceManager.register(wraith, defenseLevel);
        }
    }

    private static int mapWeaponLevelToDefenseLevel(int weaponLevel) {
        if (weaponLevel <= 5) {
            return 1;
        }
        if (weaponLevel <= 13) {
            return 2;
        }
        return 2;
    }

    private static void sendSummonMessage(Player player, LivingEntity entity) {
        if (entity instanceof TheLastEndSwordWraithEntity) {
            String[] spawnKeys = new String[]{"talk.the_last_end_sword_wraith.spawn_1", "talk.the_last_end_sword_wraith.spawn_2", "talk.the_last_end_sword_wraith.spawn_3"};
            String randomKey = spawnKeys[player.m_217043_().m_188503_(spawnKeys.length)];
            MutableComponent summonMessage = Component.m_237115_((String)randomKey);
            MutableComponent prefixedMessage = Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"entity.the_last_sword.the_last_end_sword_wraith")).m_7220_((Component)Component.m_237113_((String)"] ")).m_130940_(ChatFormatting.DARK_PURPLE).m_7220_((Component)summonMessage.m_6881_().m_130940_(ChatFormatting.WHITE));
            player.m_213846_((Component)prefixedMessage);
        } else {
            Component entityName = entity.m_8077_() ? entity.m_7770_() : entity.m_5446_();
            player.m_213846_((Component)Component.m_237110_((String)"message.the_last_sword.summon_success", (Object[])new Object[]{entityName}));
        }
    }

    private static void addTemporaryShield(Player player, ItemStack weaponStack, float wraithCurrentHealth) {
        double shieldMultiplier = WraithSummonManager.getShieldMultiplier(weaponStack);
        double shieldAmount = (double)wraithCurrentHealth * shieldMultiplier;
        AttributeInstance healthAttr = player.m_21051_(Attributes.f_22276_);
        if (healthAttr != null) {
            double newMaxHealth = healthAttr.m_22115_() + shieldAmount;
            healthAttr.m_22100_(newMaxHealth);
            player.m_21153_((float)newMaxHealth);
        }
        TEMPORARY_SHIELDS.put(player.m_20148_(), shieldAmount);
    }

    private static double getShieldMultiplier(ItemStack weaponStack) {
        if (weaponStack.m_41720_() instanceof TheLastEndSword) {
            return TheLastSwordConfiguration.getTheLastEndSwordShieldMultiplierSafely();
        }
        if (weaponStack.m_41720_() instanceof DragonCrystalSword) {
            return TheLastSwordConfiguration.getDragonSwordShieldMultiplierSafely();
        }
        return 0.01;
    }

    private static void removeTemporaryShield(Player player) {
        AttributeInstance healthAttr;
        UUID playerId = player.m_20148_();
        Double tempShield = TEMPORARY_SHIELDS.remove(playerId);
        if (tempShield != null && tempShield > 0.0 && (healthAttr = player.m_21051_(Attributes.f_22276_)) != null) {
            double newMaxHealth = Math.max(20.0, healthAttr.m_22115_() - tempShield);
            healthAttr.m_22100_(newMaxHealth);
            if ((double)player.m_21223_() > newMaxHealth) {
                player.m_21153_((float)newMaxHealth);
            }
        }
    }

    private static void applyCooldown(Player player, ItemStack weaponStack) {
        int cooldownTicks = WraithSummonManager.getCooldownTicks(weaponStack);
        player.m_36335_().m_41524_(weaponStack.m_41720_(), cooldownTicks);
    }

    private static int getCooldownTicks(ItemStack weaponStack) {
        if (weaponStack.m_41720_() instanceof TheLastEndSword) {
            return TheLastSwordConfiguration.getTheLastEndSwordSummonCooldownSafely();
        }
        if (weaponStack.m_41720_() instanceof DragonCrystalSword) {
            return TheLastSwordConfiguration.getDragonSwordSummonCooldownSafely();
        }
        return 1200;
    }

    @SubscribeEvent
    public static void onWraithDamage(LivingHurtEvent event) {
        try {
            if (event == null || event.getEntity() == null || event.getSource() == null) {
                return;
            }
            if (event.getEntity().m_9236_().f_46443_) {
                return;
            }
            if (event.getSource() instanceof AbsoluteDestructionDamageSource) {
                return;
            }
            Entity entity = event.getSource().m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)entity;
            if (!WraithSummonManager.isWraith(attacker)) {
                return;
            }
            if (attacker instanceof TheLastEndEntity) {
                return;
            }
            if (!TheLastSwordConfiguration.getSwordWraithAsEndEntitySafely() || !TheLastSwordConfiguration.getSwordWraithAbsoluteDestructionDamageSafely()) {
                return;
            }
            int weaponLevel = WraithSummonManager.getWraithWeaponLevel(attacker.m_20148_());
            double damageMultiplier = WraithSummonManager.calculateAbsoluteDestructionMultiplier(weaponLevel);
            if (damageMultiplier <= 0.0) {
                return;
            }
            AttributeInstance attackAttr = attacker.m_21051_(Attributes.f_22281_);
            if (attackAttr == null) {
                return;
            }
            double attackDamage = attackAttr.m_22135_();
            float absoluteDestructionDamage = (float)(attackDamage * damageMultiplier);
            if (absoluteDestructionDamage > 0.0f) {
                AbsoluteDestructionDamageSource.applyAbsoluteDestructionIntelligently(event.getEntity(), (Entity)attacker, absoluteDestructionDamage);
            }
        }
        catch (Throwable t) {
            try {
                TheLastSwordLogger.error("Wraith damage handler error", t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static double calculateAbsoluteDestructionMultiplier(int weaponLevel) {
        if (weaponLevel <= 5) {
            return TheLastSwordConfiguration.getSwordWraithAbsoluteDestructionMultiplierLowSafely();
        }
        if (weaponLevel <= 12) {
            return TheLastSwordConfiguration.getSwordWraithAbsoluteDestructionMultiplierMidSafely();
        }
        return TheLastSwordConfiguration.getSwordWraithAbsoluteDestructionMultiplierHighSafely();
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        if (++playerShieldCheckCounter < 20) {
            return;
        }
        playerShieldCheckCounter = 0;
        Player player = event.player;
        if (WraithSummonManager.hasTemporaryShield(player)) {
            boolean hasCooldown = false;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!player.m_36335_().m_41519_(stack.m_41720_())) continue;
                hasCooldown = true;
                break;
            }
            if (!hasCooldown) {
                WraithSummonManager.removeTemporaryShield(player);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEntityTick(LivingEvent.LivingTickEvent event) {
        Player owner;
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!WRAITH_RECORDS.containsKey(entity.m_20148_())) {
            return;
        }
        if (WraithSummonManager.isWraith(entity) && (owner = WraithSummonManager.getOwner(entity, entity.m_9236_())) != null) {
            WraithSummonManager.handleWraithAI(entity, owner);
        }
    }

    public static void handleWraithAI(LivingEntity wraith, Player owner) {
        if (++bossBarCleanupCounter >= 20) {
            bossBarCleanupCounter = 0;
            EntityUtil.theLastEndCleanupBossBar((Entity)wraith);
        }
        if (!(wraith instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)wraith;
        if (wraith instanceof TamableAnimal) {
            WraithSummonManager.handleTamableWraithAI(mob, owner);
            return;
        }
        WraithSummonManager.handleNonTamableWraithAI(mob, owner);
        if (wraith.f_19797_ % 100 == 0) {
            LivingEntity target = mob.m_5448_();
            TheLastSwordLogger.debug("Wraith AI Debug [{}]: Owner={}, Target={}, GoalCount={}", wraith.m_6095_().m_20676_().getString(), owner.m_7755_().getString(), target != null ? target.m_6095_().m_20676_().getString() : "None", mob.f_21345_.m_148105_().size());
        }
    }

    private static void handleTamableWraithAI(Mob wraith, Player owner) {
        LivingEntity newTarget;
        LivingEntity ownerTarget = owner.m_21214_();
        if (ownerTarget != null && ownerTarget.m_6084_() && WraithSummonManager.isValidTarget(ownerTarget, wraith, owner) && !WraithSummonManager.isSameOwnerWraith(ownerTarget, owner) && EntityUtil.shouldAttack((Entity)ownerTarget)) {
            wraith.m_6710_(ownerTarget);
            return;
        }
        LivingEntity currentTarget = wraith.m_5448_();
        if (!(currentTarget == null || WraithSummonManager.isValidTarget(currentTarget, wraith, owner) && !WraithSummonManager.isSameOwnerWraith(currentTarget, owner) && EntityUtil.shouldAttack((Entity)currentTarget))) {
            wraith.m_6710_(null);
            currentTarget = null;
        }
        if (currentTarget == null && (newTarget = WraithSummonManager.selectTarget(wraith, owner)) != null && !WraithSummonManager.isSameOwnerWraith(newTarget, owner)) {
            wraith.m_6710_(newTarget);
        }
    }

    private static void handleNonTamableWraithAI(Mob wraith, Player owner) {
        LivingEntity newTarget;
        LivingEntity ownerTarget = owner.m_21214_();
        if (ownerTarget != null && ownerTarget.m_6084_() && WraithSummonManager.isValidTarget(ownerTarget, wraith, owner) && EntityUtil.shouldAttack((Entity)ownerTarget)) {
            wraith.m_6710_(ownerTarget);
            return;
        }
        LivingEntity currentTarget = wraith.m_5448_();
        if (!(currentTarget == null || WraithSummonManager.isValidTarget(currentTarget, wraith, owner) && EntityUtil.shouldAttack((Entity)currentTarget))) {
            wraith.m_6710_(null);
            currentTarget = null;
        }
        if (currentTarget == null && (newTarget = WraithSummonManager.selectTarget(wraith, owner)) != null) {
            wraith.m_6710_(newTarget);
        }
        if (wraith.m_5448_() == null) {
            double distance = wraith.m_20270_((Entity)owner);
            if (distance > 32.0) {
                WraithSummonManager.teleportToOwner(wraith, owner);
            } else if (distance > 4.5) {
                if (wraith.m_21573_().m_26571_() || wraith.f_19797_ % 20 == 0) {
                    wraith.m_21573_().m_5624_((Entity)owner, 1.2);
                }
            } else {
                wraith.m_21573_().m_26573_();
            }
        }
    }

    private static LivingEntity selectTarget(Mob wraith, Player owner) {
        LivingEntity target = WraithSummonManager.findAttackingOwnerTarget(wraith, owner);
        if (target != null) {
            return target;
        }
        target = owner.m_21214_();
        if (target != null && target.m_6084_() && WraithSummonManager.isValidTarget(target, wraith, owner) && EntityUtil.shouldAttack((Entity)target)) {
            return target;
        }
        double followRange = wraith.m_21133_(Attributes.f_22277_);
        for (LivingEntity entity : wraith.m_9236_().m_45976_(LivingEntity.class, wraith.m_20191_().m_82400_(followRange))) {
            if (entity == wraith || !entity.m_6084_() || !WraithSummonManager.isValidTarget(entity, wraith, owner) || !EntityUtil.shouldAttack((Entity)entity)) continue;
            return entity;
        }
        return null;
    }

    private static LivingEntity findAttackingOwnerTarget(Mob wraith, Player owner) {
        for (LivingEntity entity : wraith.m_9236_().m_45976_(LivingEntity.class, wraith.m_20191_().m_82400_(16.0))) {
            Mob mob;
            if (!(entity instanceof Mob) || (mob = (Mob)entity).m_5448_() != owner || !WraithSummonManager.isValidTarget(entity, wraith, owner) || !EntityUtil.shouldAttack((Entity)entity)) continue;
            return entity;
        }
        return null;
    }

    private static boolean isValidTarget(LivingEntity target, Mob wraith, Player owner) {
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (target == owner) {
            return false;
        }
        if (target == wraith) {
            return false;
        }
        if (WraithSummonManager.isWraith(target.m_20148_())) {
            return false;
        }
        return !EntityUtil.isOwnerOrAllyOrPet((Entity)target, owner.m_20148_(), (Entity)owner);
    }

    private static boolean isSameOwnerWraith(LivingEntity target, Player owner) {
        if (!WraithSummonManager.isWraith(target)) {
            return false;
        }
        UUID targetOwnerUUID = WraithSummonManager.getOwnerUUID(target.m_20148_());
        return targetOwnerUUID != null && targetOwnerUUID.equals(owner.m_20148_());
    }

    private static void teleportToOwner(Mob wraith, Player owner) {
        Vec3 ownerPos = owner.m_20182_();
        Vec3 teleportPos = WraithSummonManager.findSafeTeleportPosition(wraith.m_9236_(), ownerPos);
        if (teleportPos != null) {
            wraith.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
        } else {
            wraith.m_6021_(ownerPos.f_82479_, ownerPos.f_82480_, ownerPos.f_82481_);
        }
    }

    private static Vec3 findSafeTeleportPosition(Level level, Vec3 centerPos) {
        for (int i = 0; i < 8; ++i) {
            double z;
            double y;
            double angle = (double)i * Math.PI / 4.0;
            double x = centerPos.f_82479_ + Math.cos(angle) * 2.0;
            if (!level.m_8055_(new BlockPos((int)x, (int)(y = centerPos.f_82480_), (int)(z = centerPos.f_82481_ + Math.sin(angle) * 2.0))).m_60795_() || !level.m_8055_(new BlockPos((int)x, (int)y + 1, (int)z)).m_60795_()) continue;
            return new Vec3(x, y, z);
        }
        return null;
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity) || !WraithSummonManager.isWraith(entity.m_20148_())) {
            return;
        }
        WraithRecord record = WRAITH_RECORDS.get(entity.m_20148_());
        if (record != null && record.isSummoned) {
            CompoundTag entityNBT = new CompoundTag();
            entity.m_20223_(entityNBT);
            record.entityNBT = entityNBT;
            record.lastSaveTime = System.currentTimeMillis();
            record.isSummoned = false;
            record.healthBonus = 0.0f;
            record.attackBonus = 0.0f;
            WraithSummonManager.markDirty();
        }
    }

    private static final class WraithRecord {
        UUID wraitheUUID;
        UUID ownerUUID;
        CompoundTag entityNBT;
        String entityType;
        ResourceKey<Level> dimension;
        boolean isSummoned;
        float healthBonus;
        float attackBonus;
        long lastSaveTime;
        boolean wasNormalRecall;
        int weaponLevel;

        WraithRecord(UUID wraitheUUID, UUID ownerUUID, CompoundTag entityNBT, String entityType) {
            this.wraitheUUID = wraitheUUID;
            this.ownerUUID = ownerUUID;
            this.entityNBT = entityNBT;
            this.entityType = entityType;
            this.isSummoned = false;
            this.healthBonus = 0.0f;
            this.attackBonus = 0.0f;
            this.lastSaveTime = System.currentTimeMillis();
            this.wasNormalRecall = false;
            this.weaponLevel = 1;
        }
    }
}

