/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.test;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.the_last_sword.attack.AbsoluteDestructionDamageSource;
import net.the_last_sword.attack.PowerfulRangeAttack;
import net.the_last_sword.capability.IMode;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.init.TheLastSwordModKeyMappings;
import net.the_last_sword.test.TestUtil;
import net.the_last_sword.util.EntityUtil;

@Mod.EventBusSubscriber(modid="the_last_sword")
public class UltraTestSwordItem
extends TieredItem {
    public UltraTestSwordItem() {
        super(new Tier(){

            public int m_6609_() {
                return 0;
            }

            public float m_6624_() {
                return 1024.0f;
            }

            public float m_6631_() {
                return 1022.0f;
            }

            public int m_6604_() {
                return 4;
            }

            public int m_6601_() {
                return 1024;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_151265_();
            }
        }, new Item.Properties().m_41486_());
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        Player player;
        if (!(entity instanceof Player) || (player = (Player)entity).m_9236_().m_5776_()) {
            return super.onEntitySwing(stack, entity);
        }
        int mode = stack.getCapability(ItemCapability.MODE_CAPABILITY).map(cap -> cap.getMode()).orElse(0);
        if (mode == 0 || mode == 1) {
            Level world = player.m_9236_();
            AABB range = player.m_20191_().m_82400_(128.0);
            List targets = world.m_6443_(LivingEntity.class, range, e -> !(e instanceof Player));
            for (LivingEntity target : targets) {
                AbsoluteDestructionDamageSource.applyAbsoluteDestructionIntelligently(target, (Entity)entity, stack, 100.0f);
            }
        }
        return super.onEntitySwing(stack, entity);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int mode = stack.getCapability(ItemCapability.MODE_CAPABILITY).map(cap -> cap.getMode()).orElse(0);
        if (!(world.f_46443_ || mode != 0 && mode != 1)) {
            ServerLevel server = (ServerLevel)world;
            Vec3 center = player.m_20182_();
            DamageSource ds = AbsoluteDestructionDamageSource.absoluteDestruction((Entity)player, stack);
            if (player.m_6144_()) {
                PowerfulRangeAttack.execute((Level)server, (Entity)player, center);
            } else {
                AABB kill = new AABB(center, center).m_82400_(128.0);
                server.m_6443_(LivingEntity.class, kill, e -> !(e instanceof Player)).forEach(t -> EntityUtil.TheLastEndSetDead(t, ds));
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.creative"));
        stack.getCapability(ItemCapability.MODE_CAPABILITY).ifPresent(cap -> {
            int mode = cap.getMode();
            String modeKey = mode == 0 ? "item_tooltip.the_last_sword.powerful_range_attack_mode" : "item_tooltip.the_last_sword.defense_mode";
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.mode").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)modeKey)));
            if (!Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.shift"));
            } else {
                String descrKey = mode == 0 ? "item_tooltip.the_last_sword.powerful_range_attack_mode_descr" : "item_tooltip.the_last_sword.defense_mode_descr";
                tooltip.add((Component)Component.m_237115_((String)descrKey).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA))));
            }
        });
        stack.getCapability(ItemCapability.Item_JUSTIFIED_DEFENCE_CAPABILITY).ifPresent(cap -> {
            double defence = cap.getDefence();
            tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.justified_defence", (Object[])new Object[]{String.format("%.0f", defence)}));
        });
        tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.ultra_test_sword"));
        tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.mode_key").m_130946_(" ").m_130946_(TheLastSwordModKeyMappings.CHANGE_SWORD_MODE.getKey().m_84875_().getString()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (!level.f_46443_ && entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            boolean isCreativeOrSpec = sp.m_7500_() || sp.m_5833_();
            boolean isOp = sp.m_20310_(2);
            if (!isCreativeOrSpec || !isOp) {
                sp.m_150109_().m_6836_(slot, ItemStack.f_41583_);
                return;
            }
            UltraTestSwordItem.manageDefenseLevel(sp);
            if (UltraTestSwordItem.hasDefenseSword((Entity)sp)) {
                TestUtil.addDefenceEntity((Entity)sp);
                TestUtil.defence((Entity)sp);
            }
        }
    }

    private static void manageDefenseLevel(ServerPlayer player) {
        int currentLevel;
        int requiredLevel = UltraTestSwordItem.getRequiredDefenseLevel((Player)player);
        boolean isTracked = DefenceManager.isTracked((LivingEntity)player);
        int n = currentLevel = isTracked ? DefenceManager.getLevel((LivingEntity)player) : 0;
        if (requiredLevel > 0) {
            if (!isTracked) {
                DefenceManager.register((LivingEntity)player, requiredLevel);
            } else if (UltraTestSwordItem.isUltraTestSwordDrivenDefense(currentLevel)) {
                if (currentLevel != requiredLevel) {
                    DefenceManager.modifyLevel(player.m_20148_(), requiredLevel);
                }
            } else if (currentLevel < requiredLevel) {
                DefenceManager.pullFromEntity((LivingEntity)player, requiredLevel);
            }
        } else if (isTracked && UltraTestSwordItem.isUltraTestSwordDrivenDefense(currentLevel)) {
            DefenceManager.clear((LivingEntity)player);
        }
    }

    private static boolean isUltraTestSwordDrivenDefense(int level) {
        return level == 2 || level == 3;
    }

    private static int getRequiredDefenseLevel(Player player) {
        if (player == null || player.f_36093_ == null) {
            return 0;
        }
        boolean hasDefenseMode = false;
        boolean hasAnyMode = false;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!(stack.m_41720_() instanceof UltraTestSwordItem)) continue;
            hasAnyMode = true;
            int mode = stack.getCapability(ItemCapability.MODE_CAPABILITY).map(IMode::getMode).orElse(0);
            if (mode != 1) continue;
            hasDefenseMode = true;
            break;
        }
        if (hasDefenseMode) {
            return 3;
        }
        if (hasAnyMode) {
            return 2;
        }
        return 0;
    }

    public static boolean hasAnyUltraTestSword(Player player) {
        return UltraTestSwordItem.getRequiredDefenseLevel(player) > 0;
    }

    public static boolean hasDefenseSword(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (player.f_36093_ == null) {
            return false;
        }
        for (ItemStack st : player.m_150109_().f_35974_) {
            int m;
            if (!(st.m_41720_() instanceof UltraTestSwordItem) || (m = st.getCapability(ItemCapability.MODE_CAPABILITY).map(IMode::getMode).orElse(0).intValue()) != 1) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onTravel(EntityTravelToDimensionEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && UltraTestSwordItem.hasDefenseSword((Entity)(player = (Player)entity))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGameMode(PlayerEvent.PlayerChangeGameModeEvent event) {
        if (UltraTestSwordItem.hasDefenseSword((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            UltraTestSwordItem.cleanupUltraTestSwordDefense(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            UltraTestSwordItem.cleanupUltraTestSwordDefense(player);
        }
    }

    private static void cleanupUltraTestSwordDefense(ServerPlayer player) {
        int currentLevel;
        if (DefenceManager.isTracked((LivingEntity)player) && UltraTestSwordItem.isUltraTestSwordDrivenDefense(currentLevel = DefenceManager.getLevel((LivingEntity)player))) {
            DefenceManager.clear((LivingEntity)player);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        if (server.m_129921_() % 100 == 0) {
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                try {
                    int requiredLevel;
                    int currentLevel;
                    if (!DefenceManager.isTracked((LivingEntity)player) || !UltraTestSwordItem.isUltraTestSwordDrivenDefense(currentLevel = DefenceManager.getLevel((LivingEntity)player)) || (requiredLevel = UltraTestSwordItem.getRequiredDefenseLevel((Player)player)) != 0) continue;
                    DefenceManager.clear((LivingEntity)player);
                }
                catch (Exception exception) {}
            }
        }
    }
}

