/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.util;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.util.EntityUtil;
import net.the_last_sword.util.TheLastSwordLogger;
import sun.misc.Unsafe;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DynamicHealthDetector {
    private static final Map<Class<?>, List<HealthFieldInfo>> stage3FieldCache = new ConcurrentHashMap();
    private static final Map<Class<?>, List<HealthFieldInfo>> stage4FieldCache = new ConcurrentHashMap();
    private static final Set<LivingEntity> detectingEntities = ConcurrentHashMap.newKeySet();
    private static final Map<LivingEntity, Set<Class<?>>> callStackClasses = new ConcurrentHashMap();
    private static final Map<String, StackTraceElement[]> globalCallStacks = new ConcurrentHashMap<String, StackTraceElement[]>();

    public static boolean tryUsingCachedFields(LivingEntity entity, float expectedHealth) {
        try {
            List<HealthFieldInfo> stage4Fields;
            Class<?> entityClass = entity.getClass();
            List<HealthFieldInfo> stage3Fields = stage3FieldCache.get(entityClass);
            if (stage3Fields != null && !stage3Fields.isEmpty()) {
                for (HealthFieldInfo healthFieldInfo : stage3Fields) {
                    DynamicHealthDetector.applyCachedHealthField(entity, healthFieldInfo, expectedHealth);
                }
                float afterHealth = entity.m_21223_();
                if (Math.abs(afterHealth - expectedHealth) <= 0.1f) {
                    return true;
                }
                stage3FieldCache.remove(entityClass);
            }
            if ((stage4Fields = stage4FieldCache.get(entityClass)) != null && !stage4Fields.isEmpty()) {
                for (HealthFieldInfo fieldInfo : stage4Fields) {
                    DynamicHealthDetector.applyCachedHealthField(entity, fieldInfo, expectedHealth);
                }
                float f = entity.m_21223_();
                if (Math.abs(f - expectedHealth) <= 0.1f) {
                    return true;
                }
                stage4FieldCache.remove(entityClass);
            }
            return false;
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Cache check exception: {}", e.getMessage(), e);
            return false;
        }
    }

    public static void handleRealHealth(LivingEntity entity, float expectedHealth) {
        if (entity == null) {
            return;
        }
        try {
            DynamicHealthDetector.waitForPassiveTrigger(entity, expectedHealth);
        }
        catch (Exception e) {
            TheLastSwordLogger.error("handleRealHealth exception: {}", e.getMessage(), e);
        }
    }

    private static void applyCachedHealthField(LivingEntity entity, HealthFieldInfo fieldInfo, float expectedHealth) {
        if (entity == null) {
            return;
        }
        try {
            if (fieldInfo.isMap()) {
                DynamicHealthDetector.applyMapHealthField(entity, (MapHealthFieldInfo)fieldInfo, expectedHealth);
            } else if (fieldInfo.isStatic()) {
                DynamicHealthDetector.applyStaticHealthField(entity, fieldInfo, expectedHealth);
            } else if (fieldInfo.isNested()) {
                DynamicHealthDetector.applyNestedHealthField(entity, fieldInfo, expectedHealth);
            } else {
                DynamicHealthDetector.applyDirectHealthField(entity, fieldInfo, expectedHealth);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyDirectHealthField(LivingEntity entity, HealthFieldInfo fieldInfo, float expectedHealth) {
        try {
            Object valueToSet = DynamicHealthDetector.convertValueToFieldType(expectedHealth, fieldInfo.healthField.getType());
            fieldInfo.healthField.set(entity, valueToSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean applyNestedHealthField(LivingEntity entity, HealthFieldInfo fieldInfo, float expectedHealth) {
        try {
            Object parentObject = fieldInfo.parentField.get(entity);
            if (parentObject == null) {
                return false;
            }
            Object valueToSet = DynamicHealthDetector.convertValueToFieldType(expectedHealth, fieldInfo.healthField.getType());
            fieldInfo.healthField.set(parentObject, valueToSet);
            float afterHealth = entity.m_21223_();
            return Math.abs(afterHealth - expectedHealth) <= 0.1f;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean applyStaticHealthField(LivingEntity entity, HealthFieldInfo fieldInfo, float expectedHealth) {
        try {
            Object valueToSet = DynamicHealthDetector.convertValueToFieldType(expectedHealth, fieldInfo.healthField.getType());
            fieldInfo.healthField.set(null, valueToSet);
            float afterHealth = entity.m_21223_();
            return Math.abs(afterHealth - expectedHealth) <= 0.1f;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void applyMapHealthField(LivingEntity entity, MapHealthFieldInfo fieldInfo, float expectedHealth) {
        try {
            Map map = (Map)fieldInfo.healthField.get(null);
            if (map == null) {
                return;
            }
            Class valueType = fieldInfo.valueType != null ? fieldInfo.valueType : Float.class;
            Object valueToSet = DynamicHealthDetector.convertValueToFieldType(expectedHealth, valueType);
            DynamicHealthDetector.unsafeModifyMapInternalValue(map, fieldInfo.mapKey, valueToSet);
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Apply map field exception: {}", e.getMessage(), e);
        }
    }

    private static void startDynamicDetection(LivingEntity entity, float expectedHealth) {
        detectingEntities.add(entity);
        callStackClasses.put(entity, ConcurrentHashMap.newKeySet());
        DynamicHealthDetector.scheduleDetectionCleanup(entity, expectedHealth);
    }

    private static void scheduleDetectionCleanup(LivingEntity entity, float expectedHealth) {
        DynamicHealthDetector.processDetectionResults(entity, expectedHealth);
    }

    private static void processDetectionResults(LivingEntity entity, float expectedHealth) {
        Set<Class<?>> recordedClasses = callStackClasses.get(entity);
        if (recordedClasses == null || recordedClasses.isEmpty()) {
            DynamicHealthDetector.searchSavedCallStacks(entity, expectedHealth);
            DynamicHealthDetector.cleanupDetection(entity);
            return;
        }
        float currentHealth = entity.m_21223_();
        ArrayList<HealthFieldInfo> allCandidates = new ArrayList<HealthFieldInfo>();
        for (Class<?> clazz : recordedClasses) {
            List<HealthFieldInfo> classCandidates = DynamicHealthDetector.findHealthFields(entity, clazz, currentHealth);
            allCandidates.addAll(classCandidates);
        }
        if (!allCandidates.isEmpty()) {
            allCandidates.sort((a, b) -> Integer.compare(a.priority, b.priority));
            stage3FieldCache.put(entity.getClass(), new ArrayList(allCandidates));
            Iterator<Class<Object>> iterator = allCandidates.iterator();
            if (iterator.hasNext()) {
                HealthFieldInfo fieldInfo = (HealthFieldInfo)((Object)iterator.next());
                DynamicHealthDetector.applyCachedHealthField(entity, fieldInfo, expectedHealth);
                DynamicHealthDetector.cleanupDetection(entity);
                return;
            }
        }
        DynamicHealthDetector.forceAdjustAllNumericFields(recordedClasses, entity, expectedHealth);
        DynamicHealthDetector.cleanupDetection(entity);
    }

    private static List<HealthFieldInfo> findHealthFields(LivingEntity entity, Class<?> targetClass, float currentHealth) {
        ArrayList<HealthFieldInfo> candidates = new ArrayList<HealthFieldInfo>();
        try {
            Field[] fields;
            for (Field field : fields = targetClass.getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    if (Modifier.isStatic(field.getModifiers())) {
                        candidates.addAll(DynamicHealthDetector.handleStaticField(entity, targetClass, field, currentHealth));
                        continue;
                    }
                    Object value = field.get(entity);
                    if (DynamicHealthDetector.isNumericField(field) && value instanceof Number) {
                        float fieldValue = ((Number)value).floatValue();
                        float difference = Math.abs(fieldValue - currentHealth);
                        if (difference <= 10.0f) {
                            candidates.add(new HealthFieldInfo(targetClass, field, 1));
                            continue;
                        }
                        if (!EntityUtil.containsHealthKeyword(field.getName())) continue;
                        candidates.add(new HealthFieldInfo(targetClass, field, 2));
                        continue;
                    }
                    if (value == null || !DynamicHealthDetector.isCustomObject(field.getType())) continue;
                    List<NestedFieldInfo> nestedCandidates = DynamicHealthDetector.searchNestedFields(value, field, currentHealth);
                    for (NestedFieldInfo nestedInfo : nestedCandidates) {
                        candidates.add(nestedInfo.toHealthFieldInfo());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            candidates.sort((a, b) -> Integer.compare(a.priority, b.priority));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return candidates;
    }

    private static List<HealthFieldInfo> handleStaticField(LivingEntity entity, Class<?> targetClass, Field field, float currentHealth) {
        ArrayList<HealthFieldInfo> candidates = new ArrayList<HealthFieldInfo>();
        try {
            Object value = field.get(null);
            if (DynamicHealthDetector.isNumericField(field) && value instanceof Number) {
                float fieldValue = ((Number)value).floatValue();
                float difference = Math.abs(fieldValue - currentHealth);
                if (difference <= 10.0f) {
                    candidates.add(new StaticHealthFieldInfo(targetClass, field, 1));
                } else if (EntityUtil.containsHealthKeyword(field.getName())) {
                    candidates.add(new StaticHealthFieldInfo(targetClass, field, 2));
                }
            } else if (value instanceof Map) {
                candidates.addAll(DynamicHealthDetector.handleMapField(entity, targetClass, field, (Map)value, currentHealth));
            } else if (value != null && DynamicHealthDetector.isCustomObject(field.getType())) {
                List<NestedFieldInfo> nestedCandidates = DynamicHealthDetector.searchNestedFields(value, field, currentHealth);
                for (NestedFieldInfo nestedInfo : nestedCandidates) {
                    candidates.add(new StaticHealthFieldInfo(targetClass, nestedInfo.childField, nestedInfo.priority, field));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return candidates;
    }

    private static List<HealthFieldInfo> handleMapField(LivingEntity entity, Class<?> targetClass, Field mapField, Map<?, ?> map, float currentHealth) {
        ArrayList<HealthFieldInfo> candidates = new ArrayList<HealthFieldInfo>();
        try {
            Object[] possibleKeys;
            for (Object key : possibleKeys = new Object[]{entity.m_20148_(), entity.m_19879_(), entity.getClass().getSimpleName(), entity.getClass().getName(), entity}) {
                float mapValue;
                float difference;
                Object value = map.get(key);
                if (!(value instanceof Number) || !((difference = Math.abs((mapValue = ((Number)value).floatValue()) - currentHealth)) <= 10.0f)) continue;
                Class<?> valueType = value.getClass();
                candidates.add(new MapHealthFieldInfo(targetClass, mapField, 1, key, valueType));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return candidates;
    }

    private static boolean isCustomObject(Class<?> type) {
        return !type.isPrimitive() && type != String.class && !type.getName().startsWith("java.") && !type.getName().startsWith("javax.") && !type.getName().startsWith("jdk.") && !type.getName().startsWith("sun.") && !type.getName().startsWith("net.minecraft") && !type.isArray() && !type.isEnum();
    }

    private static List<NestedFieldInfo> searchNestedFields(Object parentObject, Field parentField, float currentHealth) {
        ArrayList<NestedFieldInfo> nestedCandidates = new ArrayList<NestedFieldInfo>();
        try {
            Field[] nestedFields;
            Class<?> objectClass = parentObject.getClass();
            for (Field nestedField : nestedFields = objectClass.getDeclaredFields()) {
                int modifiers = nestedField.getModifiers();
                if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) || !DynamicHealthDetector.isNumericField(nestedField)) continue;
                try {
                    nestedField.setAccessible(true);
                    Object nestedValue = nestedField.get(parentObject);
                    if (!(nestedValue instanceof Number)) continue;
                    float fieldValue = ((Number)nestedValue).floatValue();
                    float difference = Math.abs(fieldValue - currentHealth);
                    if (difference <= 10.0f) {
                        nestedCandidates.add(new NestedFieldInfo(parentObject, parentField, nestedField, fieldValue, 1));
                        continue;
                    }
                    if (!EntityUtil.containsHealthKeyword(nestedField.getName())) continue;
                    nestedCandidates.add(new NestedFieldInfo(parentObject, parentField, nestedField, fieldValue, 2));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return nestedCandidates;
    }

    private static boolean isNumericField(Field field) {
        Class<?> type = field.getType();
        return type == Float.TYPE || type == Double.TYPE || type == Integer.TYPE || type == Float.class || type == Double.class || type == Integer.class;
    }

    private static Object convertValueToFieldType(float value, Class<?> fieldType) {
        if (fieldType == Float.TYPE || fieldType == Float.class) {
            return Float.valueOf(value);
        }
        if (fieldType == Double.TYPE || fieldType == Double.class) {
            return (double)value;
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return (int)value;
        }
        return Float.valueOf(value);
    }

    private static void cleanupDetection(LivingEntity entity) {
        detectingEntities.remove(entity);
        callStackClasses.remove(entity);
    }

    public static void onCustomHealthWriteWithEntity(StackTraceElement[] stackTrace, float healthValue, LivingEntity entity) {
        String entityClassName = entity.getClass().getName();
        String[] entityPackageParts = entityClassName.split("\\.");
        Object entityPackageBase = "";
        if (entityPackageParts.length >= 3) {
            entityPackageBase = entityPackageParts[0] + "." + entityPackageParts[1] + "." + entityPackageParts[2];
        }
        HashSet matchingClasses = new HashSet();
        for (StackTraceElement stackTraceElement : stackTrace) {
            String className = stackTraceElement.getClassName();
            if (className.startsWith("net.minecraft") || className.startsWith("java.") || className.startsWith("jdk.") || className.startsWith("net.the_last_sword") || className.startsWith("org.spongepowered") || className.startsWith("com.mojang") || className.startsWith("sun.") || className.startsWith("cpw.mods") || className.startsWith("net.minecraftforge") || ((String)entityPackageBase).isEmpty() || !className.startsWith((String)entityPackageBase)) continue;
            try {
                Class<?> clazz = Class.forName(className);
                matchingClasses.add(clazz);
            }
            catch (Throwable clazz) {
                // empty catch block
            }
        }
        if (!matchingClasses.isEmpty()) {
            ArrayList<HealthFieldInfo> allCandidates = new ArrayList<HealthFieldInfo>();
            float currentHealth = entity.m_21223_();
            for (Class clazz : matchingClasses) {
                List<HealthFieldInfo> classCandidates = DynamicHealthDetector.findHealthFields(entity, clazz, currentHealth);
                allCandidates.addAll(classCandidates);
            }
            if (!allCandidates.isEmpty()) {
                allCandidates.sort((a, b) -> Integer.compare(a.priority, b.priority));
                List<HealthFieldInfo> existingCache = stage3FieldCache.get(entity.getClass());
                if (existingCache != null) {
                    Set set = existingCache.stream().map(f -> f.targetClass.getName() + "." + f.healthField.getName()).collect(Collectors.toSet());
                    for (HealthFieldInfo candidate : allCandidates) {
                        String candidateKey = candidate.targetClass.getName() + "." + candidate.healthField.getName();
                        if (set.contains(candidateKey)) continue;
                        existingCache.add(candidate);
                    }
                    existingCache.sort((a, b) -> Integer.compare(a.priority, b.priority));
                } else {
                    stage3FieldCache.put(entity.getClass(), new ArrayList(allCandidates));
                }
                DynamicHealthDetector.tryApplyNewFields(entity, allCandidates, healthValue);
            } else {
                DynamicHealthDetector.forceAdjustAllNumericFields(matchingClasses, entity, healthValue);
            }
        } else {
            HashSet fallbackClasses = new HashSet();
            fallbackClasses.add(entity.getClass());
            DynamicHealthDetector.forceAdjustAllNumericFields(fallbackClasses, entity, healthValue);
        }
    }

    private static void tryApplyNewFields(LivingEntity entity, List<HealthFieldInfo> newFields, float targetHealth) {
        Iterator<HealthFieldInfo> iterator = newFields.iterator();
        if (iterator.hasNext()) {
            HealthFieldInfo fieldInfo = iterator.next();
            DynamicHealthDetector.applyCachedHealthField(entity, fieldInfo, targetHealth);
            return;
        }
    }

    public static void searchSavedCallStacks(LivingEntity entity, float expectedHealth) {
        String entityClassName = entity.getClass().getName();
        ArrayList<HealthFieldInfo> allCandidates = new ArrayList<HealthFieldInfo>();
        int analyzedStacks = 0;
        for (Map.Entry<String, StackTraceElement[]> entry : globalCallStacks.entrySet()) {
            String key = entry.getKey();
            StackTraceElement[] stackTrace = entry.getValue();
            if (!DynamicHealthDetector.isCallStackRelatedToEntity(stackTrace, entityClassName)) continue;
            ++analyzedStacks;
            List<HealthFieldInfo> stackCandidates = DynamicHealthDetector.analyzeCallStackForHealthFieldsCollection(entity, stackTrace, expectedHealth);
            allCandidates.addAll(stackCandidates);
        }
        if (analyzedStacks > 0) {
            if (!allCandidates.isEmpty()) {
                allCandidates.sort((a, b) -> Integer.compare(a.priority, b.priority));
                stage3FieldCache.put(entity.getClass(), new ArrayList(allCandidates));
                Iterator<Map.Entry<String, Object>> iterator = allCandidates.iterator();
                if (iterator.hasNext()) {
                    HealthFieldInfo fieldInfo = (HealthFieldInfo)((Object)iterator.next());
                    DynamicHealthDetector.applyCachedHealthField(entity, fieldInfo, expectedHealth);
                    return;
                }
            } else {
                fallbackClasses = new HashSet();
                fallbackClasses.add(entity.getClass());
                DynamicHealthDetector.forceAdjustAllNumericFields(fallbackClasses, entity, expectedHealth);
            }
        } else {
            fallbackClasses = new HashSet();
            fallbackClasses.add(entity.getClass());
            DynamicHealthDetector.forceAdjustAllNumericFields(fallbackClasses, entity, expectedHealth);
        }
    }

    private static boolean isCallStackRelatedToEntity(StackTraceElement[] stackTrace, String entityClassName) {
        String entitySimpleName = entityClassName.substring(entityClassName.lastIndexOf(46) + 1);
        Object entityPackageBase = "";
        String[] entityPackageParts = entityClassName.split("\\.");
        if (entityPackageParts.length >= 3) {
            entityPackageBase = entityPackageParts[0] + "." + entityPackageParts[1] + "." + entityPackageParts[2];
        }
        for (StackTraceElement element : stackTrace) {
            String className = element.getClassName();
            String classSimpleName = className.substring(className.lastIndexOf(46) + 1);
            if (className.equals(entityClassName)) {
                return true;
            }
            if (classSimpleName.equals(entitySimpleName)) {
                return true;
            }
            if (className.contains(entitySimpleName)) {
                return true;
            }
            if (((String)entityPackageBase).isEmpty() || !className.startsWith((String)entityPackageBase)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static List<HealthFieldInfo> analyzeCallStackForHealthFieldsCollection(LivingEntity entity, StackTraceElement[] stackTrace, float expectedHealth) {
        void var9_12;
        ArrayList<HealthFieldInfo> candidates = new ArrayList<HealthFieldInfo>();
        HashSet classesToAnalyze = new HashSet();
        String entityClassName = entity.getClass().getName();
        String entityPackageBase = DynamicHealthDetector.extractFirst3PackageLevels(entityClassName);
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTraceElementArray.length;
        boolean bl = false;
        while (var9_12 < n) {
            StackTraceElement element = stackTraceElementArray[var9_12];
            try {
                String className = element.getClassName();
                if (!(className.startsWith("net.minecraft") || className.startsWith("java.") || className.startsWith("jdk.") || className.startsWith("net.the_last_sword") || className.startsWith("org.spongepowered") || className.startsWith("com.mojang") || className.startsWith("sun.") || className.startsWith("cpw.mods") || className.startsWith("net.minecraftforge") || entityPackageBase.isEmpty() || !className.startsWith(entityPackageBase))) {
                    Class<?> clazz = Class.forName(className);
                    classesToAnalyze.add(clazz);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++var9_12;
        }
        float currentHealth = entity.m_21223_();
        for (Class clazz : classesToAnalyze) {
            List<HealthFieldInfo> classCandidates = DynamicHealthDetector.findHealthFields(entity, clazz, currentHealth);
            candidates.addAll(classCandidates);
        }
        return candidates;
    }

    private static String extractFirst3PackageLevels(String fullClassName) {
        String[] parts = fullClassName.split("\\.");
        if (parts.length >= 3) {
            return parts[0] + "." + parts[1] + "." + parts[2];
        }
        if (parts.length == 2) {
            return parts[0] + "." + parts[1];
        }
        if (parts.length == 1) {
            return parts[0];
        }
        return "";
    }

    private static void forceAdjustAllNumericFields(Set<Class<?>> targetClasses, LivingEntity entity, float expectedHealth) {
        float currentHealth = entity.m_21223_();
        float reduction = currentHealth - expectedHealth;
        if (Math.abs(reduction) < 0.1f) {
            return;
        }
        for (Class<?> clazz : targetClasses) {
            try {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (!DynamicHealthDetector.isNumericField(field) || !DynamicHealthDetector.isSafeToModify(field)) continue;
                    try {
                        float numValue;
                        field.setAccessible(true);
                        Object value = field.get(entity);
                        if (!(value instanceof Number) || !((numValue = ((Number)value).floatValue()) >= reduction) || !(reduction > 0.0f)) continue;
                        float newValue = numValue - reduction;
                        Object convertedValue = DynamicHealthDetector.convertValueToFieldType(newValue, field.getType());
                        field.set(entity, convertedValue);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
            }
        }
        float finalHealth = entity.m_21223_();
        if (Math.abs(finalHealth - expectedHealth) <= 0.1f) {
            // empty if block
        }
    }

    private static boolean isSafeToModify(Field field) {
        String fieldName = field.getName();
        return !EntityUtil.isInBlacklist(fieldName) && !fieldName.toLowerCase().contains("id") && !fieldName.toLowerCase().contains("uuid");
    }

    private static void waitForPassiveTrigger(LivingEntity entity, float expectedHealth) {
        try {
            DynamicHealthDetector.startDynamicDetection(entity, expectedHealth);
            float originalHealth = entity.m_21223_();
            try {
                entity.m_21153_(originalHealth);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                entity.m_21153_(originalHealth + 0.01f);
                entity.m_21153_(originalHealth);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                entity.m_5634_(0.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            float currentHealth = entity.m_21223_();
            if (Math.abs(currentHealth - expectedHealth) <= 0.1f) {
                return;
            }
            boolean unsafeEnabled = TheLastSwordConfiguration.getEnableUnsafeCodeSafely();
            boolean aggressiveEnabled = TheLastSwordConfiguration.getEnableAggressiveHealthDetectionSafely();
            if (aggressiveEnabled && unsafeEnabled) {
                DynamicHealthDetector.initiateActiveScanning(entity, expectedHealth);
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("waitForPassiveTrigger exception: {}", e.getMessage(), e);
        }
    }

    public static void initiateActiveScanning(LivingEntity entity, float expectedHealth) {
        try {
            String modId = DynamicHealthDetector.getModIdFromEntity(entity);
            Set<Class<?>> candidateClasses = DynamicHealthDetector.scanModClassesByModId(modId);
            if (!candidateClasses.isEmpty()) {
                ArrayList<HealthFieldInfo> allCandidates = new ArrayList<HealthFieldInfo>();
                for (Class<?> clazz : candidateClasses) {
                    List<HealthFieldInfo> classCandidates = DynamicHealthDetector.findHealthFields(entity, clazz, entity.m_21223_());
                    allCandidates.addAll(classCandidates);
                }
                if (!allCandidates.isEmpty()) {
                    allCandidates.sort((a, b) -> Integer.compare(a.priority, b.priority));
                    stage4FieldCache.put(entity.getClass(), new ArrayList(allCandidates));
                    for (HealthFieldInfo fieldInfo : allCandidates) {
                        DynamicHealthDetector.applyCachedHealthField(entity, fieldInfo, expectedHealth);
                    }
                }
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("initiateActiveScanning exception: {}", e.getMessage(), e);
        }
    }

    private static String getModIdFromEntity(LivingEntity entity) {
        String[] parts;
        try {
            EntityType entityType = entity.m_6095_();
            ResourceLocation registryName = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType);
            if (registryName != null) {
                return registryName.m_135827_();
            }
        }
        catch (Exception entityType) {
            // empty catch block
        }
        String className = entity.getClass().getName();
        if (className.contains(".") && (parts = className.split("\\.")).length >= 2) {
            String inferredModId = parts[1];
            return inferredModId;
        }
        return "unknown";
    }

    private static Set<Class<?>> scanModClassesByModId(String modId) {
        HashSet candidateClasses = new HashSet();
        String[] keywords = new String[]{"manager", "util", "data", "handler", "health", "hp", "life", "storage", "map", "container"};
        try {
            ModContainer modContainer = ModList.get().getModContainerById(modId).orElse(null);
            if (modContainer != null) {
                DynamicHealthDetector.scanAllModClassesByKeywords(modId, keywords, candidateClasses);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return candidateClasses;
    }

    private static void scanAllModClassesByKeywords(String modId, String[] keywords, Set<Class<?>> candidateClasses) {
        try {
            Set<Class<?>> modClasses = DynamicHealthDetector.getModClassesByModContainer(modId);
            for (Class<?> clazz : modClasses) {
                String className = clazz.getName();
                if (!DynamicHealthDetector.containsAnyKeyword(className, keywords)) continue;
                candidateClasses.add(clazz);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean containsAnyKeyword(String className, String[] keywords) {
        String lowerClassName = className.toLowerCase();
        for (String keyword : keywords) {
            if (!lowerClassName.contains(keyword.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static Set<Class<?>> getAllLoadedClassesFromPackage(String packagePrefix, String modId) {
        HashSet classes = new HashSet();
        try {
            ModContainer modContainer = ModList.get().getModContainerById(modId).orElse(null);
            if (modContainer == null) {
                return classes;
            }
            IModInfo modInfo = modContainer.getModInfo();
            IModFile modFile = modInfo.getOwningFile().getFile();
            Path jarPath = modFile.getFilePath();
            if (Files.isDirectory(jarPath, new LinkOption[0])) {
                classes.addAll(DynamicHealthDetector.scanClassesFromDirectory(jarPath, packagePrefix));
            } else {
                classes.addAll(DynamicHealthDetector.scanClassesFromJar(jarPath, packagePrefix));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classes;
    }

    private static Set<Class<?>> scanClassesFromJar(Path jarPath, String packagePrefix) {
        HashSet classes = new HashSet();
        try (JarFile jar = new JarFile(jarPath.toFile());){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String className;
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class") || !(className = entryName.replace('/', '.').substring(0, entryName.length() - 6)).startsWith(packagePrefix) || className.contains(".mixin.") || className.endsWith(".mixin") || className.contains("$")) continue;
                try {
                    Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                    classes.add(clazz);
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classes;
    }

    private static Set<Class<?>> scanClassesFromDirectory(Path directory, String packagePrefix) {
        HashSet classes = new HashSet();
        try {
            String packagePath = packagePrefix.replace('.', '/');
            Path packageDir = directory.resolve(packagePath);
            if (!Files.exists(packageDir, new LinkOption[0])) {
                return classes;
            }
            Files.walk(packageDir, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".class")).forEach(path -> {
                try {
                    Path relativePath = directory.relativize((Path)path);
                    String className = relativePath.toString().replace(File.separatorChar, '.').substring(0, relativePath.toString().length() - 6);
                    if (className.startsWith(packagePrefix)) {
                        if (className.contains(".mixin.") || className.endsWith(".mixin")) {
                            return;
                        }
                        if (className.contains("$")) {
                            return;
                        }
                        Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                        classes.add(clazz);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classes;
    }

    private static Set<Class<?>> getModClassesByModContainer(String modId) {
        HashSet modClasses = new HashSet();
        try {
            Object modInstance;
            ModContainer modContainer = ModList.get().getModContainerById(modId).orElse(null);
            if (modContainer != null && (modInstance = modContainer.getMod()) != null) {
                Class<?> modClass = modInstance.getClass();
                String modPackageBase = modClass.getPackage().getName();
                modClasses.addAll(DynamicHealthDetector.getAllLoadedClassesFromPackage(modPackageBase, modId));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modClasses;
    }

    private static Unsafe getUnsafeInstance() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean unsafeModifyMapInternalValue(Map<Object, Object> map, Object key, Object newValue) {
        try {
            if (!TheLastSwordConfiguration.getEnableUnsafeCodeSafely()) {
                return false;
            }
            Unsafe unsafe = DynamicHealthDetector.getUnsafeInstance();
            if (unsafe == null) {
                return false;
            }
            Field tableField = null;
            for (Class<?> mapClass = map.getClass(); mapClass != null && mapClass != Object.class; mapClass = mapClass.getSuperclass()) {
                try {
                    tableField = mapClass.getDeclaredField("table");
                    break;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
            if (tableField == null) {
                return false;
            }
            long tableOffset = unsafe.objectFieldOffset(tableField);
            Object[] table = (Object[])unsafe.getObject(map, tableOffset);
            if (table == null || table.length == 0) {
                return false;
            }
            block7: for (int i = 0; i < table.length; ++i) {
                Object entry = table[i];
                while (entry != null) {
                    try {
                        Object entryKey = DynamicHealthDetector.getEntryKey(entry, unsafe);
                        if (key.equals(entryKey) || key == entryKey) {
                            Class<?> newType;
                            Class<?> oldType;
                            Field valueField = entry.getClass().getDeclaredField("value");
                            long valueOffset = unsafe.objectFieldOffset(valueField);
                            Object oldValue = unsafe.getObject(entry, valueOffset);
                            if (oldValue != null && newValue != null && !DynamicHealthDetector.isTypeCompatible(oldType = oldValue.getClass(), newType = newValue.getClass())) {
                                return false;
                            }
                            unsafe.putObject(entry, valueOffset, newValue);
                            return true;
                        }
                        entry = DynamicHealthDetector.getNextEntry(entry, unsafe);
                    }
                    catch (Exception e) {
                        // empty catch block
                        continue block7;
                    }
                }
            }
            return false;
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Unsafe modify map exception: {}", e.getMessage(), e);
            return false;
        }
    }

    private static boolean isTypeCompatible(Class<?> oldType, Class<?> newType) {
        if (oldType == newType) {
            return true;
        }
        return Number.class.isAssignableFrom(oldType) && Number.class.isAssignableFrom(newType);
    }

    private static Object getEntryKey(Object entry, Unsafe unsafe) throws Exception {
        try {
            Field keyField = entry.getClass().getDeclaredField("key");
            long keyOffset = unsafe.objectFieldOffset(keyField);
            return unsafe.getObject(entry, keyOffset);
        }
        catch (NoSuchFieldException e) {
            for (Class<?> clazz = entry.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    Field refField = clazz.getDeclaredField("referent");
                    long refOffset = unsafe.objectFieldOffset(refField);
                    return unsafe.getObject(entry, refOffset);
                }
                catch (NoSuchFieldException e2) {
                    continue;
                }
            }
            return null;
        }
    }

    private static Object getNextEntry(Object entry, Unsafe unsafe) throws Exception {
        try {
            Field nextField = entry.getClass().getDeclaredField("next");
            long nextOffset = unsafe.objectFieldOffset(nextField);
            return unsafe.getObject(entry, nextOffset);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static void clearWorldCaches() {
        stage3FieldCache.clear();
        stage4FieldCache.clear();
        detectingEntities.clear();
        callStackClasses.clear();
        globalCallStacks.clear();
    }

    public static void clearAllCaches() {
        stage3FieldCache.clear();
        stage4FieldCache.clear();
        detectingEntities.clear();
        callStackClasses.clear();
        globalCallStacks.clear();
    }

    private static class HealthFieldInfo {
        public final Class<?> targetClass;
        public final Field healthField;
        public final int priority;
        public final Field parentField;
        public final int sourceStage;

        public HealthFieldInfo(Class<?> targetClass, Field healthField, int priority) {
            this(targetClass, healthField, priority, null, 0);
        }

        public HealthFieldInfo(Class<?> targetClass, Field healthField, int priority, Field parentField) {
            this(targetClass, healthField, priority, parentField, 0);
        }

        public HealthFieldInfo(Class<?> targetClass, Field healthField, int priority, Field parentField, int sourceStage) {
            this.targetClass = targetClass;
            this.healthField = healthField;
            this.priority = priority;
            this.parentField = parentField;
            this.sourceStage = sourceStage;
            this.healthField.setAccessible(true);
            if (this.parentField != null) {
                this.parentField.setAccessible(true);
            }
        }

        public boolean isNested() {
            return this.parentField != null;
        }

        public boolean isStatic() {
            return false;
        }

        public boolean isMap() {
            return false;
        }
    }

    private static class MapHealthFieldInfo
    extends HealthFieldInfo {
        public final Object mapKey;
        public final Class<?> valueType;

        public MapHealthFieldInfo(Class<?> targetClass, Field mapField, int priority, Object mapKey, Class<?> valueType) {
            super(targetClass, mapField, priority, null, 0);
            this.mapKey = mapKey;
            this.valueType = valueType;
        }

        public MapHealthFieldInfo(Class<?> targetClass, Field mapField, int priority, Object mapKey, Class<?> valueType, int sourceStage) {
            super(targetClass, mapField, priority, null, sourceStage);
            this.mapKey = mapKey;
            this.valueType = valueType;
        }

        @Override
        public boolean isMap() {
            return true;
        }
    }

    private static class NestedFieldInfo {
        public final Object parentObject;
        public final Field parentField;
        public final Field childField;
        public final float value;
        public final int priority;

        public NestedFieldInfo(Object parentObject, Field parentField, Field childField, float value, int priority) {
            this.parentObject = parentObject;
            this.parentField = parentField;
            this.childField = childField;
            this.value = value;
            this.priority = priority;
        }

        public HealthFieldInfo toHealthFieldInfo() {
            return new HealthFieldInfo(this.parentObject.getClass(), this.childField, this.priority, this.parentField);
        }
    }

    private static class StaticHealthFieldInfo
    extends HealthFieldInfo {
        public StaticHealthFieldInfo(Class<?> targetClass, Field healthField, int priority) {
            super(targetClass, healthField, priority, null, 0);
        }

        public StaticHealthFieldInfo(Class<?> targetClass, Field healthField, int priority, Field parentField) {
            super(targetClass, healthField, priority, parentField, 0);
        }

        public StaticHealthFieldInfo(Class<?> targetClass, Field healthField, int priority, Field parentField, int sourceStage) {
            super(targetClass, healthField, priority, parentField, sourceStage);
        }

        @Override
        public boolean isStatic() {
            return true;
        }
    }
}

