/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class RecipeJsonGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void generateDragonCrystalSmithingRecipe(File outputDir, String recipeName, String templateItem, String inputItem, int inputLevel, String additionItem, String resultItem, int resultLevel) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "the_last_sword:dragon_crystal_smithing");
        JsonObject template = new JsonObject();
        template.addProperty("item", templateItem);
        json.add("template", (JsonElement)template);
        JsonObject input = new JsonObject();
        input.addProperty("item", inputItem);
        json.add("input", (JsonElement)input);
        json.addProperty("inputLevel", (Number)inputLevel);
        JsonObject addition = new JsonObject();
        addition.addProperty("item", additionItem);
        json.add("addition", (JsonElement)addition);
        JsonObject result = new JsonObject();
        result.addProperty("item", resultItem);
        result.addProperty("level", (Number)resultLevel);
        json.add("result", (JsonElement)result);
        File outputFile = new File(outputDir, recipeName + ".json");
        try (FileWriter writer = new FileWriter(outputFile);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        File outputDir = new File("D:\\Game\\minecraft\\ModProject\\Forge\\TheLastEndSword\\src\\main\\resources\\data\\the_last_sword\\upgrade_recipes");
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String templateItem = "the_last_sword:dragon_crystal_upgrade_template";
        String dragonCrystalSword = "the_last_sword:dragon_crystal_sword";
        String dragonSword = "the_last_sword:dragon_sword";
        String theLastSword = "the_last_sword:the_last_sword";
        String dragonCrystalHelmet = "the_last_sword:dragon_crystal_armor_helmet";
        String dragonCrystalChestplate = "the_last_sword:dragon_crystal_armor_chestplate";
        String dragonCrystalLeggings = "the_last_sword:dragon_crystal_armor_leggings";
        String dragonCrystalBoots = "the_last_sword:dragon_crystal_armor_boots";
        String dragonEgg = "minecraft:dragon_egg";
        String dragonCrystal = "the_last_sword:dragon_crystal";
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_level_0", templateItem, dragonCrystalSword, 0, dragonEgg, dragonCrystalSword, 1);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_level_1", templateItem, dragonCrystalSword, 1, dragonEgg, dragonCrystalSword, 2);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_level_2", templateItem, dragonCrystalSword, 2, dragonEgg, dragonCrystalSword, 3);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_level_3", templateItem, dragonCrystalSword, 3, dragonEgg, dragonCrystalSword, 4);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_level_4", templateItem, dragonCrystalSword, 4, dragonEgg, dragonCrystalSword, 5);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_level_5", templateItem, dragonCrystalSword, 5, dragonEgg, dragonSword, 6);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_level_6", templateItem, dragonSword, 6, dragonEgg, dragonSword, 7);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_level_7", templateItem, dragonSword, 7, dragonEgg, dragonSword, 8);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_level_8", templateItem, dragonSword, 8, dragonEgg, dragonSword, 9);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_level_9", templateItem, dragonSword, 9, dragonEgg, dragonSword, 10);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_level_10", templateItem, dragonSword, 10, dragonEgg, dragonSword, 11);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_level_11", templateItem, dragonSword, 11, dragonEgg, dragonSword, 12);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_level_12", templateItem, dragonSword, 12, dragonEgg, theLastSword, 13);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_0_helmet", templateItem, dragonCrystalHelmet, 0, dragonCrystal, dragonCrystalHelmet, 1);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_1_helmet", templateItem, dragonCrystalHelmet, 1, dragonCrystal, dragonCrystalHelmet, 2);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_2_helmet", templateItem, dragonCrystalHelmet, 2, dragonCrystal, dragonCrystalHelmet, 3);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_3_helmet", templateItem, dragonCrystalHelmet, 3, dragonCrystal, dragonCrystalHelmet, 4);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_4_helmet", templateItem, dragonCrystalHelmet, 4, dragonCrystal, dragonCrystalHelmet, 5);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_0_chestplate", templateItem, dragonCrystalChestplate, 0, dragonCrystal, dragonCrystalChestplate, 1);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_1_chestplate", templateItem, dragonCrystalChestplate, 1, dragonCrystal, dragonCrystalChestplate, 2);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_2_chestplate", templateItem, dragonCrystalChestplate, 2, dragonCrystal, dragonCrystalChestplate, 3);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_3_chestplate", templateItem, dragonCrystalChestplate, 3, dragonCrystal, dragonCrystalChestplate, 4);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_4_chestplate", templateItem, dragonCrystalChestplate, 4, dragonCrystal, dragonCrystalChestplate, 5);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_0_leggings", templateItem, dragonCrystalLeggings, 0, dragonCrystal, dragonCrystalLeggings, 1);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_1_leggings", templateItem, dragonCrystalLeggings, 1, dragonCrystal, dragonCrystalLeggings, 2);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_2_leggings", templateItem, dragonCrystalLeggings, 2, dragonCrystal, dragonCrystalLeggings, 3);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_3_leggings", templateItem, dragonCrystalLeggings, 3, dragonCrystal, dragonCrystalLeggings, 4);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_4_leggings", templateItem, dragonCrystalLeggings, 4, dragonCrystal, dragonCrystalLeggings, 5);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_0_boots", templateItem, dragonCrystalBoots, 0, dragonCrystal, dragonCrystalBoots, 1);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_1_boots", templateItem, dragonCrystalBoots, 1, dragonCrystal, dragonCrystalBoots, 2);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_2_boots", templateItem, dragonCrystalBoots, 2, dragonCrystal, dragonCrystalBoots, 3);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_3_boots", templateItem, dragonCrystalBoots, 3, dragonCrystal, dragonCrystalBoots, 4);
        RecipeJsonGenerator.generateDragonCrystalSmithingRecipe(outputDir, "dragon_crystal_smithing_armor_level_4_boots", templateItem, dragonCrystalBoots, 4, dragonCrystal, dragonCrystalBoots, 5);
    }
}

