/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ReflectionMappings {
    public static final String MINECRAFT_VERSION = "1.20.1";
    public static final String FORGE_VERSION = "47.2.0";
    private static final Map<String, Field> FIELD_CACHE = new ConcurrentHashMap<String, Field>();
    private static final Map<String, Method> METHOD_CACHE = new ConcurrentHashMap<String, Method>();
    private static final Map<String, Map<String, String>> FIELD_MAPPINGS = new HashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> METHOD_MAPPINGS;

    public static Field getField(Class<?> clazz, String fieldKey) {
        String cacheKey = clazz.getName() + "." + fieldKey;
        return FIELD_CACHE.computeIfAbsent(cacheKey, k -> {
            try {
                String currentVersion = "1.20.1-47.2.0";
                Map<String, String> mappings = FIELD_MAPPINGS.get(currentVersion);
                if (mappings == null) {
                    throw new RuntimeException("No field mappings found for version: " + currentVersion);
                }
                String obfuscatedName = mappings.get(fieldKey);
                if (obfuscatedName == null) {
                    throw new RuntimeException("No mapping found for field: " + fieldKey);
                }
                Field field = ObfuscationReflectionHelper.findField((Class)clazz, (String)obfuscatedName);
                field.setAccessible(true);
                return field;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get field: " + fieldKey + " for class: " + clazz.getName(), e);
            }
        });
    }

    public static Method getMethod(Class<?> clazz, String methodKey, Class<?> ... parameterTypes) {
        String cacheKey = clazz.getName() + "." + methodKey + "_" + Arrays.toString(parameterTypes);
        return METHOD_CACHE.computeIfAbsent(cacheKey, k -> {
            try {
                String currentVersion = "1.20.1-47.2.0";
                Map<String, String> mappings = METHOD_MAPPINGS.get(currentVersion);
                if (mappings == null) {
                    throw new RuntimeException("No method mappings found for version: " + currentVersion);
                }
                String obfuscatedName = mappings.get(methodKey);
                if (obfuscatedName == null) {
                    throw new RuntimeException("No mapping found for method: " + methodKey);
                }
                Method method = ObfuscationReflectionHelper.findMethod((Class)clazz, (String)obfuscatedName, (Class[])parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get method: " + methodKey + " for class: " + clazz.getName(), e);
            }
        });
    }

    public static void setField(Object target, Class<?> clazz, String fieldKey, Object value) {
        try {
            Field field = ReflectionMappings.getField(clazz, fieldKey);
            field.set(target, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set field: " + fieldKey, e);
        }
    }

    public static <T> T getFieldValue(Object target, Class<?> clazz, String fieldKey) {
        try {
            Field field = ReflectionMappings.getField(clazz, fieldKey);
            return (T)field.get(target);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get field: " + fieldKey, e);
        }
    }

    public static <T> T invokeMethod(Object target, Class<?> clazz, String methodKey, Object ... args) {
        try {
            Class[] paramTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                paramTypes[i] = args[i].getClass();
            }
            Method method = ReflectionMappings.getMethod(clazz, methodKey, paramTypes);
            return (T)method.invoke(target, args);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke method: " + methodKey, e);
        }
    }

    static {
        HashMap<String, String> v1_20_1_mappings = new HashMap<String, String>();
        v1_20_1_mappings.put("Entity.entityData", "f_19804_");
        v1_20_1_mappings.put("Entity.position", "f_19790_");
        v1_20_1_mappings.put("Entity.bb", "f_19791_");
        v1_20_1_mappings.put("Entity.blockPosition", "f_19792_");
        v1_20_1_mappings.put("Entity.chunkPosition", "f_19793_");
        v1_20_1_mappings.put("Entity.xOld", "f_19859_");
        v1_20_1_mappings.put("Entity.yOld", "f_19860_");
        v1_20_1_mappings.put("Entity.zOld", "f_19861_");
        v1_20_1_mappings.put("Entity.xRot", "f_19811_");
        v1_20_1_mappings.put("Entity.yRot", "f_19812_");
        v1_20_1_mappings.put("Entity.xRotO", "f_19813_");
        v1_20_1_mappings.put("Entity.yRotO", "f_19814_");
        v1_20_1_mappings.put("Entity.levelCallback", "f_146801_");
        v1_20_1_mappings.put("Entity.removalReason", "f_146909_");
        v1_20_1_mappings.put("Entity.passengers", "f_19800_");
        v1_20_1_mappings.put("LivingEntity.hurtTime", "f_20915_");
        v1_20_1_mappings.put("LivingEntity.hurtDuration", "f_20916_");
        v1_20_1_mappings.put("LivingEntity.deathTime", "f_20919_");
        v1_20_1_mappings.put("LivingEntity.lastHurtByPlayerTime", "f_20919_");
        v1_20_1_mappings.put("LivingEntity.lastHurtByMobTimestamp", "f_20922_");
        v1_20_1_mappings.put("LivingEntity.dead", "f_20890_");
        v1_20_1_mappings.put("LivingEntity.lastHurtByPlayer", "f_20918_");
        v1_20_1_mappings.put("LivingEntity.lastHurtByMob", "f_20921_");
        v1_20_1_mappings.put("LivingEntity.lastDamageSource", "f_20923_");
        v1_20_1_mappings.put("LivingEntity.lastDamageStamp", "f_20924_");
        v1_20_1_mappings.put("LivingEntity.DATA_HEALTH_ID", "f_20961_");
        v1_20_1_mappings.put("SynchedEntityData.itemsById", "f_135345_");
        v1_20_1_mappings.put("SynchedEntityData.isDirty", "f_135348_");
        v1_20_1_mappings.put("DataItem.value", "f_135391_");
        v1_20_1_mappings.put("DataItem.dirty", "f_135392_");
        FIELD_MAPPINGS.put("1.20.1-47.2.0", v1_20_1_mappings);
        METHOD_MAPPINGS = new HashMap<String, Map<String, String>>();
        HashMap<String, String> v1_20_1_methods = new HashMap<String, String>();
        v1_20_1_methods.put("LivingEntity.dropAllDeathLoot", "m_6668_");
        v1_20_1_methods.put("LivingEntity.getMaxHealth", "m_21233_");
        v1_20_1_methods.put("LivingEntity.actuallyHurt", "m_6475_");
        v1_20_1_methods.put("Entity.setRemoved", "m_142467_");
        METHOD_MAPPINGS.put("1.20.1-47.2.0", v1_20_1_methods);
    }

    public static class SynchedEntityDataFields {
        public static Map<Integer, SynchedEntityData.DataItem<?>> getItemsById(SynchedEntityData data) {
            return (Map)ReflectionMappings.getFieldValue(data, SynchedEntityData.class, "SynchedEntityData.itemsById");
        }

        public static void setDirty(SynchedEntityData data, boolean value) {
            ReflectionMappings.setField(data, SynchedEntityData.class, "SynchedEntityData.isDirty", value);
        }

        public static void setDataItemValue(SynchedEntityData.DataItem<?> item, Object value) {
            ReflectionMappings.setField(item, SynchedEntityData.DataItem.class, "DataItem.value", value);
        }

        public static Object getDataItemValue(SynchedEntityData.DataItem<?> item) {
            return ReflectionMappings.getFieldValue(item, SynchedEntityData.DataItem.class, "DataItem.value");
        }

        public static void setDataItemDirty(SynchedEntityData.DataItem<?> item, boolean value) {
            ReflectionMappings.setField(item, SynchedEntityData.DataItem.class, "DataItem.dirty", value);
        }
    }

    public static class LivingEntityFields {
        public static void setDeathTime(LivingEntity entity, int value) {
            ReflectionMappings.setField(entity, LivingEntity.class, "LivingEntity.deathTime", value);
        }

        public static void setDead(LivingEntity entity, boolean value) {
            ReflectionMappings.setField(entity, LivingEntity.class, "LivingEntity.dead", value);
        }

        public static int getDeathTime(LivingEntity entity) {
            return (Integer)ReflectionMappings.getFieldValue(entity, LivingEntity.class, "LivingEntity.deathTime");
        }

        public static boolean isDead(LivingEntity entity) {
            return (Boolean)ReflectionMappings.getFieldValue(entity, LivingEntity.class, "LivingEntity.dead");
        }
    }

    public static class EntityFields {
        public static Object getLevelCallback(Entity entity) {
            return ReflectionMappings.getFieldValue(entity, Entity.class, "Entity.levelCallback");
        }

        public static void setLevelCallback(Entity entity, Object callback) {
            ReflectionMappings.setField(entity, Entity.class, "Entity.levelCallback", callback);
        }
    }
}

