/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.the_last_sword.util.ReflectionMappings;
import net.the_last_sword.util.TheLastSwordLogger;
import sun.misc.Unsafe;

public final class UnsafeUtil {
    private static final Unsafe UNSAFE;

    private UnsafeUtil() {
    }

    private static long getFieldOffset(Class<?> clazz, String fieldKey) {
        try {
            Field field = ReflectionMappings.getField(clazz, fieldKey);
            return UNSAFE.objectFieldOffset(field);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get field offset: " + fieldKey, e);
        }
    }

    private static int getVanillaHealthDataId() {
        return LivingEntity.f_20961_.m_135015_();
    }

    public static boolean setDoubleField(Object target, Field field, double value) {
        if (target == null || field == null) {
            return false;
        }
        try {
            long offset = UNSAFE.objectFieldOffset(field);
            UNSAFE.putDouble(target, offset, value);
            return true;
        }
        catch (Throwable t) {
            try {
                field.setAccessible(true);
                field.setDouble(target, value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static boolean setFloatField(Object target, Field field, float value) {
        if (target == null || field == null) {
            return false;
        }
        try {
            long offset = UNSAFE.objectFieldOffset(field);
            UNSAFE.putFloat(target, offset, value);
            return true;
        }
        catch (Throwable t) {
            try {
                field.setAccessible(true);
                field.setFloat(target, value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static boolean setIntField(Object target, Field field, int value) {
        if (target == null || field == null) {
            return false;
        }
        try {
            long offset = UNSAFE.objectFieldOffset(field);
            UNSAFE.putInt(target, offset, value);
            return true;
        }
        catch (Throwable t) {
            try {
                field.setAccessible(true);
                field.setInt(target, value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static boolean UnsafeSetHealth(LivingEntity entity, float health) {
        if (entity == null) {
            return false;
        }
        try {
            return UnsafeUtil.setEntityHealthDirect(entity, health);
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeSetHealth failed: {}", t.getMessage());
            return false;
        }
    }

    public static Float UnsafeGetHealth(LivingEntity entity) {
        if (entity == null) {
            return null;
        }
        try {
            return UnsafeUtil.getEntityHealthDirect(entity);
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeGetHealth failed: {}", t.getMessage());
            return null;
        }
    }

    private static boolean setEntityHealthDirect(LivingEntity entity, float health) {
        if (entity == null) {
            return false;
        }
        try {
            EntityDataSerializer serializer;
            long entityDataOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.entityData");
            Object synchedData = UNSAFE.getObject(entity, entityDataOffset);
            if (synchedData == null) {
                return false;
            }
            long itemsByIdOffset = UnsafeUtil.getFieldOffset(SynchedEntityData.class, "SynchedEntityData.itemsById");
            Object itemsMap = UNSAFE.getObject(synchedData, itemsByIdOffset);
            if (itemsMap == null) {
                return false;
            }
            int vanillaHealthId = UnsafeUtil.getVanillaHealthDataId();
            Object dataItem = UnsafeUtil.getMapEntry(itemsMap, vanillaHealthId);
            if (dataItem == null) {
                return false;
            }
            Class<?> dataItemClass = dataItem.getClass();
            long valueOffset = UnsafeUtil.getFieldOffset(dataItemClass, "DataItem.value");
            Object currentValue = UNSAFE.getObject(dataItem, valueOffset);
            if (!(currentValue instanceof Float)) {
                TheLastSwordLogger.error("Health DataItem value type mismatch: expected Float, got {}", currentValue != null ? currentValue.getClass().getSimpleName() : "null");
                return false;
            }
            long accessorOffset = UnsafeUtil.getFieldOffset(dataItemClass, "DataItem.accessor");
            Object accessor = UNSAFE.getObject(dataItem, accessorOffset);
            if (accessor instanceof EntityDataAccessor && (serializer = ((EntityDataAccessor)accessor).m_135016_()) != EntityDataSerializers.f_135029_) {
                TheLastSwordLogger.error("Health DataItem serializer type mismatch: expected FLOAT, got {}", serializer.getClass().getSimpleName());
                return false;
            }
            long dataItemDirtyOffset = UnsafeUtil.getFieldOffset(dataItemClass, "DataItem.dirty");
            UNSAFE.putObject(dataItem, valueOffset, Float.valueOf(health));
            UNSAFE.putBoolean(dataItem, dataItemDirtyOffset, true);
            long synchedDirtyOffset = UnsafeUtil.getFieldOffset(SynchedEntityData.class, "SynchedEntityData.isDirty");
            UNSAFE.putBoolean(synchedData, synchedDirtyOffset, true);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static Float getEntityHealthDirect(LivingEntity entity) {
        if (entity == null) {
            return null;
        }
        try {
            long entityDataOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.entityData");
            Object synchedData = UNSAFE.getObject(entity, entityDataOffset);
            if (synchedData == null) {
                return null;
            }
            long itemsByIdOffset = UnsafeUtil.getFieldOffset(SynchedEntityData.class, "SynchedEntityData.itemsById");
            Object itemsMap = UNSAFE.getObject(synchedData, itemsByIdOffset);
            if (itemsMap == null) {
                return null;
            }
            int vanillaHealthId = UnsafeUtil.getVanillaHealthDataId();
            Object dataItem = UnsafeUtil.getMapEntry(itemsMap, vanillaHealthId);
            if (dataItem == null) {
                return null;
            }
            Class<?> dataItemClass = dataItem.getClass();
            long valueOffset = UnsafeUtil.getFieldOffset(dataItemClass, "DataItem.value");
            Object value = UNSAFE.getObject(dataItem, valueOffset);
            return value instanceof Float ? (Float)value : null;
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("Failed to get health directly: " + t.getMessage());
            return null;
        }
    }

    public static boolean UnsafeTeleport(Entity entity, double x, double y, double z) {
        if (entity == null) {
            return false;
        }
        return UnsafeUtil.UnsafeTeleport(entity, x, y, z, entity.m_146908_(), entity.m_146909_());
    }

    public static boolean UnsafeTeleport(Entity entity, double x, double y, double z, float yaw, float pitch) {
        if (entity == null) {
            return false;
        }
        try {
            Level level;
            long positionOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.position");
            long xOldOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.xOld");
            long yOldOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.yOld");
            long zOldOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.zOld");
            long yRotOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.yRot");
            long xRotOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.xRot");
            long yRotOldOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.yRotO");
            long xRotOldOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.xRotO");
            long blockPosOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.blockPosition");
            long chunkPosOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.chunkPosition");
            long bbOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.bb");
            Vec3 newPosition = new Vec3(x, y, z);
            UNSAFE.putObject(entity, positionOffset, newPosition);
            UNSAFE.putDouble(entity, xOldOffset, x);
            UNSAFE.putDouble(entity, yOldOffset, y);
            UNSAFE.putDouble(entity, zOldOffset, z);
            UNSAFE.putFloat(entity, yRotOffset, yaw);
            UNSAFE.putFloat(entity, xRotOffset, pitch);
            UNSAFE.putFloat(entity, yRotOldOffset, yaw);
            UNSAFE.putFloat(entity, xRotOldOffset, pitch);
            BlockPos newBlockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            ChunkPos newChunkPos = new ChunkPos(newBlockPos);
            UNSAFE.putObject(entity, blockPosOffset, newBlockPos);
            UNSAFE.putObject(entity, chunkPosOffset, newChunkPos);
            AABB newBoundingBox = entity.m_6972_(entity.m_20089_()).m_20384_(x, y, z);
            UNSAFE.putObject(entity, bbOffset, newBoundingBox);
            if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                UnsafeUtil.syncTeleportToClients(entity, serverLevel, x, y, z, yaw, pitch);
            }
            return true;
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("Unsafe Teleport failed: {}", t.getMessage());
            return false;
        }
    }

    private static void syncTeleportToClients(Entity entity, ServerLevel serverLevel, double x, double y, double z, float yaw, float pitch) {
        if (entity == null) {
            return;
        }
        try {
            ClientboundTeleportEntityPacket teleportPacket = new ClientboundTeleportEntityPacket(entity);
            serverLevel.m_7726_().m_8445_(entity, (Packet)teleportPacket);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.f_8906_.m_9774_(x, y, z, yaw, pitch);
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Failed to sync teleport to clients: " + e.getMessage());
        }
    }

    public static boolean UnsafeSetDead(LivingEntity entity, DamageSource damageSource) {
        if (entity == null) {
            return false;
        }
        try {
            Level level;
            long deadOffset = UnsafeUtil.getFieldOffset(LivingEntity.class, "LivingEntity.dead");
            long hurtTimeOffset = UnsafeUtil.getFieldOffset(LivingEntity.class, "LivingEntity.hurtTime");
            long hurtDurationOffset = UnsafeUtil.getFieldOffset(LivingEntity.class, "LivingEntity.hurtDuration");
            UNSAFE.putBoolean(entity, deadOffset, true);
            UNSAFE.putInt(entity, hurtTimeOffset, 10);
            UNSAFE.putInt(entity, hurtDurationOffset, 10);
            if (damageSource != null) {
                long lastDamageSourceOffset = UnsafeUtil.getFieldOffset(LivingEntity.class, "LivingEntity.lastDamageSource");
                long lastDamageStampOffset = UnsafeUtil.getFieldOffset(LivingEntity.class, "LivingEntity.lastDamageStamp");
                UNSAFE.putObject(entity, lastDamageSourceOffset, damageSource);
                UNSAFE.putLong(entity, lastDamageStampOffset, entity.m_9236_().m_46467_());
                Entity directEntity = damageSource.m_7640_();
                if (directEntity instanceof Player) {
                    Player player = (Player)directEntity;
                    long lastHurtByPlayerOffset = UnsafeUtil.getFieldOffset(LivingEntity.class, "LivingEntity.lastHurtByPlayer");
                    long lastHurtByPlayerTimeOffset = UnsafeUtil.getFieldOffset(LivingEntity.class, "LivingEntity.lastHurtByPlayerTime");
                    UNSAFE.putObject(entity, lastHurtByPlayerOffset, player);
                    UNSAFE.putInt(entity, lastHurtByPlayerTimeOffset, 100);
                }
                if (directEntity instanceof LivingEntity) {
                    LivingEntity livingAttacker = (LivingEntity)directEntity;
                    long lastHurtByMobOffset = UnsafeUtil.getFieldOffset(LivingEntity.class, "LivingEntity.lastHurtByMob");
                    long lastHurtByMobTimeOffset = UnsafeUtil.getFieldOffset(LivingEntity.class, "LivingEntity.lastHurtByMobTimestamp");
                    UNSAFE.putObject(entity, lastHurtByMobOffset, livingAttacker);
                    UNSAFE.putInt(entity, lastHurtByMobTimeOffset, (int)entity.m_9236_().m_46467_());
                }
            }
            if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                UnsafeUtil.syncDeathToClients(entity, serverLevel);
            }
            return true;
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeSetDead failed: {}", t.getMessage());
            return false;
        }
    }

    private static void syncDeathToClients(LivingEntity entity, ServerLevel serverLevel) {
        if (entity == null) {
            return;
        }
        try {
            long entityDataOffset = UnsafeUtil.getFieldOffset(Entity.class, "Entity.entityData");
            Object synchedData = UNSAFE.getObject(entity, entityDataOffset);
            if (synchedData != null) {
                long isDirtyOffset = UnsafeUtil.getFieldOffset(SynchedEntityData.class, "SynchedEntityData.isDirty");
                UNSAFE.putBoolean(synchedData, isDirtyOffset, true);
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
            }
            serverLevel.m_7726_().m_8394_((Entity)entity, (Packet)new ClientboundSetEntityDataPacket(entity.m_19879_(), entity.m_20088_().m_252804_()));
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Failed to sync death to clients: " + e.getMessage());
        }
    }

    private static Object getMapEntry(Object map, int key) {
        if (map == null) {
            return null;
        }
        try {
            if (map instanceof Int2ObjectMap) {
                return ((Int2ObjectMap)map).get(key);
            }
            if (map instanceof Map) {
                return ((Map)map).get(key);
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            UNSAFE = (Unsafe)f.get(null);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to initialize Unsafe", t);
        }
    }
}

