/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.attack;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.attack.AttackEffectManager;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.init.TheLastSwordModAttributes;
import net.the_last_sword.util.EntityUtil;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AbsoluteDestructionDamageSource
extends DamageSource {
    private final Entity attacker;
    private final ItemStack weapon;

    public AbsoluteDestructionDamageSource(Holder<DamageType> damageType, Entity attacker, ItemStack weapon) {
        super(damageType, attacker, attacker);
        this.attacker = attacker;
        this.weapon = weapon;
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }

    public Entity m_7640_() {
        return this.attacker;
    }

    public Entity m_7639_() {
        return this.attacker;
    }

    public boolean m_7986_() {
        return false;
    }

    public boolean m_19390_() {
        return false;
    }

    public static DamageSource absoluteDestruction(Entity attacker, ItemStack weapon) {
        Registry reg = attacker.m_9236_().m_9598_().m_175515_(Registries.f_268580_);
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("the_last_sword", "absolute_destruction"));
        Holder.Reference holder = reg.m_246971_(key);
        return new AbsoluteDestructionDamageSource((Holder<DamageType>)holder, attacker, weapon);
    }

    public static DamageSource absoluteDestruction(Entity attacker) {
        ItemStack itemStack;
        if (attacker instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)attacker;
            itemStack = living.m_21205_();
        } else {
            itemStack = ItemStack.f_41583_;
        }
        return AbsoluteDestructionDamageSource.absoluteDestruction(attacker, itemStack);
    }

    public static DamageSource absoluteDestruction(Level level) {
        Registry reg = level.m_9598_().m_175515_(Registries.f_268580_);
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("the_last_sword", "absolute_destruction"));
        Holder.Reference holder = reg.m_246971_(key);
        return new AbsoluteDestructionDamageSource((Holder<DamageType>)holder, null, ItemStack.f_41583_);
    }

    public static boolean applyAbsoluteDestructionIntelligently(LivingEntity entity, DamageSource damageSource, float damageAmount) {
        float originalHealth = entity.m_21223_();
        AttributeInstance justifiedDefenceAttribute = entity.m_21051_((Attribute)TheLastSwordModAttributes.JUSTIFIED_DEFENCE.get());
        if (justifiedDefenceAttribute != null && justifiedDefenceAttribute.m_22135_() > 0.0) {
            justifiedDefenceAttribute.m_22100_(justifiedDefenceAttribute.m_22135_() - 1.0);
            return false;
        }
        if (Float.isNaN(originalHealth) || Float.isInfinite(originalHealth) || originalHealth < 0.0f) {
            EntityUtil.TheLastEndSetDead(entity, damageSource);
            return true;
        }
        float expectedHealth = originalHealth - damageAmount;
        entity.m_6469_(damageSource, damageAmount);
        float actualHealth = entity.m_21223_();
        if (actualHealth != expectedHealth) {
            EntityUtil.TheLastEndSetHealth(entity, expectedHealth);
            if (expectedHealth <= 0.0f) {
                EntityUtil.TheLastEndSetDead(entity, damageSource);
                return true;
            }
        }
        if (TheLastSwordConfiguration.getHealNegationSafely()) {
            AttackEffectManager.setHealNegation(entity, expectedHealth);
        }
        return true;
    }

    public static boolean applyAbsoluteDestructionIntelligently(LivingEntity target, Entity attacker, ItemStack weapon, float damageAmount) {
        DamageSource damageSource = AbsoluteDestructionDamageSource.absoluteDestruction(attacker, weapon);
        return AbsoluteDestructionDamageSource.applyAbsoluteDestructionIntelligently(target, damageSource, damageAmount);
    }

    public static boolean applyAbsoluteDestructionIntelligently(LivingEntity target, Entity attacker, float damageAmount) {
        DamageSource damageSource = AbsoluteDestructionDamageSource.absoluteDestruction(attacker);
        return AbsoluteDestructionDamageSource.applyAbsoluteDestructionIntelligently(target, damageSource, damageAmount);
    }
}

