/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.block;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.init.TheLastSwordModBlocks;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class DragonSoulLanternRangeRenderer {
    private static final double LANTERN_RANGE = 8.0;
    private static final double SEARCH_RANGE = 16.0;

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        List<BlockPos> activeLanterns = DragonSoulLanternRangeRenderer.findNearbyActiveLanterns((Level)mc.f_91073_, mc.f_91074_.m_20183_());
        if (activeLanterns.isEmpty()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        DragonSoulLanternRangeRenderer.renderLanternRanges(poseStack, event.getCamera(), activeLanterns);
    }

    private static List<BlockPos> findNearbyActiveLanterns(Level level, BlockPos playerPos) {
        ArrayList<BlockPos> lanterns = new ArrayList<BlockPos>();
        int range = (int)Math.ceil(16.0);
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos checkPos = playerPos.m_7918_(x, y, z);
                    if (!(playerPos.m_123331_((Vec3i)checkPos) <= 256.0) || level.m_8055_(checkPos).m_60734_() != TheLastSwordModBlocks.DRAGON_SOUL_LANTERN.get() || !DragonSoulLanternRangeRenderer.isLanternActivated(level, checkPos)) continue;
                    lanterns.add(checkPos);
                }
            }
        }
        return lanterns;
    }

    private static boolean isLanternActivated(Level level, BlockPos lanternPos) {
        BlockPos belowPos = lanternPos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        return belowState.m_60713_(Blocks.f_50080_) || belowState.m_60713_(Blocks.f_50723_);
    }

    private static void renderLanternRanges(PoseStack poseStack, Camera camera, List<BlockPos> lanterns) {
        Vec3 cameraPos = camera.m_90583_();
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        BufferBuilder bufferBuilder = new BufferBuilder(256);
        MultiBufferSource.BufferSource immediateBufferSource = MultiBufferSource.m_109898_((BufferBuilder)bufferBuilder);
        VertexConsumer buffer = immediateBufferSource.m_6299_(RenderType.m_110504_());
        float time = (float)(System.currentTimeMillis() % 2000L) / 2000.0f;
        float alpha = 0.4f + 0.3f * (float)Math.sin((double)time * Math.PI * 2.0);
        float red = 0.5f;
        float green = 0.0f;
        float blue = 1.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        for (BlockPos lanternPos : lanterns) {
            DragonSoulLanternRangeRenderer.renderRangeBox(buffer, matrix, lanternPos, red, green, blue, alpha);
        }
        immediateBufferSource.m_109911_();
        poseStack.m_85849_();
    }

    private static void renderRangeBox(VertexConsumer buffer, Matrix4f matrix, BlockPos center, float red, float green, float blue, float alpha) {
        int range = 8;
        float x1 = center.m_123341_() - range;
        float y1 = center.m_123342_() - range;
        float z1 = center.m_123343_() - range;
        float x2 = center.m_123341_() + range + 1;
        float y2 = center.m_123342_() + range + 1;
        float z2 = center.m_123343_() + range + 1;
        DragonSoulLanternRangeRenderer.addLine(buffer, matrix, x1, y1, z1, x2, y1, z1, red, green, blue, alpha);
        DragonSoulLanternRangeRenderer.addLine(buffer, matrix, x2, y1, z1, x2, y1, z2, red, green, blue, alpha);
        DragonSoulLanternRangeRenderer.addLine(buffer, matrix, x2, y1, z2, x1, y1, z2, red, green, blue, alpha);
        DragonSoulLanternRangeRenderer.addLine(buffer, matrix, x1, y1, z2, x1, y1, z1, red, green, blue, alpha);
        DragonSoulLanternRangeRenderer.addLine(buffer, matrix, x1, y2, z1, x2, y2, z1, red, green, blue, alpha);
        DragonSoulLanternRangeRenderer.addLine(buffer, matrix, x2, y2, z1, x2, y2, z2, red, green, blue, alpha);
        DragonSoulLanternRangeRenderer.addLine(buffer, matrix, x2, y2, z2, x1, y2, z2, red, green, blue, alpha);
        DragonSoulLanternRangeRenderer.addLine(buffer, matrix, x1, y2, z2, x1, y2, z1, red, green, blue, alpha);
        DragonSoulLanternRangeRenderer.addLine(buffer, matrix, x1, y1, z1, x1, y2, z1, red, green, blue, alpha);
        DragonSoulLanternRangeRenderer.addLine(buffer, matrix, x2, y1, z1, x2, y2, z1, red, green, blue, alpha);
        DragonSoulLanternRangeRenderer.addLine(buffer, matrix, x2, y1, z2, x2, y2, z2, red, green, blue, alpha);
        DragonSoulLanternRangeRenderer.addLine(buffer, matrix, x1, y1, z2, x1, y2, z2, red, green, blue, alpha);
    }

    private static void addLine(VertexConsumer buffer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha) {
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }
}

