/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.capability;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.the_last_sword.capability.IMode;

public class DefaultMode
implements IMode {
    private int mode;
    private final int maxModes;
    private final String[] modeKeys;

    public DefaultMode(int defaultMode, int maxModes, String[] modeKeys) {
        this.mode = defaultMode % maxModes;
        this.maxModes = maxModes;
        this.modeKeys = modeKeys;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode % this.maxModes;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public int getMaxModes() {
        return this.maxModes;
    }

    @Override
    public String getModeTextKey(int m) {
        return this.modeKeys[m % this.maxModes];
    }

    @Override
    public Tag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("mode", this.mode);
        return tag;
    }

    @Override
    public void readNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)nbt;
            this.mode = tag.m_128451_("mode") % this.maxModes;
        }
    }
}

