/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.capability;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.capability.ExtraAttackDamageProvider;
import net.the_last_sword.capability.ExtraProtectionProvider;
import net.the_last_sword.capability.ForgeEnergyProvider;
import net.the_last_sword.capability.IExtraAttackDamage;
import net.the_last_sword.capability.IExtraProtection;
import net.the_last_sword.capability.IItemJustifiedDefence;
import net.the_last_sword.capability.ILevel;
import net.the_last_sword.capability.IMode;
import net.the_last_sword.capability.ItemJustifiedDefenceProvider;
import net.the_last_sword.capability.LevelProvider;
import net.the_last_sword.capability.ModeProvider;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.init.TheLastSwordModItems;
import net.the_last_sword.item.DragonArmor;
import net.the_last_sword.item.DragonCrystalArmor;
import net.the_last_sword.item.DragonCrystalSword;
import net.the_last_sword.item.DragonSword;
import net.the_last_sword.item.TheLastEndSword;
import net.the_last_sword.test.UltraTestSwordItem;

@Mod.EventBusSubscriber(modid="the_last_sword")
public final class ItemCapability {
    public static final Capability<ILevel> LEVEL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ILevel>(){});
    public static final Capability<IExtraAttackDamage> EXTRA_ATTACK_DAMAGE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IExtraAttackDamage>(){});
    public static final Capability<IExtraProtection> EXTRA_PROTECTION_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IExtraProtection>(){});
    public static final Capability<IMode> MODE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IMode>(){});
    public static final Capability<IItemJustifiedDefence> Item_JUSTIFIED_DEFENCE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemJustifiedDefence>(){});

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent evt) {
        evt.register(ILevel.class);
        evt.register(IExtraAttackDamage.class);
        evt.register(IExtraProtection.class);
        evt.register(IMode.class);
        evt.register(IItemJustifiedDefence.class);
    }

    @SubscribeEvent
    public static void attachItemCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        if (stack.m_41720_() instanceof DragonCrystalSword) {
            evt.addCapability(ItemCapability.rl("level"), (ICapabilityProvider)new LevelProvider(0));
            evt.addCapability(ItemCapability.rl("extra_attack_damage"), (ICapabilityProvider)new ExtraAttackDamageProvider(0));
        }
        if (stack.m_41720_() instanceof DragonCrystalArmor) {
            evt.addCapability(ItemCapability.rl("level"), (ICapabilityProvider)new LevelProvider(0));
            evt.addCapability(ItemCapability.rl("extra_protection"), (ICapabilityProvider)new ExtraProtectionProvider(0));
            evt.addCapability(ItemCapability.rl("item_justified_defence"), (ICapabilityProvider)new ItemJustifiedDefenceProvider(0.0));
        }
        if (stack.m_41720_() instanceof DragonArmor) {
            evt.addCapability(ItemCapability.rl("level"), (ICapabilityProvider)new LevelProvider(6));
            evt.addCapability(ItemCapability.rl("extra_protection"), (ICapabilityProvider)new ExtraProtectionProvider(6));
            evt.addCapability(ItemCapability.rl("item_justified_defence"), (ICapabilityProvider)new ItemJustifiedDefenceProvider(6.0));
            evt.addCapability(ItemCapability.rl("forge_energy"), (ICapabilityProvider)new ForgeEnergyProvider(stack, TheLastSwordConfiguration.getDragonArmorMaxEnergySafely()));
        }
        if (stack.m_41720_() instanceof DragonSword) {
            evt.addCapability(ItemCapability.rl("level"), (ICapabilityProvider)new LevelProvider(6));
            evt.addCapability(ItemCapability.rl("extra_attack_damage"), (ICapabilityProvider)new ExtraAttackDamageProvider(6));
            evt.addCapability(ItemCapability.rl("mode"), (ICapabilityProvider)new ModeProvider(0, 2, new String[]{"item_tooltip.the_last_sword.normal_mode", "item_tooltip.the_last_sword.summon_entity_mode"}));
        }
        if (stack.m_41720_() instanceof TheLastEndSword) {
            evt.addCapability(ItemCapability.rl("level"), (ICapabilityProvider)new LevelProvider(13));
            evt.addCapability(ItemCapability.rl("extra_attack_damage"), (ICapabilityProvider)new ExtraAttackDamageProvider(13));
            evt.addCapability(ItemCapability.rl("item_justified_defence"), (ICapabilityProvider)new ItemJustifiedDefenceProvider(200.0));
            evt.addCapability(ItemCapability.rl("mode"), (ICapabilityProvider)new ModeProvider(0, 3, new String[]{"item_tooltip.the_last_sword.normal_mode", "item_tooltip.the_last_sword.powerful_mining_mode", "item_tooltip.the_last_sword.summon_entity_mode"}));
        }
        if (stack.m_41720_() instanceof UltraTestSwordItem) {
            evt.addCapability(ItemCapability.rl("item_justified_defence"), (ICapabilityProvider)new ItemJustifiedDefenceProvider(1024.0));
            evt.addCapability(ItemCapability.rl("mode"), (ICapabilityProvider)new ModeProvider(0, 2, new String[]{"item_tooltip.the_last_sword.normal_mode", "item_tooltip.the_last_sword.defense_mode"}));
        }
        if (stack.m_41720_() == TheLastSwordModItems.DRAGON_SOUL_LANTERN.get()) {
            evt.addCapability(ItemCapability.rl("level"), (ICapabilityProvider)new LevelProvider(1));
            evt.addCapability(ItemCapability.rl("mode"), (ICapabilityProvider)new ModeProvider(0, 1, new String[]{"item_tooltip.the_last_sword.summon_entity_mode"}));
        }
    }

    private static ResourceLocation rl(String path) {
        return new ResourceLocation("the_last_sword", path);
    }
}

