/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.the_last_sword.capability.DefaultItemJustifiedDefence;
import net.the_last_sword.capability.IItemJustifiedDefence;
import net.the_last_sword.capability.ItemCapability;

public class ItemJustifiedDefenceProvider
implements ICapabilitySerializable<Tag> {
    private final IItemJustifiedDefence impl;
    private final LazyOptional<IItemJustifiedDefence> holder;

    public ItemJustifiedDefenceProvider(double defaultDefence) {
        this.impl = new DefaultItemJustifiedDefence(defaultDefence);
        this.holder = LazyOptional.of(() -> this.impl);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == ItemCapability.Item_JUSTIFIED_DEFENCE_CAPABILITY ? this.holder.cast() : LazyOptional.empty();
    }

    public Tag serializeNBT() {
        return this.impl.writeNBT();
    }

    public void deserializeNBT(Tag nbt) {
        this.impl.readNBT(nbt);
    }
}

