/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.the_last_sword.client.hud.HudConfig;
import net.the_last_sword.init.TheLastSwordModAttributes;

public class AttributeHudRenderer {
    public static final ResourceLocation ICON_FULL = new ResourceLocation("the_last_sword", "textures/screens/justified_defence_full.png");
    public static final ResourceLocation ICON_EMPTY = new ResourceLocation("the_last_sword", "textures/screens/justified_defence_empty.png");
    private static final int ICON_SIZE = 9;
    private static final int ICON_SPACING = -8;
    private static final int MAX_ICONS = 10;
    private static final double POINTS_PER_ICON = 2.0;

    public static void renderAttributes(GuiGraphics gui, int screenWidth, int screenHeight, Minecraft mc) {
        LocalPlayer player = mc.f_91074_;
        if (player == null || !AttributeHudRenderer.shouldRender((Player)player)) {
            return;
        }
        mc.m_91307_().m_6180_("attributeHud");
        int baseX = screenWidth / 2 + 91 - 9;
        int baseY = screenHeight - AttributeHudRenderer.getRightHeightOffset(mc) - 10;
        int startX = baseX + HudConfig.offset.x;
        int startY = baseY + HudConfig.offset.y;
        double currentShield = player.m_21133_((Attribute)TheLastSwordModAttributes.JUSTIFIED_DEFENCE.get());
        double maxShield = player.m_21133_((Attribute)TheLastSwordModAttributes.MAX_JUSTIFIED_DEFENCE.get());
        if (currentShield <= 0.0) {
            mc.m_91307_().m_7238_();
            return;
        }
        int fullIcons = (int)Math.floor(currentShield / 2.0);
        boolean halfIcon = (fullIcons = Math.min(fullIcons, 10)) < 10 && currentShield % 2.0 >= 1.0;
        int emptyIcons = 10 - fullIcons - (halfIcon ? 1 : 0);
        int step = 8;
        int leftX = startX + -72;
        RenderSystem.enableBlend();
        for (int i = 0; i < fullIcons; ++i) {
            int x = leftX + i * step;
            gui.m_280163_(ICON_FULL, x, startY, 0.0f, 0.0f, 9, 9, 9, 9);
        }
        if (halfIcon) {
            int x = leftX + fullIcons * step;
            int halfWidth = 4;
            gui.m_280163_(ICON_FULL, x, startY, 0.0f, 0.0f, halfWidth, 9, 9, 9);
        }
        int offset = fullIcons + (halfIcon ? 1 : 0);
        for (int i = 0; i < emptyIcons; ++i) {
            int x = leftX + (offset + i) * step;
            gui.m_280163_(ICON_EMPTY, x, startY, 0.0f, 0.0f, 9, 9, 9, 9);
        }
        double visibleCapacity = 20.0;
        if (currentShield > visibleCapacity) {
            double overflowPoints = currentShield - visibleCapacity;
            double rawIcons = overflowPoints / 2.0;
            int wholeIcons = (int)Math.floor(rawIcons);
            boolean halfOverflow = overflowPoints % 2.0 >= 1.0;
            String text = halfOverflow ? "+" + wholeIcons + ".5" : "+" + wholeIcons;
            int textX = leftX + 10 * step + 9 - 4;
            int textY = startY + 2;
            gui.m_280056_(mc.f_91062_, text, textX, textY, 0xFFFFFF, true);
        }
        RenderSystem.disableBlend();
        mc.m_91307_().m_7238_();
    }

    private static boolean shouldRender(Player player) {
        return !player.m_7500_() && !player.m_5833_();
    }

    public static int getRightHeightOffset(Minecraft mc) {
        return ((ForgeGui)mc.f_91065_).rightHeight;
    }
}

